/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging;

import io.confluent.common.logging.SerializableSchemaAndValue;
import io.confluent.common.logging.StructuredLogger;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.slf4j.Logger;

final class StructuredLoggerImpl
implements StructuredLogger {
    private static final String LOG_MSG = "{}";
    private final Logger inner;

    StructuredLoggerImpl(Logger inner) {
        this.inner = inner;
    }

    @Override
    public String getName() {
        return this.inner.getName();
    }

    @Override
    public void error(Supplier<SchemaAndValue> msgSupplier) {
        if (!this.inner.isErrorEnabled()) {
            return;
        }
        this.error(msgSupplier.get());
    }

    @Override
    public void error(SchemaAndValue msg) {
        this.inner.error(LOG_MSG, (Object)new SerializableSchemaAndValue(msg));
    }

    @Override
    public void info(Supplier<SchemaAndValue> msgSupplier) {
        if (!this.inner.isInfoEnabled()) {
            return;
        }
        this.info(msgSupplier.get());
    }

    @Override
    public void info(SchemaAndValue msg) {
        this.inner.info(LOG_MSG, (Object)new SerializableSchemaAndValue(msg));
    }

    @Override
    public void debug(Supplier<SchemaAndValue> msgSupplier) {
        if (!this.inner.isDebugEnabled()) {
            return;
        }
        this.debug(msgSupplier.get());
    }

    @Override
    public void debug(SchemaAndValue msg) {
        this.inner.debug(LOG_MSG, (Object)new SerializableSchemaAndValue(msg));
    }
}

