/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test;

import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.tree.AssertStatement;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.tools.test.model.LocationWithinFile;
import io.confluent.ksql.tools.test.parser.TestDirective;
import io.confluent.ksql.tools.test.parser.TestStatement;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.ParserUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;

public class KsqlTestException
extends KsqlException {
    public KsqlTestException(TestStatement statement, Path file, Throwable cause) {
        super(KsqlTestException.getMessage(statement, cause.getMessage(), file), cause);
    }

    public KsqlTestException(TestStatement statement, Path file, String message) {
        super(KsqlTestException.getMessage(statement, message, file));
    }

    private static String getMessage(TestStatement stmt, String message, Path file) {
        Path srcFile = file == null ? null : KsqlTestException.toSourcePath(file);
        return stmt.apply(parsed -> KsqlTestException.engineMessage(parsed, message, srcFile), assertStatement -> KsqlTestException.assertMessage(assertStatement, message, srcFile), directive -> KsqlTestException.directiveMessage(directive, message, srcFile));
    }

    private static String engineMessage(KsqlParser.ParsedStatement parsedStatement, String message, Path file) {
        Optional loc = ParserUtil.getLocation((ParserRuleContext)parsedStatement.getStatement());
        return String.format("Test failure for statement `%s` (%s):%n\t%s%n\t%s", parsedStatement.getMaskedStatementText(), loc.map(NodeLocation::toString).orElse("unknown"), message, KsqlTestException.getFileLocation(file, loc.map(NodeLocation::getStartLineNumber).orElse(1)));
    }

    private static String assertMessage(AssertStatement assertStatement, String message, Path file) {
        return String.format("Test failure for assert `%s` (%s):%n\t%s%n\t%s", SqlFormatter.formatSql((AstNode)assertStatement), assertStatement.getLocation().map(Objects::toString).orElse("unknown"), message, KsqlTestException.getFileLocation(file, assertStatement.getLocation().map(NodeLocation::getStartLineNumber).orElse(1)));
    }

    private static String directiveMessage(TestDirective directive, String message, Path file) {
        return String.format("Test failure during directive evaluation `%s` (%s):%n\t%s%s", directive, directive.getLocation(), message, KsqlTestException.getFileLocation(file, directive.getLocation().getStartLineNumber()));
    }

    private static String getFileLocation(Path file, int startLineNumber) {
        return file == null ? "" : "%n\t" + new LocationWithinFile(file, startLineNumber).toString();
    }

    private static Path toSourcePath(Path path) {
        Path converted = Paths.get(path.toAbsolutePath().toString().replace("/target/test-classes", "/src/test/resources/"), new String[0]);
        return Files.exists(converted, new LinkOption[0]) ? converted : path;
    }
}

