/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.ServiceInfo;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.engine.generic.GenericRecordFactory;
import io.confluent.ksql.engine.generic.KsqlGenericRecord;
import io.confluent.ksql.format.DefaultFormatInjector;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStoreImpl;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.AssertTable;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.AlterSource;
import io.confluent.ksql.parser.tree.AssertStatement;
import io.confluent.ksql.parser.tree.AssertStream;
import io.confluent.ksql.parser.tree.AssertTombstone;
import io.confluent.ksql.parser.tree.AssertValues;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.DropStatement;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.properties.PropertyOverrider;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.query.id.SequentialQueryIdGenerator;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.services.DefaultConnectClient;
import io.confluent.ksql.services.DefaultServiceContext;
import io.confluent.ksql.services.DisabledKsqlClient;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.tools.test.KsqlTestException;
import io.confluent.ksql.tools.test.TestFunctionRegistry;
import io.confluent.ksql.tools.test.driver.AssertExecutor;
import io.confluent.ksql.tools.test.driver.TestDriverPipeline;
import io.confluent.ksql.tools.test.parser.SqlTestLoader;
import io.confluent.ksql.tools.test.parser.TestDirective;
import io.confluent.ksql.tools.test.parser.TestStatement;
import io.confluent.ksql.tools.test.stubs.StubKafkaClientSupplier;
import io.confluent.ksql.tools.test.stubs.StubKafkaConsumerGroupClient;
import io.confluent.ksql.tools.test.stubs.StubKafkaTopicClient;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTestExecutor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SqlTestExecutor.class);
    private static final ImmutableMap<String, Object> BASE_CONFIG = ImmutableMap.builder().put((Object)"bootstrap.servers", (Object)"localhost:0").put((Object)"auto.commit.interval.ms", (Object)0).put((Object)"auto.offset.reset", (Object)"earliest").put((Object)"cache.max.bytes.buffering", (Object)0).put((Object)"max.task.idle.ms", (Object)0L).put((Object)"ksql.service.id", (Object)"some.ksql.service.id").put((Object)"ksql.headers.columns.enabled", (Object)true).build();
    private ServiceContext serviceContext;
    private KsqlEngine engine;
    private KsqlConfig config;
    private TestDriverPipeline driverPipeline;
    private Injector formatInjector;
    private KafkaTopicClient topicClient;
    private Path tmpFolder;
    private final Map<String, Object> overrides;
    private final Map<QueryId, DriverAndProperties> drivers;
    private Class<? extends Throwable> expectedException;
    private String expectedMessage;

    public static SqlTestExecutor create(final Path tmpFolder) {
        StubKafkaTopicClient topicClient = new StubKafkaTopicClient();
        StubKafkaClientSupplier kafkaClientSupplier = new StubKafkaClientSupplier();
        MockSchemaRegistryClient srClient = new MockSchemaRegistryClient();
        DefaultServiceContext serviceContext = new DefaultServiceContext((KafkaClientSupplier)kafkaClientSupplier, () -> kafkaClientSupplier.getAdmin(Collections.emptyMap()), () -> kafkaClientSupplier.getAdmin(Collections.emptyMap()), (KafkaTopicClient)topicClient, () -> SqlTestExecutor.lambda$create$2((SchemaRegistryClient)srClient), () -> new DefaultConnectClient("http://localhost:8083", Optional.empty(), Collections.emptyMap(), Optional.empty(), false, KsqlConfig.CONNECT_REQUEST_TIMEOUT_DEFAULT.longValue()), DisabledKsqlClient::instance, (KafkaConsumerGroupClient)new StubKafkaConsumerGroupClient());
        final HashMap<QueryId, DriverAndProperties> drivers = new HashMap<QueryId, DriverAndProperties>();
        KsqlConfig config = new KsqlConfig(BASE_CONFIG);
        return new SqlTestExecutor((ServiceContext)serviceContext, topicClient, new KsqlEngine((ServiceContext)serviceContext, NoopProcessingLogContext.INSTANCE, (FunctionRegistry)new MetaStoreImpl(TestFunctionRegistry.INSTANCE.get()), ServiceInfo.create((KsqlConfig)config), (QueryIdGenerator)new SequentialQueryIdGenerator(), config, Collections.singletonList(new QueryEventListener(){

            public void onDeregister(QueryMetadata query) {
                DriverAndProperties driverAndProperties = (DriverAndProperties)drivers.get(query.getQueryId());
                SqlTestExecutor.closeDriver(driverAndProperties.driver, driverAndProperties.properties, false, tmpFolder);
            }
        }), new MetricCollectors()), config, drivers, tmpFolder);
    }

    SqlTestExecutor(ServiceContext serviceContext, KafkaTopicClient topicClient, KsqlEngine ksqlEngine, KsqlConfig config, Map<QueryId, DriverAndProperties> drivers, Path tmpFolder) {
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.engine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.config = config.cloneWithPropertyOverwrite((Map)ImmutableMap.of());
        this.driverPipeline = new TestDriverPipeline();
        this.formatInjector = new DefaultFormatInjector();
        this.topicClient = Objects.requireNonNull(topicClient, "topicClient");
        this.overrides = new HashMap<String, Object>();
        this.drivers = drivers;
        this.tmpFolder = Objects.requireNonNull(tmpFolder, "tmpFolder");
    }

    public void executeTest(SqlTestLoader.SqlTest test) {
        for (TestStatement statement : test.getStatements()) {
            try {
                statement.consume(this::execute, this::doAssert, this::directive);
            }
            catch (Throwable e) {
                this.handleExpectedException(test.getFile(), statement, e);
                return;
            }
        }
        if (this.expectedException != null || this.expectedMessage != null) {
            String clazz = this.expectedException == null ? "<any>" : this.expectedException.getName();
            String msg = this.expectedMessage == null ? "<any>" : this.expectedMessage;
            throw new KsqlTestException((TestStatement)Iterables.getLast(test.getStatements()), test.getFile(), "Did not get expected exception of type " + clazz + " with message " + msg);
        }
    }

    private void doAssert(AssertStatement statement) {
        if (statement instanceof AssertValues) {
            AssertExecutor.assertValues((KsqlExecutionContext)this.engine, this.config, (AssertValues)statement, this.driverPipeline);
        } else if (statement instanceof AssertTombstone) {
            AssertExecutor.assertTombstone((KsqlExecutionContext)this.engine, this.config, (AssertTombstone)statement, this.driverPipeline);
        } else if (statement instanceof AssertStream) {
            AssertExecutor.assertStream((KsqlExecutionContext)this.engine, this.config, (AssertStream)statement);
        } else if (statement instanceof AssertTable) {
            AssertExecutor.assertTable((KsqlExecutionContext)this.engine, this.config, (AssertTable)statement);
        }
    }

    private void execute(KsqlParser.ParsedStatement parsedStatement) {
        KsqlParser.PreparedStatement engineStatement = this.engine.prepare(parsedStatement);
        ConfiguredStatement configured = ConfiguredStatement.of((KsqlParser.PreparedStatement)engineStatement, (SessionConfig)SessionConfig.of((KsqlConfig)this.config, this.overrides));
        this.createTopics(engineStatement);
        if (engineStatement.getStatement() instanceof InsertValues) {
            this.pipeInput((ConfiguredStatement<InsertValues>)configured);
            return;
        }
        if (engineStatement.getStatement() instanceof SetProperty) {
            PropertyOverrider.set((ConfiguredStatement)configured, this.overrides);
            return;
        }
        if (engineStatement.getStatement() instanceof UnsetProperty) {
            PropertyOverrider.unset((ConfiguredStatement)configured, this.overrides);
            return;
        }
        ConfiguredStatement injected = this.formatInjector.inject(configured);
        KsqlExecutionContext.ExecuteResult result = this.engine.execute(this.serviceContext, injected);
        if (!result.getQuery().isPresent()) {
            if (injected.getStatement() instanceof DropStatement) {
                return;
            }
            SourceName name = injected.getStatement() instanceof CreateSource ? ((CreateSource)injected.getStatement()).getName() : ((AlterSource)injected.getStatement()).getName();
            DataSource input = this.engine.getMetaStore().getSource(name);
            TestDriverPipeline.TopicInfo inputTopic = new TestDriverPipeline.TopicInfo(input.getKafkaTopicName(), this.keySerde(input), this.valueSerde(input));
            this.driverPipeline.addDdlTopic(inputTopic);
            return;
        }
        PersistentQueryMetadata query = (PersistentQueryMetadata)result.getQuery().get();
        Topology topology = query.getTopology();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)query.getStreamsProperties());
        properties.put("state.dir", this.tmpFolder.toString());
        TopologyTestDriver driver = new TopologyTestDriver(topology, properties);
        List<TestDriverPipeline.TopicInfo> inputTopics = query.getSourceNames().stream().map(sn -> this.engine.getMetaStore().getSource(sn)).map(ds -> new TestDriverPipeline.TopicInfo(ds.getKafkaTopicName(), this.keySerde((DataSource)ds), this.valueSerde((DataSource)ds))).collect(Collectors.toList());
        DataSource output = this.engine.getMetaStore().getSource((SourceName)query.getSinkName().get());
        TestDriverPipeline.TopicInfo outputInfo = new TestDriverPipeline.TopicInfo(output.getKafkaTopicName(), this.keySerde(output), this.valueSerde(output));
        this.driverPipeline.addDriver(driver, inputTopics, outputInfo);
        this.drivers.put(query.getQueryId(), new DriverAndProperties(driver, properties));
    }

    private void pipeInput(ConfiguredStatement<InsertValues> statement) {
        InsertValues insertValues = (InsertValues)statement.getStatement();
        DataSource dataSource = this.engine.getMetaStore().getSource(insertValues.getTarget());
        if (dataSource == null) {
            throw new KsqlException("Unknown data source " + insertValues.getTarget());
        }
        KsqlGenericRecord record = new GenericRecordFactory(this.config, (FunctionRegistry)this.engine.getMetaStore(), System::currentTimeMillis).build(insertValues.getColumns(), insertValues.getValues(), dataSource.getSchema(), dataSource.getDataSourceType());
        this.driverPipeline.pipeInput(dataSource.getKafkaTopicName(), record.key, record.value, record.ts);
    }

    private Serde<?> keySerde(DataSource sinkSource) {
        PersistenceSchema schema = PersistenceSchema.from((List)sinkSource.getSchema().key(), (SerdeFeatures)sinkSource.getKsqlTopic().getKeyFormat().getFeatures());
        if (sinkSource.getKsqlTopic().getKeyFormat().getWindowInfo().isPresent()) {
            return new GenericKeySerDe().create(sinkSource.getKsqlTopic().getKeyFormat().getFormatInfo(), (WindowInfo)sinkSource.getKsqlTopic().getKeyFormat().getWindowInfo().get(), schema, this.config, this.serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
        }
        return new GenericKeySerDe().create(sinkSource.getKsqlTopic().getKeyFormat().getFormatInfo(), schema, this.config, this.serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
    }

    private Serde<GenericRow> valueSerde(DataSource sinkSource) {
        return GenericRowSerDe.from((FormatInfo)sinkSource.getKsqlTopic().getValueFormat().getFormatInfo(), (PersistenceSchema)PersistenceSchema.from((List)sinkSource.getSchema().value(), (SerdeFeatures)sinkSource.getKsqlTopic().getValueFormat().getFeatures()), (KsqlConfig)this.config, (Supplier)this.serviceContext.getSchemaRegistryClientFactory(), (String)"", (ProcessingLogContext)NoopProcessingLogContext.INSTANCE);
    }

    private void directive(TestDirective directive) {
        try {
            switch (directive.getType()) {
                case EXPECTED_ERROR: {
                    this.handleExpectedClass(directive);
                    break;
                }
                case EXPECTED_MESSAGE: {
                    this.handleExpectedMessage(directive);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new KsqlException("Failed to handle directive " + directive, (Throwable)e);
        }
    }

    private void handleExpectedException(Path file, TestStatement testStatement, Throwable e) {
        if (this.expectedException == null && this.expectedMessage == null) {
            throw new KsqlTestException(testStatement, file, e);
        }
        if (!e.getMessage().contains(this.expectedMessage)) {
            throw new KsqlTestException(testStatement, file, "Expected exception with message \"" + this.expectedMessage + "\" but got " + e);
        }
        if (!this.expectedException.isInstance(e)) {
            throw new KsqlTestException(testStatement, file, "Expected exception with class " + this.expectedException + " but got " + e);
        }
    }

    private void handleExpectedClass(TestDirective directive) throws ClassNotFoundException {
        this.expectedException = Class.forName(directive.getContents());
    }

    private void handleExpectedMessage(TestDirective directive) {
        this.expectedMessage = directive.getContents();
    }

    private static void closeDriver(TopologyTestDriver driver, Properties properties, boolean deleteState, Path tmpFolder) {
        String appId = properties.getProperty("application.id");
        File stateDir = tmpFolder.resolve(appId).toFile();
        File tmp = tmpFolder.resolve("tmp_" + appId).toFile();
        if (!deleteState && stateDir.exists()) {
            try {
                FileUtils.copyDirectory((File)stateDir, (File)tmp);
            }
            catch (IOException e) {
                if (!(e instanceof NoSuchFileException)) {
                    throw new KsqlException((Throwable)e);
                }
                LOG.warn("The state or temp directory '{}' do not exist. The test will continue closing the driver.", (Object)((NoSuchFileException)e).getFile());
            }
        }
        try {
            driver.close();
            if (tmp.exists()) {
                FileUtils.copyDirectory((File)tmp, (File)stateDir);
                FileUtils.deleteDirectory((File)tmp);
            }
        }
        catch (IOException e) {
            throw new KsqlException((Throwable)e);
        }
    }

    private void createTopics(KsqlParser.PreparedStatement<?> engineStatement) {
        if (engineStatement.getStatement() instanceof CreateSource) {
            CreateSource statement = (CreateSource)engineStatement.getStatement();
            this.topicClient.createTopic(statement.getProperties().getKafkaTopic(), statement.getProperties().getPartitions().orElse(1).intValue(), statement.getProperties().getReplicas().orElse((short)1).shortValue(), (Map)ImmutableMap.of());
        } else if (engineStatement.getStatement() instanceof CreateAsSelect) {
            CreateAsSelect statement = (CreateAsSelect)engineStatement.getStatement();
            this.topicClient.createTopic(statement.getProperties().getKafkaTopic().orElse(statement.getName().toString(FormatOptions.noEscape()).toUpperCase()), statement.getProperties().getPartitions().orElse(1).intValue(), statement.getProperties().getReplicas().orElse((short)1).shortValue(), (Map)ImmutableMap.of());
        }
    }

    @Override
    public void close() {
        this.engine.close(true);
        this.serviceContext.close();
    }

    private static /* synthetic */ SchemaRegistryClient lambda$create$2(SchemaRegistryClient srClient) {
        return srClient;
    }

    private static final class DriverAndProperties {
        final TopologyTestDriver driver;
        final Properties properties;

        private DriverAndProperties(TopologyTestDriver driver, Properties properties) {
            this.driver = driver;
            this.properties = properties;
        }
    }
}

