/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.driver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.engine.generic.GenericRecordFactory;
import io.confluent.ksql.engine.generic.KsqlGenericRecord;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.AssertTable;
import io.confluent.ksql.parser.tree.AssertStream;
import io.confluent.ksql.parser.tree.AssertTombstone;
import io.confluent.ksql.parser.tree.AssertValues;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.tools.test.driver.TestDriverPipeline;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.TabularRow;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.test.TestRecord;

public final class AssertExecutor {
    @VisibleForTesting
    static final List<SourceProperty> MUST_MATCH = ImmutableList.builder().add((Object)new SourceProperty(DataSource::getSchema, (cs, cfg) -> cs.getElements().toLogicalSchema(), "schema", new String[0])).add((Object)new SourceProperty(DataSource::getDataSourceType, (cs, cfg) -> cs instanceof CreateTable ? DataSource.DataSourceType.KTABLE : DataSource.DataSourceType.KSTREAM, "type", new String[0])).add((Object)new SourceProperty(DataSource::getKafkaTopicName, (cs, cfg) -> cs.getProperties().getKafkaTopic(), "kafka topic", new String[]{"KAFKA_TOPIC"})).add((Object)new SourceProperty(ds -> ds.getKsqlTopic().getKeyFormat().getFormatInfo().getFormat(), (cs, cfg) -> cs.getProperties().getKeyFormat(cs.getName()).map(FormatInfo::getFormat).orElse(cfg.getString("ksql.persistence.default.format.key")), "key format", new String[]{"KEY_FORMAT", "FORMAT"})).add((Object)new SourceProperty(ds -> ds.getKsqlTopic().getKeyFormat().getFormatInfo().getProperties(), (cs, cfg) -> cs.getProperties().getKeyFormatProperties(cs.getProperties().getKeyFormat(cs.getName()).map(FormatInfo::getFormat).orElse(cfg.getString("ksql.persistence.default.format.key")), cs.getName().text()), "key format properties", new String[]{"KEY_DELIMITER", "KEY_SCHEMA_FULL_NAME", "KEY_PROTOBUF_NULLABLE_REPRESENTATION"})).add((Object)new SourceProperty(ds -> ds.getKsqlTopic().getValueFormat().getFormatInfo().getFormat(), (cs, cfg) -> cs.getProperties().getValueFormat().map(FormatInfo::getFormat).orElse(cfg.getString("ksql.persistence.default.format.value")), "value format", new String[]{"VALUE_FORMAT", "FORMAT"})).add((Object)new SourceProperty(ds -> ds.getKsqlTopic().getValueFormat().getFormatInfo().getProperties(), (cs, cfg) -> cs.getProperties().getValueFormatProperties(cs.getProperties().getValueFormat().map(FormatInfo::getFormat).orElse(cfg.getString("ksql.persistence.default.format.value"))), "value format properties", new String[]{"VALUE_AVRO_SCHEMA_FULL_NAME", "VALUE_SCHEMA_FULL_NAME", "VALUE_DELIMITER", "VALUE_PROTOBUF_NULLABLE_REPRESENTATION"})).add((Object)new SourceProperty(ds -> (String)ds.getKsqlTopic().getValueFormat().getFormatInfo().getProperties().get("VALUE_SCHEMA_ID"), (cs, cfg) -> cs.getProperties().getValueSchemaId().map(String::valueOf).orElse(null), "value schema id", new String[]{"VALUE_SCHEMA_ID"})).add((Object)new SourceProperty(ds -> (String)ds.getKsqlTopic().getKeyFormat().getFormatInfo().getProperties().get("KEY_SCHEMA_ID"), (cs, cfg) -> cs.getProperties().getKeySchemaId().map(String::valueOf).orElse(null), "key schema id", new String[]{"KEY_SCHEMA_ID"})).add((Object)new SourceProperty(ds -> ds.getKsqlTopic().getValueFormat().getFeatures(), (cs, cfg) -> cs.getProperties().getValueSerdeFeatures(), "value serde features", new String[]{"WRAP_SINGLE_VALUE"})).add((Object)new SourceProperty(ds -> ds.getTimestampColumn().map(TimestampColumn::getColumn), (cs, cfg) -> cs.getProperties().getTimestampColumnName(), "timestamp column", new String[]{"TIMESTAMP"})).add((Object)new SourceProperty(ds -> ds.getTimestampColumn().flatMap(TimestampColumn::getFormat), (cs, cfg) -> cs.getProperties().getTimestampFormat(), "timestamp format", new String[]{"TIMESTAMP_FORMAT"})).build();

    private AssertExecutor() {
    }

    public static void assertValues(KsqlExecutionContext engine, KsqlConfig config, AssertValues assertValues, TestDriverPipeline driverPipeline) {
        InsertValues values = assertValues.getStatement();
        AssertExecutor.assertContent(engine, config, values, driverPipeline, false);
    }

    public static void assertTombstone(KsqlExecutionContext engine, KsqlConfig config, AssertTombstone assertTombstone, TestDriverPipeline driverPipeline) {
        InsertValues values = assertTombstone.getStatement();
        AssertExecutor.assertContent(engine, config, values, driverPipeline, true);
    }

    private static void assertContent(KsqlExecutionContext engine, KsqlConfig config, InsertValues values, TestDriverPipeline driverPipeline, boolean isTombstone) {
        TestRecord<GenericKey, GenericRow> actualTestRecord;
        GenericKey actualKey;
        KsqlGenericRecord actual;
        DataSource dataSource = engine.getMetaStore().getSource(values.getTarget());
        KsqlGenericRecord expected = new GenericRecordFactory(config, (FunctionRegistry)engine.getMetaStore(), System::currentTimeMillis).build(values.getColumns(), values.getValues(), dataSource.getSchema(), dataSource.getDataSourceType());
        Iterator<TestRecord<GenericKey, GenericRow>> records = driverPipeline.getRecordsForTopic(dataSource.getKafkaTopicName());
        if (!records.hasNext()) {
            AssertExecutor.throwAssertionError("Expected another record, but all records have already been read:", dataSource, expected, driverPipeline.getAllRecordsForTopic(dataSource.getKafkaTopicName()).stream().map(rec -> KsqlGenericRecord.of((GenericKey)((GenericKey)rec.key()), (GenericRow)((GenericRow)rec.value()), (long)rec.timestamp())).collect(Collectors.toList()));
        }
        if (!AssertExecutor.verifyValues(expected, actual = KsqlGenericRecord.of((GenericKey)(actualKey = (actualTestRecord = records.next()).key() instanceof Windowed ? (GenericKey)((Windowed)actualTestRecord.key()).key() : (GenericKey)actualTestRecord.key()), (GenericRow)((GenericRow)actualTestRecord.value()), (long)actualTestRecord.timestamp()), dataSource, values.getColumns(), isTombstone)) {
            AssertExecutor.throwAssertionError("Expected record does not match actual.", dataSource, expected, (List<KsqlGenericRecord>)ImmutableList.of((Object)actual));
        }
    }

    private static boolean verifyValues(KsqlGenericRecord expected, KsqlGenericRecord actual, DataSource dataSource, List<ColumnName> columns, boolean isTombstone) {
        if (isTombstone) {
            if (expected.value.values().stream().anyMatch(Objects::nonNull)) {
                throw new AssertionError((Object)"Unexpected value columns specified in ASSERT NULL VALUES.");
            }
            return actual.value == null && actual.key.equals((Object)expected.key);
        }
        if (actual.value == null || expected.key.size() != actual.key.size() || expected.value.size() != actual.value.size()) {
            return false;
        }
        LogicalSchema schema = dataSource.getSchema().withPseudoAndKeyColsInValue(false);
        for (ColumnName col : columns) {
            if (AssertExecutor.checkColumn(col, schema, expected, actual)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkColumn(ColumnName col, LogicalSchema schema, KsqlGenericRecord expected, KsqlGenericRecord actual) {
        int index;
        return !(schema.isKeyColumn(col) ? !expected.key.get(index = ((Column)schema.findColumn(col).get()).index()).equals(actual.key.get(index)) : (col.equals((Object)SystemColumns.ROWTIME_NAME) ? expected.ts != actual.ts : schema.findValueColumn(col).isPresent() && !expected.value.get(index = ((Column)schema.findColumn(col).get()).index()).equals(actual.value.get(index))));
    }

    private static void throwAssertionError(String message, DataSource dataSource, KsqlGenericRecord expected, List<KsqlGenericRecord> actual) {
        ImmutableList columns = ImmutableList.builder().add((Object)Column.of((ColumnName)ColumnName.of((String)"."), (SqlType)SqlTypes.STRING, (Column.Namespace)Column.Namespace.KEY, (int)0)).add((Object)Column.of((ColumnName)SystemColumns.ROWTIME_NAME, (SqlType)SqlTypes.BIGINT, (Column.Namespace)Column.Namespace.KEY, (int)0)).addAll((Iterable)dataSource.getSchema().columns()).build();
        TabularRow headerRow = TabularRow.createHeader((int)80, (List)columns, (boolean)false, (int)0);
        StringBuilder actualRows = new StringBuilder();
        actual.forEach(a -> actualRows.append(AssertExecutor.fromGenericRow(false, dataSource, a)).append('\n'));
        throw new AssertionError((Object)String.format("%s%n%s%n%s%n%s", message, headerRow, AssertExecutor.fromGenericRow(true, dataSource, expected), actualRows.toString()));
    }

    private static TabularRow fromGenericRow(boolean expected, DataSource source, KsqlGenericRecord row) {
        GenericRow contents = new GenericRow();
        contents.append((Object)(expected ? "EXPECTED" : "ACTUAL"));
        contents.appendAll((Collection)row.key.values());
        contents.append((Object)row.ts);
        if (row.value == null) {
            for (Column ignored : source.getSchema().value()) {
                contents.append((Object)"<TOMBSTONE>");
            }
        } else {
            contents.appendAll((Collection)row.value.values());
        }
        return TabularRow.createRow((int)80, (List)contents.values(), (boolean)false, (int)0);
    }

    public static void assertStream(KsqlExecutionContext engine, KsqlConfig config, AssertStream assertStatement) {
        AssertExecutor.assertSourceMatch(engine, config, (CreateSource)assertStatement.getStatement());
    }

    public static void assertTable(KsqlExecutionContext engine, KsqlConfig config, AssertTable assertStatement) {
        AssertExecutor.assertSourceMatch(engine, config, (CreateSource)assertStatement.getStatement());
    }

    private static void assertSourceMatch(KsqlExecutionContext engine, KsqlConfig config, CreateSource statement) {
        SourceName source = statement.getName();
        DataSource dataSource = engine.getMetaStore().getSource(source);
        MUST_MATCH.forEach(prop -> ((SourceProperty)prop).compare(dataSource, statement, config));
    }

    @VisibleForTesting
    static final class SourceProperty {
        final Function<DataSource, Object> extractSource;
        final BiFunction<CreateSource, KsqlConfig, Object> extractStatement;
        final String propertyName;
        final String[] withClauseName;

        private SourceProperty(Function<DataSource, Object> extractSource, BiFunction<CreateSource, KsqlConfig, Object> extractStatement, String propertyName, String ... withClauseName) {
            this.extractSource = extractSource;
            this.extractStatement = extractStatement;
            this.propertyName = propertyName;
            this.withClauseName = withClauseName;
        }

        private void compare(DataSource dataSource, CreateSource statement, KsqlConfig config) {
            Object expected = this.extractStatement.apply(statement, config);
            Object actual = this.extractSource.apply(dataSource);
            if (!Objects.equals(actual, expected)) {
                throw new KsqlException(String.format("Expected %s does not match actual for source %s.%n\tExpected: %s%n\tActual: %s", this.propertyName, dataSource.getName().toString(FormatOptions.noEscape()), expected, actual));
            }
        }
    }
}

