/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.model;

import com.google.common.base.Preconditions;
import io.confluent.ksql.tools.test.model.TestLocation;
import java.nio.file.Path;
import java.util.Objects;

public class LocationWithinFile
implements TestLocation {
    private final Path testPath;
    private final int lineNumber;

    public LocationWithinFile(Path testPath, int lineNumber) {
        this.testPath = Objects.requireNonNull(testPath, "testPath");
        this.lineNumber = lineNumber;
        Preconditions.checkArgument((boolean)testPath.isAbsolute(), (Object)"test path must be absolute");
        Preconditions.checkArgument((lineNumber >= 0 ? 1 : 0) != 0, (Object)("invalid line number: " + lineNumber));
    }

    @Override
    public Path getTestPath() {
        return this.testPath;
    }

    public String toString() {
        return "file://" + this.testPath + ":" + this.lineNumber;
    }
}

