/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore.model;

import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Optional;

@EffectivelyImmutable
public interface DataSource {
    public SourceName getName();

    public DataSourceType getDataSourceType();

    public LogicalSchema getSchema();

    public KsqlTopic getKsqlTopic();

    public Optional<TimestampColumn> getTimestampColumn();

    public String getKafkaTopicName();

    public String getSqlExpression();

    public boolean isCasTarget();

    public Optional<String> canUpgradeTo(DataSource var1);

    public DataSource with(String var1, LogicalSchema var2);

    public boolean isSource();

    public static enum DataSourceType {
        KSTREAM("STREAM"),
        KTABLE("TABLE");

        private final String ksqlType;

        private DataSourceType(String ksqlType) {
            this.ksqlType = ksqlType;
        }

        public String getKsqlType() {
            return this.ksqlType;
        }
    }
}

