/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Struct;
import com.google.protobuf.StructOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import io.confluent.security.audit.Address;
import io.confluent.security.audit.AddressOrBuilder;
import io.confluent.security.audit.AuditLogEntryOrBuilder;
import io.confluent.security.audit.AuditLogProto;
import io.confluent.security.audit.AuthenticationInfo;
import io.confluent.security.audit.AuthenticationInfoOrBuilder;
import io.confluent.security.audit.AuthorizationInfo;
import io.confluent.security.audit.AuthorizationInfoOrBuilder;
import io.confluent.security.audit.Result;
import io.confluent.security.audit.ResultOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AuditLogEntry
extends GeneratedMessageV3
implements AuditLogEntryOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int SERVICE_NAME_FIELD_NUMBER = 1;
    private volatile Object serviceName_;
    public static final int METHOD_NAME_FIELD_NUMBER = 2;
    private volatile Object methodName_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 3;
    private volatile Object resourceName_;
    public static final int AUTHENTICATION_INFO_FIELD_NUMBER = 4;
    private AuthenticationInfo authenticationInfo_;
    public static final int AUTHORIZATION_INFO_FIELD_NUMBER = 5;
    private AuthorizationInfo authorizationInfo_;
    public static final int REQUEST_FIELD_NUMBER = 6;
    private Struct request_;
    public static final int REQUEST_METADATA_FIELD_NUMBER = 7;
    private Struct requestMetadata_;
    public static final int RESULT_FIELD_NUMBER = 8;
    private Result result_;
    public static final int CLIENT_ADDRESS_FIELD_NUMBER = 9;
    private List<Address> clientAddress_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AuditLogEntry DEFAULT_INSTANCE = new AuditLogEntry();
    private static final Parser<AuditLogEntry> PARSER = new AbstractParser<AuditLogEntry>(){

        public AuditLogEntry parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new AuditLogEntry(input, extensionRegistry);
        }
    };

    private AuditLogEntry(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AuditLogEntry() {
        this.serviceName_ = "";
        this.methodName_ = "";
        this.resourceName_ = "";
        this.clientAddress_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AuditLogEntry();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private AuditLogEntry(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block18: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block18;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.serviceName_ = s;
                        continue block18;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.methodName_ = s;
                        continue block18;
                    }
                    case 26: {
                        String s = input.readStringRequireUtf8();
                        this.resourceName_ = s;
                        continue block18;
                    }
                    case 34: {
                        GeneratedMessageV3.Builder subBuilder = null;
                        if (this.authenticationInfo_ != null) {
                            subBuilder = this.authenticationInfo_.toBuilder();
                        }
                        this.authenticationInfo_ = (AuthenticationInfo)input.readMessage(AuthenticationInfo.parser(), extensionRegistry);
                        if (subBuilder == null) continue block18;
                        subBuilder.mergeFrom(this.authenticationInfo_);
                        this.authenticationInfo_ = subBuilder.buildPartial();
                        continue block18;
                    }
                    case 42: {
                        GeneratedMessageV3.Builder subBuilder = null;
                        if (this.authorizationInfo_ != null) {
                            subBuilder = this.authorizationInfo_.toBuilder();
                        }
                        this.authorizationInfo_ = (AuthorizationInfo)input.readMessage(AuthorizationInfo.parser(), extensionRegistry);
                        if (subBuilder == null) continue block18;
                        subBuilder.mergeFrom(this.authorizationInfo_);
                        this.authorizationInfo_ = subBuilder.buildPartial();
                        continue block18;
                    }
                    case 50: {
                        GeneratedMessageV3.Builder subBuilder = null;
                        if (this.request_ != null) {
                            subBuilder = this.request_.toBuilder();
                        }
                        this.request_ = (Struct)input.readMessage(Struct.parser(), extensionRegistry);
                        if (subBuilder == null) continue block18;
                        subBuilder.mergeFrom(this.request_);
                        this.request_ = subBuilder.buildPartial();
                        continue block18;
                    }
                    case 58: {
                        GeneratedMessageV3.Builder subBuilder = null;
                        if (this.requestMetadata_ != null) {
                            subBuilder = this.requestMetadata_.toBuilder();
                        }
                        this.requestMetadata_ = (Struct)input.readMessage(Struct.parser(), extensionRegistry);
                        if (subBuilder == null) continue block18;
                        subBuilder.mergeFrom(this.requestMetadata_);
                        this.requestMetadata_ = subBuilder.buildPartial();
                        continue block18;
                    }
                    case 66: {
                        GeneratedMessageV3.Builder subBuilder = null;
                        if (this.result_ != null) {
                            subBuilder = this.result_.toBuilder();
                        }
                        this.result_ = (Result)input.readMessage(Result.parser(), extensionRegistry);
                        if (subBuilder == null) continue block18;
                        subBuilder.mergeFrom(this.result_);
                        this.result_ = subBuilder.buildPartial();
                        continue block18;
                    }
                    case 74: {
                        if (!(mutable_bitField0_ & true)) {
                            this.clientAddress_ = new ArrayList<Address>();
                            mutable_bitField0_ |= true;
                        }
                        this.clientAddress_.add((Address)input.readMessage(Address.parser(), extensionRegistry));
                        continue block18;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.clientAddress_ = Collections.unmodifiableList(this.clientAddress_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AuditLogProto.internal_static_kafka_auditlog_v1_AuditLogEntry_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AuditLogProto.internal_static_kafka_auditlog_v1_AuditLogEntry_fieldAccessorTable.ensureFieldAccessorsInitialized(AuditLogEntry.class, Builder.class);
    }

    @Override
    public String getServiceName() {
        Object ref = this.serviceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceName_ = s;
        return s;
    }

    @Override
    public ByteString getServiceNameBytes() {
        Object ref = this.serviceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getMethodName() {
        Object ref = this.methodName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.methodName_ = s;
        return s;
    }

    @Override
    public ByteString getMethodNameBytes() {
        Object ref = this.methodName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.methodName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasAuthenticationInfo() {
        return this.authenticationInfo_ != null;
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo_ == null ? AuthenticationInfo.getDefaultInstance() : this.authenticationInfo_;
    }

    @Override
    public AuthenticationInfoOrBuilder getAuthenticationInfoOrBuilder() {
        return this.getAuthenticationInfo();
    }

    @Override
    public boolean hasAuthorizationInfo() {
        return this.authorizationInfo_ != null;
    }

    @Override
    public AuthorizationInfo getAuthorizationInfo() {
        return this.authorizationInfo_ == null ? AuthorizationInfo.getDefaultInstance() : this.authorizationInfo_;
    }

    @Override
    public AuthorizationInfoOrBuilder getAuthorizationInfoOrBuilder() {
        return this.getAuthorizationInfo();
    }

    @Override
    public boolean hasRequest() {
        return this.request_ != null;
    }

    @Override
    public Struct getRequest() {
        return this.request_ == null ? Struct.getDefaultInstance() : this.request_;
    }

    @Override
    public StructOrBuilder getRequestOrBuilder() {
        return this.getRequest();
    }

    @Override
    public boolean hasRequestMetadata() {
        return this.requestMetadata_ != null;
    }

    @Override
    public Struct getRequestMetadata() {
        return this.requestMetadata_ == null ? Struct.getDefaultInstance() : this.requestMetadata_;
    }

    @Override
    public StructOrBuilder getRequestMetadataOrBuilder() {
        return this.getRequestMetadata();
    }

    @Override
    public boolean hasResult() {
        return this.result_ != null;
    }

    @Override
    public Result getResult() {
        return this.result_ == null ? Result.getDefaultInstance() : this.result_;
    }

    @Override
    public ResultOrBuilder getResultOrBuilder() {
        return this.getResult();
    }

    @Override
    public List<Address> getClientAddressList() {
        return this.clientAddress_;
    }

    @Override
    public List<? extends AddressOrBuilder> getClientAddressOrBuilderList() {
        return this.clientAddress_;
    }

    @Override
    public int getClientAddressCount() {
        return this.clientAddress_.size();
    }

    @Override
    public Address getClientAddress(int index) {
        return this.clientAddress_.get(index);
    }

    @Override
    public AddressOrBuilder getClientAddressOrBuilder(int index) {
        return this.clientAddress_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.serviceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.methodName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.methodName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.resourceName_);
        }
        if (this.authenticationInfo_ != null) {
            output.writeMessage(4, (MessageLite)this.getAuthenticationInfo());
        }
        if (this.authorizationInfo_ != null) {
            output.writeMessage(5, (MessageLite)this.getAuthorizationInfo());
        }
        if (this.request_ != null) {
            output.writeMessage(6, (MessageLite)this.getRequest());
        }
        if (this.requestMetadata_ != null) {
            output.writeMessage(7, (MessageLite)this.getRequestMetadata());
        }
        if (this.result_ != null) {
            output.writeMessage(8, (MessageLite)this.getResult());
        }
        for (int i = 0; i < this.clientAddress_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.clientAddress_.get(i));
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.serviceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.methodName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.methodName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.resourceName_);
        }
        if (this.authenticationInfo_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getAuthenticationInfo());
        }
        if (this.authorizationInfo_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getAuthorizationInfo());
        }
        if (this.request_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getRequest());
        }
        if (this.requestMetadata_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getRequestMetadata());
        }
        if (this.result_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getResult());
        }
        for (int i = 0; i < this.clientAddress_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.clientAddress_.get(i)));
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AuditLogEntry)) {
            return super.equals(obj);
        }
        AuditLogEntry other = (AuditLogEntry)obj;
        if (!this.getServiceName().equals(other.getServiceName())) {
            return false;
        }
        if (!this.getMethodName().equals(other.getMethodName())) {
            return false;
        }
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasAuthenticationInfo() != other.hasAuthenticationInfo()) {
            return false;
        }
        if (this.hasAuthenticationInfo() && !this.getAuthenticationInfo().equals(other.getAuthenticationInfo())) {
            return false;
        }
        if (this.hasAuthorizationInfo() != other.hasAuthorizationInfo()) {
            return false;
        }
        if (this.hasAuthorizationInfo() && !this.getAuthorizationInfo().equals(other.getAuthorizationInfo())) {
            return false;
        }
        if (this.hasRequest() != other.hasRequest()) {
            return false;
        }
        if (this.hasRequest() && !this.getRequest().equals((Object)other.getRequest())) {
            return false;
        }
        if (this.hasRequestMetadata() != other.hasRequestMetadata()) {
            return false;
        }
        if (this.hasRequestMetadata() && !this.getRequestMetadata().equals((Object)other.getRequestMetadata())) {
            return false;
        }
        if (this.hasResult() != other.hasResult()) {
            return false;
        }
        if (this.hasResult() && !this.getResult().equals(other.getResult())) {
            return false;
        }
        if (!this.getClientAddressList().equals(other.getClientAddressList())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AuditLogEntry.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getServiceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getMethodName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasAuthenticationInfo()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getAuthenticationInfo().hashCode();
        }
        if (this.hasAuthorizationInfo()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getAuthorizationInfo().hashCode();
        }
        if (this.hasRequest()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getRequest().hashCode();
        }
        if (this.hasRequestMetadata()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getRequestMetadata().hashCode();
        }
        if (this.hasResult()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getResult().hashCode();
        }
        if (this.getClientAddressCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getClientAddressList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static AuditLogEntry parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AuditLogEntry)PARSER.parseFrom(data);
    }

    public static AuditLogEntry parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AuditLogEntry)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AuditLogEntry parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AuditLogEntry)PARSER.parseFrom(data);
    }

    public static AuditLogEntry parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AuditLogEntry)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AuditLogEntry parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AuditLogEntry)PARSER.parseFrom(data);
    }

    public static AuditLogEntry parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AuditLogEntry)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AuditLogEntry parseFrom(InputStream input) throws IOException {
        return (AuditLogEntry)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AuditLogEntry parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AuditLogEntry)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AuditLogEntry parseDelimitedFrom(InputStream input) throws IOException {
        return (AuditLogEntry)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AuditLogEntry parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AuditLogEntry)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AuditLogEntry parseFrom(CodedInputStream input) throws IOException {
        return (AuditLogEntry)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AuditLogEntry parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AuditLogEntry)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AuditLogEntry.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AuditLogEntry prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AuditLogEntry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AuditLogEntry> parser() {
        return PARSER;
    }

    public Parser<AuditLogEntry> getParserForType() {
        return PARSER;
    }

    public AuditLogEntry getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AuditLogEntryOrBuilder {
        private int bitField0_;
        private Object serviceName_ = "";
        private Object methodName_ = "";
        private Object resourceName_ = "";
        private AuthenticationInfo authenticationInfo_;
        private SingleFieldBuilderV3<AuthenticationInfo, AuthenticationInfo.Builder, AuthenticationInfoOrBuilder> authenticationInfoBuilder_;
        private AuthorizationInfo authorizationInfo_;
        private SingleFieldBuilderV3<AuthorizationInfo, AuthorizationInfo.Builder, AuthorizationInfoOrBuilder> authorizationInfoBuilder_;
        private Struct request_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> requestBuilder_;
        private Struct requestMetadata_;
        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> requestMetadataBuilder_;
        private Result result_;
        private SingleFieldBuilderV3<Result, Result.Builder, ResultOrBuilder> resultBuilder_;
        private List<Address> clientAddress_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> clientAddressBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return AuditLogProto.internal_static_kafka_auditlog_v1_AuditLogEntry_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AuditLogProto.internal_static_kafka_auditlog_v1_AuditLogEntry_fieldAccessorTable.ensureFieldAccessorsInitialized(AuditLogEntry.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getClientAddressFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.serviceName_ = "";
            this.methodName_ = "";
            this.resourceName_ = "";
            if (this.authenticationInfoBuilder_ == null) {
                this.authenticationInfo_ = null;
            } else {
                this.authenticationInfo_ = null;
                this.authenticationInfoBuilder_ = null;
            }
            if (this.authorizationInfoBuilder_ == null) {
                this.authorizationInfo_ = null;
            } else {
                this.authorizationInfo_ = null;
                this.authorizationInfoBuilder_ = null;
            }
            if (this.requestBuilder_ == null) {
                this.request_ = null;
            } else {
                this.request_ = null;
                this.requestBuilder_ = null;
            }
            if (this.requestMetadataBuilder_ == null) {
                this.requestMetadata_ = null;
            } else {
                this.requestMetadata_ = null;
                this.requestMetadataBuilder_ = null;
            }
            if (this.resultBuilder_ == null) {
                this.result_ = null;
            } else {
                this.result_ = null;
                this.resultBuilder_ = null;
            }
            if (this.clientAddressBuilder_ == null) {
                this.clientAddress_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
            } else {
                this.clientAddressBuilder_.clear();
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AuditLogProto.internal_static_kafka_auditlog_v1_AuditLogEntry_descriptor;
        }

        public AuditLogEntry getDefaultInstanceForType() {
            return AuditLogEntry.getDefaultInstance();
        }

        public AuditLogEntry build() {
            AuditLogEntry result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AuditLogEntry buildPartial() {
            AuditLogEntry result = new AuditLogEntry(this);
            int from_bitField0_ = this.bitField0_;
            result.serviceName_ = this.serviceName_;
            result.methodName_ = this.methodName_;
            result.resourceName_ = this.resourceName_;
            if (this.authenticationInfoBuilder_ == null) {
                result.authenticationInfo_ = this.authenticationInfo_;
            } else {
                result.authenticationInfo_ = (AuthenticationInfo)this.authenticationInfoBuilder_.build();
            }
            if (this.authorizationInfoBuilder_ == null) {
                result.authorizationInfo_ = this.authorizationInfo_;
            } else {
                result.authorizationInfo_ = (AuthorizationInfo)this.authorizationInfoBuilder_.build();
            }
            if (this.requestBuilder_ == null) {
                result.request_ = this.request_;
            } else {
                result.request_ = (Struct)this.requestBuilder_.build();
            }
            if (this.requestMetadataBuilder_ == null) {
                result.requestMetadata_ = this.requestMetadata_;
            } else {
                result.requestMetadata_ = (Struct)this.requestMetadataBuilder_.build();
            }
            if (this.resultBuilder_ == null) {
                result.result_ = this.result_;
            } else {
                result.result_ = (Result)this.resultBuilder_.build();
            }
            if (this.clientAddressBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.clientAddress_ = Collections.unmodifiableList(this.clientAddress_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.clientAddress_ = this.clientAddress_;
            } else {
                result.clientAddress_ = this.clientAddressBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AuditLogEntry) {
                return this.mergeFrom((AuditLogEntry)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AuditLogEntry other) {
            if (other == AuditLogEntry.getDefaultInstance()) {
                return this;
            }
            if (!other.getServiceName().isEmpty()) {
                this.serviceName_ = other.serviceName_;
                this.onChanged();
            }
            if (!other.getMethodName().isEmpty()) {
                this.methodName_ = other.methodName_;
                this.onChanged();
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.onChanged();
            }
            if (other.hasAuthenticationInfo()) {
                this.mergeAuthenticationInfo(other.getAuthenticationInfo());
            }
            if (other.hasAuthorizationInfo()) {
                this.mergeAuthorizationInfo(other.getAuthorizationInfo());
            }
            if (other.hasRequest()) {
                this.mergeRequest(other.getRequest());
            }
            if (other.hasRequestMetadata()) {
                this.mergeRequestMetadata(other.getRequestMetadata());
            }
            if (other.hasResult()) {
                this.mergeResult(other.getResult());
            }
            if (this.clientAddressBuilder_ == null) {
                if (!other.clientAddress_.isEmpty()) {
                    if (this.clientAddress_.isEmpty()) {
                        this.clientAddress_ = other.clientAddress_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureClientAddressIsMutable();
                        this.clientAddress_.addAll(other.clientAddress_);
                    }
                    this.onChanged();
                }
            } else if (!other.clientAddress_.isEmpty()) {
                if (this.clientAddressBuilder_.isEmpty()) {
                    this.clientAddressBuilder_.dispose();
                    this.clientAddressBuilder_ = null;
                    this.clientAddress_ = other.clientAddress_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.clientAddressBuilder_ = alwaysUseFieldBuilders ? this.getClientAddressFieldBuilder() : null;
                } else {
                    this.clientAddressBuilder_.addAllMessages((Iterable)other.clientAddress_);
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            AuditLogEntry parsedMessage = null;
            try {
                parsedMessage = (AuditLogEntry)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (AuditLogEntry)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getServiceName() {
            Object ref = this.serviceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceNameBytes() {
            Object ref = this.serviceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearServiceName() {
            this.serviceName_ = AuditLogEntry.getDefaultInstance().getServiceName();
            this.onChanged();
            return this;
        }

        public Builder setServiceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AuditLogEntry.checkByteStringIsUtf8((ByteString)value);
            this.serviceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getMethodName() {
            Object ref = this.methodName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.methodName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMethodNameBytes() {
            Object ref = this.methodName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.methodName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMethodName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.methodName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMethodName() {
            this.methodName_ = AuditLogEntry.getDefaultInstance().getMethodName();
            this.onChanged();
            return this;
        }

        public Builder setMethodNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AuditLogEntry.checkByteStringIsUtf8((ByteString)value);
            this.methodName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = AuditLogEntry.getDefaultInstance().getResourceName();
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AuditLogEntry.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAuthenticationInfo() {
            return this.authenticationInfoBuilder_ != null || this.authenticationInfo_ != null;
        }

        @Override
        public AuthenticationInfo getAuthenticationInfo() {
            if (this.authenticationInfoBuilder_ == null) {
                return this.authenticationInfo_ == null ? AuthenticationInfo.getDefaultInstance() : this.authenticationInfo_;
            }
            return (AuthenticationInfo)this.authenticationInfoBuilder_.getMessage();
        }

        public Builder setAuthenticationInfo(AuthenticationInfo value) {
            if (this.authenticationInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.authenticationInfo_ = value;
                this.onChanged();
            } else {
                this.authenticationInfoBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setAuthenticationInfo(AuthenticationInfo.Builder builderForValue) {
            if (this.authenticationInfoBuilder_ == null) {
                this.authenticationInfo_ = builderForValue.build();
                this.onChanged();
            } else {
                this.authenticationInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeAuthenticationInfo(AuthenticationInfo value) {
            if (this.authenticationInfoBuilder_ == null) {
                this.authenticationInfo_ = this.authenticationInfo_ != null ? AuthenticationInfo.newBuilder(this.authenticationInfo_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.authenticationInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearAuthenticationInfo() {
            if (this.authenticationInfoBuilder_ == null) {
                this.authenticationInfo_ = null;
                this.onChanged();
            } else {
                this.authenticationInfo_ = null;
                this.authenticationInfoBuilder_ = null;
            }
            return this;
        }

        public AuthenticationInfo.Builder getAuthenticationInfoBuilder() {
            this.onChanged();
            return (AuthenticationInfo.Builder)this.getAuthenticationInfoFieldBuilder().getBuilder();
        }

        @Override
        public AuthenticationInfoOrBuilder getAuthenticationInfoOrBuilder() {
            if (this.authenticationInfoBuilder_ != null) {
                return (AuthenticationInfoOrBuilder)this.authenticationInfoBuilder_.getMessageOrBuilder();
            }
            return this.authenticationInfo_ == null ? AuthenticationInfo.getDefaultInstance() : this.authenticationInfo_;
        }

        private SingleFieldBuilderV3<AuthenticationInfo, AuthenticationInfo.Builder, AuthenticationInfoOrBuilder> getAuthenticationInfoFieldBuilder() {
            if (this.authenticationInfoBuilder_ == null) {
                this.authenticationInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAuthenticationInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.authenticationInfo_ = null;
            }
            return this.authenticationInfoBuilder_;
        }

        @Override
        public boolean hasAuthorizationInfo() {
            return this.authorizationInfoBuilder_ != null || this.authorizationInfo_ != null;
        }

        @Override
        public AuthorizationInfo getAuthorizationInfo() {
            if (this.authorizationInfoBuilder_ == null) {
                return this.authorizationInfo_ == null ? AuthorizationInfo.getDefaultInstance() : this.authorizationInfo_;
            }
            return (AuthorizationInfo)this.authorizationInfoBuilder_.getMessage();
        }

        public Builder setAuthorizationInfo(AuthorizationInfo value) {
            if (this.authorizationInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.authorizationInfo_ = value;
                this.onChanged();
            } else {
                this.authorizationInfoBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setAuthorizationInfo(AuthorizationInfo.Builder builderForValue) {
            if (this.authorizationInfoBuilder_ == null) {
                this.authorizationInfo_ = builderForValue.build();
                this.onChanged();
            } else {
                this.authorizationInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeAuthorizationInfo(AuthorizationInfo value) {
            if (this.authorizationInfoBuilder_ == null) {
                this.authorizationInfo_ = this.authorizationInfo_ != null ? AuthorizationInfo.newBuilder(this.authorizationInfo_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.authorizationInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearAuthorizationInfo() {
            if (this.authorizationInfoBuilder_ == null) {
                this.authorizationInfo_ = null;
                this.onChanged();
            } else {
                this.authorizationInfo_ = null;
                this.authorizationInfoBuilder_ = null;
            }
            return this;
        }

        public AuthorizationInfo.Builder getAuthorizationInfoBuilder() {
            this.onChanged();
            return (AuthorizationInfo.Builder)this.getAuthorizationInfoFieldBuilder().getBuilder();
        }

        @Override
        public AuthorizationInfoOrBuilder getAuthorizationInfoOrBuilder() {
            if (this.authorizationInfoBuilder_ != null) {
                return (AuthorizationInfoOrBuilder)this.authorizationInfoBuilder_.getMessageOrBuilder();
            }
            return this.authorizationInfo_ == null ? AuthorizationInfo.getDefaultInstance() : this.authorizationInfo_;
        }

        private SingleFieldBuilderV3<AuthorizationInfo, AuthorizationInfo.Builder, AuthorizationInfoOrBuilder> getAuthorizationInfoFieldBuilder() {
            if (this.authorizationInfoBuilder_ == null) {
                this.authorizationInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAuthorizationInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.authorizationInfo_ = null;
            }
            return this.authorizationInfoBuilder_;
        }

        @Override
        public boolean hasRequest() {
            return this.requestBuilder_ != null || this.request_ != null;
        }

        @Override
        public Struct getRequest() {
            if (this.requestBuilder_ == null) {
                return this.request_ == null ? Struct.getDefaultInstance() : this.request_;
            }
            return (Struct)this.requestBuilder_.getMessage();
        }

        public Builder setRequest(Struct value) {
            if (this.requestBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.request_ = value;
                this.onChanged();
            } else {
                this.requestBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setRequest(Struct.Builder builderForValue) {
            if (this.requestBuilder_ == null) {
                this.request_ = builderForValue.build();
                this.onChanged();
            } else {
                this.requestBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeRequest(Struct value) {
            if (this.requestBuilder_ == null) {
                this.request_ = this.request_ != null ? Struct.newBuilder((Struct)this.request_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.requestBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearRequest() {
            if (this.requestBuilder_ == null) {
                this.request_ = null;
                this.onChanged();
            } else {
                this.request_ = null;
                this.requestBuilder_ = null;
            }
            return this;
        }

        public Struct.Builder getRequestBuilder() {
            this.onChanged();
            return (Struct.Builder)this.getRequestFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getRequestOrBuilder() {
            if (this.requestBuilder_ != null) {
                return (StructOrBuilder)this.requestBuilder_.getMessageOrBuilder();
            }
            return this.request_ == null ? Struct.getDefaultInstance() : this.request_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getRequestFieldBuilder() {
            if (this.requestBuilder_ == null) {
                this.requestBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRequest(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.request_ = null;
            }
            return this.requestBuilder_;
        }

        @Override
        public boolean hasRequestMetadata() {
            return this.requestMetadataBuilder_ != null || this.requestMetadata_ != null;
        }

        @Override
        public Struct getRequestMetadata() {
            if (this.requestMetadataBuilder_ == null) {
                return this.requestMetadata_ == null ? Struct.getDefaultInstance() : this.requestMetadata_;
            }
            return (Struct)this.requestMetadataBuilder_.getMessage();
        }

        public Builder setRequestMetadata(Struct value) {
            if (this.requestMetadataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.requestMetadata_ = value;
                this.onChanged();
            } else {
                this.requestMetadataBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setRequestMetadata(Struct.Builder builderForValue) {
            if (this.requestMetadataBuilder_ == null) {
                this.requestMetadata_ = builderForValue.build();
                this.onChanged();
            } else {
                this.requestMetadataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeRequestMetadata(Struct value) {
            if (this.requestMetadataBuilder_ == null) {
                this.requestMetadata_ = this.requestMetadata_ != null ? Struct.newBuilder((Struct)this.requestMetadata_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.requestMetadataBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearRequestMetadata() {
            if (this.requestMetadataBuilder_ == null) {
                this.requestMetadata_ = null;
                this.onChanged();
            } else {
                this.requestMetadata_ = null;
                this.requestMetadataBuilder_ = null;
            }
            return this;
        }

        public Struct.Builder getRequestMetadataBuilder() {
            this.onChanged();
            return (Struct.Builder)this.getRequestMetadataFieldBuilder().getBuilder();
        }

        @Override
        public StructOrBuilder getRequestMetadataOrBuilder() {
            if (this.requestMetadataBuilder_ != null) {
                return (StructOrBuilder)this.requestMetadataBuilder_.getMessageOrBuilder();
            }
            return this.requestMetadata_ == null ? Struct.getDefaultInstance() : this.requestMetadata_;
        }

        private SingleFieldBuilderV3<Struct, Struct.Builder, StructOrBuilder> getRequestMetadataFieldBuilder() {
            if (this.requestMetadataBuilder_ == null) {
                this.requestMetadataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRequestMetadata(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.requestMetadata_ = null;
            }
            return this.requestMetadataBuilder_;
        }

        @Override
        public boolean hasResult() {
            return this.resultBuilder_ != null || this.result_ != null;
        }

        @Override
        public Result getResult() {
            if (this.resultBuilder_ == null) {
                return this.result_ == null ? Result.getDefaultInstance() : this.result_;
            }
            return (Result)this.resultBuilder_.getMessage();
        }

        public Builder setResult(Result value) {
            if (this.resultBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.result_ = value;
                this.onChanged();
            } else {
                this.resultBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setResult(Result.Builder builderForValue) {
            if (this.resultBuilder_ == null) {
                this.result_ = builderForValue.build();
                this.onChanged();
            } else {
                this.resultBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeResult(Result value) {
            if (this.resultBuilder_ == null) {
                this.result_ = this.result_ != null ? Result.newBuilder(this.result_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.resultBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearResult() {
            if (this.resultBuilder_ == null) {
                this.result_ = null;
                this.onChanged();
            } else {
                this.result_ = null;
                this.resultBuilder_ = null;
            }
            return this;
        }

        public Result.Builder getResultBuilder() {
            this.onChanged();
            return (Result.Builder)this.getResultFieldBuilder().getBuilder();
        }

        @Override
        public ResultOrBuilder getResultOrBuilder() {
            if (this.resultBuilder_ != null) {
                return (ResultOrBuilder)this.resultBuilder_.getMessageOrBuilder();
            }
            return this.result_ == null ? Result.getDefaultInstance() : this.result_;
        }

        private SingleFieldBuilderV3<Result, Result.Builder, ResultOrBuilder> getResultFieldBuilder() {
            if (this.resultBuilder_ == null) {
                this.resultBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getResult(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.result_ = null;
            }
            return this.resultBuilder_;
        }

        private void ensureClientAddressIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.clientAddress_ = new ArrayList<Address>(this.clientAddress_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<Address> getClientAddressList() {
            if (this.clientAddressBuilder_ == null) {
                return Collections.unmodifiableList(this.clientAddress_);
            }
            return this.clientAddressBuilder_.getMessageList();
        }

        @Override
        public int getClientAddressCount() {
            if (this.clientAddressBuilder_ == null) {
                return this.clientAddress_.size();
            }
            return this.clientAddressBuilder_.getCount();
        }

        @Override
        public Address getClientAddress(int index) {
            if (this.clientAddressBuilder_ == null) {
                return this.clientAddress_.get(index);
            }
            return (Address)this.clientAddressBuilder_.getMessage(index);
        }

        public Builder setClientAddress(int index, Address value) {
            if (this.clientAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureClientAddressIsMutable();
                this.clientAddress_.set(index, value);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setClientAddress(int index, Address.Builder builderForValue) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.clientAddressBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addClientAddress(Address value) {
            if (this.clientAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(value);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addClientAddress(int index, Address value) {
            if (this.clientAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(index, value);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addClientAddress(Address.Builder builderForValue) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addClientAddress(int index, Address.Builder builderForValue) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllClientAddress(Iterable<? extends Address> values) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.clientAddress_);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearClientAddress() {
            if (this.clientAddressBuilder_ == null) {
                this.clientAddress_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.clientAddressBuilder_.clear();
            }
            return this;
        }

        public Builder removeClientAddress(int index) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.remove(index);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.remove(index);
            }
            return this;
        }

        public Address.Builder getClientAddressBuilder(int index) {
            return (Address.Builder)this.getClientAddressFieldBuilder().getBuilder(index);
        }

        @Override
        public AddressOrBuilder getClientAddressOrBuilder(int index) {
            if (this.clientAddressBuilder_ == null) {
                return this.clientAddress_.get(index);
            }
            return (AddressOrBuilder)this.clientAddressBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AddressOrBuilder> getClientAddressOrBuilderList() {
            if (this.clientAddressBuilder_ != null) {
                return this.clientAddressBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.clientAddress_);
        }

        public Address.Builder addClientAddressBuilder() {
            return (Address.Builder)this.getClientAddressFieldBuilder().addBuilder((AbstractMessage)Address.getDefaultInstance());
        }

        public Address.Builder addClientAddressBuilder(int index) {
            return (Address.Builder)this.getClientAddressFieldBuilder().addBuilder(index, (AbstractMessage)Address.getDefaultInstance());
        }

        public List<Address.Builder> getClientAddressBuilderList() {
            return this.getClientAddressFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> getClientAddressFieldBuilder() {
            if (this.clientAddressBuilder_ == null) {
                this.clientAddressBuilder_ = new RepeatedFieldBuilderV3(this.clientAddress_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.clientAddress_ = null;
            }
            return this.clientAddressBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

