/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.RateLimiter;
import io.confluent.avro.random.generator.Generator;
import io.confluent.ksql.datagen.DataGenProducer;
import io.confluent.ksql.datagen.ProducerFactory;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.util.JavaSystemExit;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SystemExit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public final class DataGen {
    private DataGen() {
    }

    public static void main(String[] args) {
        try {
            DataGen.run((SystemExit)new JavaSystemExit(), args);
        }
        catch (Arguments.ArgumentParseException exception) {
            System.err.println(exception.getMessage());
            DataGen.usage();
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static void run(SystemExit systemExit, String ... args) throws Throwable {
        int i;
        Arguments arguments = new Arguments.Builder().parseArgs(args).build();
        if (arguments.help) {
            DataGen.usage();
            return;
        }
        Properties props = DataGen.getProperties(arguments);
        DataGenProducer dataProducer = ProducerFactory.getProducer(arguments.keyFormat, arguments.valueFormat, arguments.valueDelimiter, props);
        Optional<RateLimiter> rateLimiter = arguments.msgRate != -1 ? Optional.of(RateLimiter.create((double)arguments.msgRate)) : Optional.empty();
        ExecutorService executor = Executors.newFixedThreadPool(arguments.numThreads, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        });
        ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(executor);
        for (i = 0; i < arguments.numThreads; ++i) {
            service.submit(DataGen.getProducerTask(arguments, dataProducer, props, rateLimiter));
        }
        for (i = 0; i < arguments.numThreads; ++i) {
            try {
                service.take().get();
                continue;
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted waiting for threads to exit.");
                systemExit.exit(1);
                continue;
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    private static Callable<Void> getProducerTask(Arguments arguments, DataGenProducer dataProducer, Properties props, Optional<RateLimiter> rateLimiter) throws IOException {
        Generator generator = new Generator((InputStream)arguments.schemaFile.get(), new Random());
        return () -> {
            dataProducer.populateTopic(props, generator, arguments.topicName, arguments.keyName, arguments.timestampColumnName != null ? Optional.of(arguments.timestampColumnName) : Optional.empty(), arguments.iterations, arguments.printRows, rateLimiter);
            return null;
        };
    }

    static Properties getProperties(Arguments arguments) throws IOException {
        Properties props = new Properties();
        props.put("bootstrap.servers", arguments.bootstrapServer);
        props.put("client.id", "KSQLDataGenProducer");
        props.put("ksql.schema.registry.url", arguments.schemaRegistryUrl);
        if (arguments.propertiesFile != null) {
            props.load(arguments.propertiesFile);
        }
        return props;
    }

    private static void usage() {
        String newLine = System.lineSeparator();
        System.err.println("usage: DataGen " + newLine + "[help] " + newLine + "[bootstrap-server=<kafka bootstrap server(s)> (defaults to localhost:9092)] " + newLine + "[quickstart=<quickstart preset> (case-insensitive; one of 'orders', 'users', or 'pageviews')] " + newLine + "schema=<avro schema file> " + newLine + "[schemaRegistryUrl=<url for Confluent Schema Registry> (defaults to http://localhost:8081)] " + newLine + "key-format=<message key format> (case-insensitive; one of 'avro', 'json', 'kafka' or 'delimited') " + newLine + "value-format=<message value format> (case-insensitive; one of 'avro', 'json' or 'delimited') " + newLine + "valueDelimiter=<message value delimiter> (case-insensitive; delimiter to use when using delimited value format. Must be a single character or special values 'SPACE' or 'TAB'. Defaults to ',')" + newLine + "topic=<kafka topic name> " + newLine + "key=<name of key column> " + newLine + "timestamp=<name of timestamp column> " + newLine + "[iterations=<number of rows> (if no value is specified, datagen will produce indefinitely)] " + newLine + "[propertiesFile=<file specifying Kafka client properties>] " + newLine + "[nThreads=<number of producer threads to start>] " + newLine + "[msgRate=<rate to produce in msgs/second>] " + newLine + "[printRows=<true|false>]" + newLine);
    }

    static class Arguments {
        private final boolean help;
        private final String bootstrapServer;
        private final Supplier<InputStream> schemaFile;
        private final Format keyFormat;
        private final Format valueFormat;
        private final String valueDelimiter;
        private final String topicName;
        private final String keyName;
        private final String timestampColumnName;
        private final int iterations;
        private final String schemaRegistryUrl;
        private final InputStream propertiesFile;
        private final int numThreads;
        private final int msgRate;
        private final boolean printRows;

        Arguments(boolean help, String bootstrapServer, Supplier<InputStream> schemaFile, Format keyFormat, Format valueFormat, String valueDelimiter, String topicName, String keyName, String timestampColumnName, int iterations, String schemaRegistryUrl, InputStream propertiesFile, int numThreads, int msgRate, boolean printRows) {
            this.help = help;
            this.bootstrapServer = bootstrapServer;
            this.schemaFile = schemaFile;
            this.keyFormat = keyFormat;
            this.valueFormat = valueFormat;
            this.valueDelimiter = valueDelimiter;
            this.topicName = topicName;
            this.keyName = keyName;
            this.timestampColumnName = timestampColumnName;
            this.iterations = iterations;
            this.schemaRegistryUrl = schemaRegistryUrl;
            this.propertiesFile = propertiesFile;
            this.numThreads = numThreads;
            this.msgRate = msgRate;
            this.printRows = printRows;
        }

        private static final class Builder {
            private static final Map<String, BiConsumer<Builder, String>> ARG_HANDLERS = ImmutableMap.builder().put((Object)"quickstart", (builder, argVal) -> {
                builder.quickstart = Builder.parseQuickStart(argVal);
            }).put((Object)"bootstrap-server", (builder, argVal) -> {
                builder.bootstrapServer = argVal;
            }).put((Object)"schema", (builder, argVal) -> {
                builder.schemaFile = Builder.toFileInputStream(argVal);
            }).put((Object)"key-format", (builder, arg) -> {
                builder.keyFormat = Builder.parseFormat(arg);
            }).put((Object)"value-format", (builder, arg) -> {
                builder.valueFormat = Builder.parseFormat(arg);
            }).put((Object)"format", (builder, argVal) -> {
                builder.valueFormat = Builder.parseFormat(argVal);
            }).put((Object)"valueDelimiter", (builder, argVal) -> {
                builder.valueDelimiter = Builder.parseValueDelimiter(argVal);
            }).put((Object)"topic", (builder, argVal) -> {
                builder.topicName = argVal;
            }).put((Object)"key", (builder, argVal) -> {
                builder.keyName = argVal;
            }).put((Object)"timestamp", (builder, argVal) -> {
                builder.timestampColumnName = argVal;
            }).put((Object)"iterations", (builder, argVal) -> {
                builder.iterations = Builder.parseInt(argVal, 1);
            }).put((Object)"maxInterval", (builder, argVal) -> Builder.printMaxIntervalIsDeprecatedMessage()).put((Object)"schemaRegistryUrl", (builder, argVal) -> {
                builder.schemaRegistryUrl = argVal;
            }).put((Object)"propertiesFile", (builder, argVal) -> {
                builder.propertiesFile = Builder.toFileInputStream(argVal).get();
            }).put((Object)"msgRate", (builder, argVal) -> {
                builder.msgRate = Builder.parseInt(argVal, 1);
            }).put((Object)"nThreads", (builder, argVal) -> {
                builder.numThreads = Builder.parseNumThreads(argVal);
            }).put((Object)"printRows", (builder, argVal) -> {
                builder.printRows = Builder.parsePrintRows(argVal);
            }).build();
            private Quickstart quickstart = null;
            private boolean help = false;
            private String bootstrapServer = "localhost:9092";
            private Supplier<InputStream> schemaFile = null;
            private Format keyFormat = FormatFactory.KAFKA;
            private Format valueFormat = null;
            private String valueDelimiter = null;
            private String topicName = null;
            private String keyName = null;
            private String timestampColumnName = null;
            private int iterations = -1;
            private String schemaRegistryUrl = "http://localhost:8081";
            private InputStream propertiesFile = null;
            private int msgRate = -1;
            private int numThreads = 1;
            private boolean printRows = true;

            private static void printMaxIntervalIsDeprecatedMessage() {
                System.err.println("*maxInterval* parameter is *DEPRECATED*");
                System.err.println("the value will be ignored and parameter will be removed in future releases");
                System.err.println("Please use *msgRate* parameter to adjust sending message frequency");
                System.err.flush();
            }

            private Builder() {
            }

            Arguments build() {
                if (this.help) {
                    return new Arguments(true, null, null, null, null, null, null, null, null, 0, null, null, 1, -1, true);
                }
                if (this.quickstart != null) {
                    this.schemaFile = Optional.ofNullable(this.schemaFile).orElse(this.quickstart.getSchemaFile());
                    this.keyFormat = Optional.ofNullable(this.keyFormat).orElse(FormatFactory.KAFKA);
                    this.valueFormat = Optional.ofNullable(this.valueFormat).orElse(FormatFactory.JSON);
                    this.topicName = Optional.ofNullable(this.topicName).orElse(this.quickstart.getTopicName(this.valueFormat));
                    this.keyName = Optional.ofNullable(this.keyName).orElse(this.quickstart.getKeyName());
                    this.timestampColumnName = Optional.ofNullable(this.timestampColumnName).orElse(null);
                }
                if (this.schemaFile == null) {
                    throw new ArgumentParseException("Schema file not provided");
                }
                if (this.keyFormat == null) {
                    throw new ArgumentParseException("Message key format not provided");
                }
                if (this.valueFormat == null) {
                    throw new ArgumentParseException("Message value format not provided");
                }
                if (this.topicName == null) {
                    throw new ArgumentParseException("Kafka topic name not provided");
                }
                if (this.keyName == null) {
                    throw new ArgumentParseException("Name of key column not provided");
                }
                return new Arguments(this.help, this.bootstrapServer, this.schemaFile, this.keyFormat, this.valueFormat, this.valueDelimiter, this.topicName, this.keyName, this.timestampColumnName, this.iterations, this.schemaRegistryUrl, this.propertiesFile, this.numThreads, this.msgRate, this.printRows);
            }

            Builder parseArgs(String[] args) {
                for (String arg : args) {
                    this.parseArg(arg);
                }
                return this;
            }

            private void parseArg(String arg) {
                if ("help".equals(arg) || "--help".equals(arg)) {
                    this.help = true;
                    return;
                }
                String[] splitOnEquals = arg.split("=");
                if (splitOnEquals.length != 2) {
                    throw new ArgumentParseException(String.format("Invalid argument format in '%s'; expected <name>=<value>", arg));
                }
                String argName = splitOnEquals[0].trim();
                String argValue = splitOnEquals[1].trim();
                if (argName.isEmpty()) {
                    throw new ArgumentParseException(String.format("Empty argument name in %s", arg));
                }
                if (argValue.isEmpty()) {
                    throw new ArgumentParseException(String.format("Empty argument value in '%s'", arg));
                }
                this.setArg(argName, argValue);
            }

            private void setArg(String argName, String argVal) {
                BiConsumer<Builder, String> handler = ARG_HANDLERS.get(argName);
                if (handler == null) {
                    throw new ArgumentParseException(String.format("Unknown argument name in '%s'", argName));
                }
                handler.accept(this, argVal);
            }

            private static Supplier<InputStream> toFileInputStream(String argVal) {
                return () -> {
                    try {
                        return new FileInputStream(argVal);
                    }
                    catch (FileNotFoundException e) {
                        throw new IllegalArgumentException("File not found: " + argVal, e);
                    }
                };
            }

            private static Quickstart parseQuickStart(String argValue) {
                try {
                    return Quickstart.valueOf(argValue.toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    throw new ArgumentParseException(String.format("Invalid quickstart in '%s'; was expecting one of " + Arrays.toString((Object[])Quickstart.values()) + " (case-insensitive)", argValue));
                }
            }

            private static Format parseFormat(String formatString) {
                try {
                    return FormatFactory.of((FormatInfo)FormatInfo.of((String)formatString));
                }
                catch (KsqlException exception) {
                    throw new ArgumentParseException(String.format("Invalid format in '%s'; was expecting one of AVRO, JSON, KAFKA or DELIMITED (case-insensitive)", formatString));
                }
            }

            private static String parseValueDelimiter(String valueDelimiterString) {
                if (valueDelimiterString == null) {
                    return null;
                }
                if (valueDelimiterString.length() != 1 && !valueDelimiterString.equals("TAB") && !valueDelimiterString.equals("SPACE")) {
                    throw new ArgumentParseException(String.format("Invalid value_delimiter; was expecting a single character, 'TAB', or 'SPACE', got '%s'", valueDelimiterString));
                }
                return valueDelimiterString;
            }

            private static int parseNumThreads(String numThreadsString) {
                try {
                    int result = Integer.valueOf(numThreadsString, 10);
                    if (result < 0) {
                        throw new ArgumentParseException(String.format("Invalid number of threads in '%d'; must be a positive number", result));
                    }
                    return result;
                }
                catch (NumberFormatException e) {
                    throw new ArgumentParseException(String.format("Invalid number of threads in '%s'; must be a positive number", numThreadsString));
                }
            }

            private static boolean parsePrintRows(String printRowsString) {
                switch (printRowsString.toLowerCase()) {
                    case "false": {
                        return false;
                    }
                    case "true": {
                        return true;
                    }
                }
                throw new ArgumentParseException(String.format("Invalid value for printRows in '%s'; must be true or false", printRowsString));
            }

            private static int parseInt(String iterationsString, int minValue) {
                try {
                    int result = Integer.valueOf(iterationsString, 10);
                    if (result < minValue) {
                        throw new ArgumentParseException(String.format("Invalid integer value '%d'; must be >= %d", result, minValue));
                    }
                    return Integer.valueOf(iterationsString, 10);
                }
                catch (NumberFormatException exception) {
                    throw new ArgumentParseException(String.format("Invalid integer value '%s'; must be a valid base 10 integer", iterationsString));
                }
            }

            private static enum Quickstart {
                CLICKSTREAM_CODES("clickstream_codes_schema.avro", "clickstream", "code"),
                CLICKSTREAM("clickstream_schema.avro", "clickstream", "ip"),
                CLICKSTREAM_USERS("clickstream_users_schema.avro", "webusers", "user_id"),
                ORDERS("orders_schema.avro", "orders", "orderid"),
                RATINGS("ratings_schema.avro", "ratings", "rating_id"),
                USERS("users_schema.avro", "users", "userid"),
                USERS_("users_array_map_schema.avro", "users", "userid"),
                PAGEVIEWS("pageviews_schema.avro", "pageviews", "viewtime");

                private final String schemaFileName;
                private final String rootTopicName;
                private final String keyName;

                private Quickstart(String schemaFileName, String rootTopicName, String keyName) {
                    this.schemaFileName = schemaFileName;
                    this.rootTopicName = rootTopicName;
                    this.keyName = keyName;
                }

                public Supplier<InputStream> getSchemaFile() {
                    return () -> ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.schemaFileName);
                }

                public String getTopicName(Format format) {
                    return String.format("%s_kafka_topic_%s", this.rootTopicName, format.name().toLowerCase());
                }

                public String getKeyName() {
                    return this.keyName;
                }
            }
        }

        static class ArgumentParseException
        extends RuntimeException {
            ArgumentParseException(String message) {
                super(message);
            }
        }
    }
}

