/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import com.google.common.util.concurrent.RateLimiter;
import io.confluent.avro.random.generator.Generator;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.datagen.RowGenerator;
import io.confluent.ksql.datagen.SerializerFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.Serializer;

public class DataGenProducer {
    private final SerializerFactory<GenericKey> keySerializerFactory;
    private final SerializerFactory<GenericRow> valueSerializerFactory;

    public DataGenProducer(SerializerFactory<GenericKey> keySerializerFactory, SerializerFactory<GenericRow> valueSerdeFactory) {
        this.keySerializerFactory = Objects.requireNonNull(keySerializerFactory, "keySerializerFactory");
        this.valueSerializerFactory = Objects.requireNonNull(valueSerdeFactory, "valueSerdeFactory");
    }

    protected static void validateTimestampColumnType(Optional<String> timestampColumnName, Schema avroSchema) {
        if (timestampColumnName.isPresent()) {
            if (avroSchema.getField(timestampColumnName.get()) == null) {
                throw new IllegalArgumentException("The indicated timestamp field does not exist: " + timestampColumnName.get());
            }
            if (avroSchema.getField(timestampColumnName.get()).schema().getType() != Schema.Type.LONG) {
                throw new IllegalArgumentException("The timestamp column type should be bigint/long. " + timestampColumnName.get() + " type is " + avroSchema.getField(timestampColumnName.get()).schema().getType());
            }
        }
    }

    public void populateTopic(Properties props, Generator generator, String kafkaTopicName, String key, Optional<String> timestampColumnName, int messageCount, boolean printRows, Optional<RateLimiter> rateLimiter) {
        Schema avroSchema = generator.schema();
        if (avroSchema.getField(key) == null) {
            throw new IllegalArgumentException("Key field does not exist: " + key);
        }
        DataGenProducer.validateTimestampColumnType(timestampColumnName, avroSchema);
        RowGenerator rowGenerator = new RowGenerator(generator, key, timestampColumnName);
        Serializer<GenericKey> keySerializer = this.getKeySerializer(rowGenerator.schema());
        Serializer<GenericRow> valueSerializer = this.getValueSerializer(rowGenerator.schema());
        KafkaProducer producer = new KafkaProducer(props, keySerializer, valueSerializer);
        if (messageCount != -1) {
            for (int i = 0; i < messageCount; ++i) {
                DataGenProducer.produceOne(rowGenerator, (KafkaProducer<GenericKey, GenericRow>)producer, kafkaTopicName, printRows, rateLimiter);
            }
        } else {
            while (true) {
                DataGenProducer.produceOne(rowGenerator, (KafkaProducer<GenericKey, GenericRow>)producer, kafkaTopicName, printRows, rateLimiter);
            }
        }
        producer.flush();
        producer.close();
    }

    private static void produceOne(RowGenerator rowGenerator, KafkaProducer<GenericKey, GenericRow> producer, String kafkaTopicName, boolean printRows, Optional<RateLimiter> rateLimiter) {
        rateLimiter.ifPresent(RateLimiter::acquire);
        Pair<GenericKey, GenericRow> genericRowPair = rowGenerator.generateRow();
        Long timestamp = rowGenerator.getTimestampFieldIndex().isPresent() ? (Long)((GenericRow)genericRowPair.getRight()).get(rowGenerator.getTimestampFieldIndex().get().intValue()) : null;
        ProducerRecord producerRecord = new ProducerRecord(kafkaTopicName, null, timestamp, genericRowPair.getLeft(), genericRowPair.getRight());
        producer.send(producerRecord, (Callback)new LoggingCallback(kafkaTopicName, (GenericKey)genericRowPair.getLeft(), (GenericRow)genericRowPair.getRight(), printRows));
    }

    private Serializer<GenericKey> getKeySerializer(LogicalSchema schema) {
        Set supported = this.keySerializerFactory.format().supportedFeatures();
        SerdeFeatures features = supported.contains(SerdeFeature.UNWRAP_SINGLES) ? SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{SerdeFeature.UNWRAP_SINGLES}) : SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        PersistenceSchema persistenceSchema = PersistenceSchema.from((List)schema.key(), (SerdeFeatures)features);
        return this.keySerializerFactory.create(persistenceSchema);
    }

    private Serializer<GenericRow> getValueSerializer(LogicalSchema schema) {
        PersistenceSchema persistenceSchema = PersistenceSchema.from((List)schema.value(), (SerdeFeatures)SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
        return this.valueSerializerFactory.create(persistenceSchema);
    }

    private static class LoggingCallback
    implements Callback {
        private final String topic;
        private final String key;
        private final String value;
        private final boolean printOnSuccess;

        LoggingCallback(String topic, GenericKey key, GenericRow value, boolean printOnSuccess) {
            this.topic = topic;
            this.key = Objects.toString(key);
            this.value = Objects.toString(value);
            this.printOnSuccess = printOnSuccess;
        }

        public void onCompletion(RecordMetadata metadata, Exception e) {
            if (e != null) {
                System.err.println("Error when sending message to topic: '" + this.topic + "', with key: '" + this.key + "', and value: '" + this.value + "'");
                e.printStackTrace(System.err);
            } else if (this.printOnSuccess) {
                System.out.println(this.key + " --> (" + this.value + ") ts:" + metadata.timestamp());
            }
        }
    }
}

