/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public final class DataGenSchemaUtil {
    private DataGenSchemaUtil() {
    }

    public static ConnectSchema getOptionalSchema(Schema schema) {
        switch (schema.type()) {
            case BOOLEAN: {
                return (ConnectSchema)Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case INT32: {
                return (ConnectSchema)Schema.OPTIONAL_INT32_SCHEMA;
            }
            case INT64: {
                return (ConnectSchema)Schema.OPTIONAL_INT64_SCHEMA;
            }
            case FLOAT64: {
                return (ConnectSchema)Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case STRING: {
                return (ConnectSchema)Schema.OPTIONAL_STRING_SCHEMA;
            }
            case ARRAY: {
                return (ConnectSchema)SchemaBuilder.array((Schema)DataGenSchemaUtil.getOptionalSchema(schema.valueSchema())).optional().build();
            }
            case MAP: {
                return (ConnectSchema)SchemaBuilder.map((Schema)DataGenSchemaUtil.getOptionalSchema(schema.keySchema()), (Schema)DataGenSchemaUtil.getOptionalSchema(schema.valueSchema())).optional().build();
            }
            case STRUCT: {
                SchemaBuilder schemaBuilder = SchemaBuilder.struct();
                for (Field field : schema.fields()) {
                    schemaBuilder.field(field.name(), (Schema)DataGenSchemaUtil.getOptionalSchema(field.schema()));
                }
                return (ConnectSchema)schemaBuilder.optional().build();
            }
        }
        throw new KsqlException("Unsupported type: " + schema);
    }

    static Object getOptionalValue(Schema schema, Object value) {
        switch (schema.type()) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT64: 
            case STRING: {
                return value;
            }
            case ARRAY: {
                List list = (List)value;
                return list.stream().map(listItem -> DataGenSchemaUtil.getOptionalValue(schema.valueSchema(), listItem)).collect(Collectors.toList());
            }
            case MAP: {
                Map map = (Map)value;
                return map.entrySet().stream().collect(Collectors.toMap(k -> DataGenSchemaUtil.getOptionalValue(schema.keySchema(), k), v -> DataGenSchemaUtil.getOptionalValue(schema.valueSchema(), v)));
            }
            case STRUCT: {
                Struct struct = (Struct)value;
                Struct optionalStruct = new Struct((Schema)DataGenSchemaUtil.getOptionalSchema(schema));
                for (Field field : schema.fields()) {
                    optionalStruct.put(field.name(), DataGenSchemaUtil.getOptionalValue(field.schema(), struct.get(field.name())));
                }
                return optionalStruct;
            }
        }
        throw new KsqlException("Invalid value schema: " + schema + ", value = " + value);
    }
}

