/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature.internal;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.ConscryptUtil;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.signature.RsaSsaPssParameters;
import com.google.crypto.tink.signature.RsaSsaPssPublicKey;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import javax.annotation.Nullable;

@Immutable
public final class RsaSsaPssVerifyConscrypt
implements PublicKeyVerify {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] LEGACY_MESSAGE_SUFFIX = new byte[]{0};
    private static final String MGF_1 = "MGF1";
    private static final int TRAILER_FIELD_BC = 1;
    static final Provider CONSCRYPT = RsaSsaPssVerifyConscrypt.conscryptProviderOrNull();
    private final RSAPublicKey publicKey;
    private final String signatureAlgorithm;
    private final PSSParameterSpec parameterSpec;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;

    @Nullable
    private static Provider conscryptProviderOrNull() {
        if (Util.isAndroid() && Util.getAndroidApiLevel() <= 23) {
            return null;
        }
        return ConscryptUtil.providerOrNull();
    }

    public static boolean isSupported() {
        return CONSCRYPT != null;
    }

    static String getConscryptRsaSsaPssAlgo(RsaSsaPssParameters.HashType hash) {
        if (hash == RsaSsaPssParameters.HashType.SHA256) {
            return "SHA256withRSA/PSS";
        }
        if (hash == RsaSsaPssParameters.HashType.SHA384) {
            return "SHA384withRSA/PSS";
        }
        if (hash == RsaSsaPssParameters.HashType.SHA512) {
            return "SHA512withRSA/PSS";
        }
        throw new IllegalArgumentException("Unsupported hash: " + hash);
    }

    private static String getMdName(RsaSsaPssParameters.HashType sigHash) {
        if (sigHash == RsaSsaPssParameters.HashType.SHA256) {
            return "SHA-256";
        }
        if (sigHash == RsaSsaPssParameters.HashType.SHA384) {
            return "SHA-384";
        }
        if (sigHash == RsaSsaPssParameters.HashType.SHA512) {
            return "SHA-512";
        }
        throw new IllegalArgumentException("Unsupported MD hash: " + sigHash);
    }

    private static MGF1ParameterSpec getMgf1Hash(RsaSsaPssParameters.HashType mgf1Hash) {
        if (mgf1Hash == RsaSsaPssParameters.HashType.SHA256) {
            return MGF1ParameterSpec.SHA256;
        }
        if (mgf1Hash == RsaSsaPssParameters.HashType.SHA384) {
            return MGF1ParameterSpec.SHA384;
        }
        if (mgf1Hash == RsaSsaPssParameters.HashType.SHA512) {
            return MGF1ParameterSpec.SHA512;
        }
        throw new IllegalArgumentException("Unsupported MGF1 hash: " + mgf1Hash);
    }

    static PSSParameterSpec getPssParameterSpec(RsaSsaPssParameters.HashType sigHash, RsaSsaPssParameters.HashType mgf1Hash, int saltLength) {
        return new PSSParameterSpec(RsaSsaPssVerifyConscrypt.getMdName(sigHash), MGF_1, RsaSsaPssVerifyConscrypt.getMgf1Hash(mgf1Hash), saltLength, 1);
    }

    private RsaSsaPssVerifyConscrypt(RSAPublicKey pubKey, RsaSsaPssParameters.HashType sigHash, RsaSsaPssParameters.HashType mgf1Hash, int saltLength, byte[] outputPrefix, byte[] messageSuffix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Cannot use RSA SSA PSS in FIPS-mode, as BoringCrypto module is not available.");
        }
        if (!sigHash.equals(mgf1Hash)) {
            throw new GeneralSecurityException("sigHash and mgf1Hash must be the same");
        }
        Validators.validateRsaModulusSize(pubKey.getModulus().bitLength());
        Validators.validateRsaPublicExponent(pubKey.getPublicExponent());
        this.publicKey = pubKey;
        this.signatureAlgorithm = RsaSsaPssVerifyConscrypt.getConscryptRsaSsaPssAlgo(sigHash);
        this.parameterSpec = RsaSsaPssVerifyConscrypt.getPssParameterSpec(sigHash, mgf1Hash, saltLength);
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    @AccessesPartialKey
    public static PublicKeyVerify create(RsaSsaPssPublicKey key) throws GeneralSecurityException {
        if (!RsaSsaPssVerifyConscrypt.isSupported()) {
            throw new GeneralSecurityException("RSA SSA PSS using Conscrypt is not supported.");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", CONSCRYPT);
        RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(key.getModulus(), key.getParameters().getPublicExponent()));
        RsaSsaPssParameters params = key.getParameters();
        return new RsaSsaPssVerifyConscrypt(publicKey, params.getSigHashType(), params.getMgf1HashType(), params.getSaltLengthBytes(), key.getOutputPrefix().toByteArray(), key.getParameters().getVariant().equals(RsaSsaPssParameters.Variant.LEGACY) ? LEGACY_MESSAGE_SUFFIX : EMPTY);
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        if (!Util.isPrefix(this.outputPrefix, signature)) {
            throw new GeneralSecurityException("Invalid signature (output prefix mismatch)");
        }
        Signature verifier = Signature.getInstance(this.signatureAlgorithm, CONSCRYPT);
        verifier.initVerify(this.publicKey);
        verifier.setParameter(this.parameterSpec);
        verifier.update(data);
        if (this.messageSuffix.length > 0) {
            verifier.update(this.messageSuffix);
        }
        if (!verifier.verify(signature, this.outputPrefix.length, signature.length - this.outputPrefix.length)) {
            throw new GeneralSecurityException("signature verification failed");
        }
    }
}

