/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.ReferenceExistsException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidModeException;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/mode")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ModeResource {
    public static final String apiTag = "Modes (v1)";
    private static final Logger log = LoggerFactory.getLogger(ModeResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public ModeResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @Path(value="/{subject}")
    @PUT
    @DocumentedName(value="updateSubjectMode")
    @Operation(summary="Update subject mode", description="Update mode for the specified subject. On success, echoes the original request back to the client.", responses={@ApiResponse(responseCode="200", description="The original request.", content={@Content(schema=@Schema(implementation=ModeUpdateRequest.class))}), @ApiResponse(responseCode="422", description="Unprocessable Entity. Error code 42204 indicates an invalid mode. Error code 42205 indicates operation not permitted.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store. Error code 50003 indicates a failure forwarding the request to the primary. Error code 50004 indicates unknown leader.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Modes (v1)")})
    @PerformanceMetric(value="mode.update-subject")
    public ModeUpdateRequest updateMode(@Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject, @Context HttpHeaders headers, @Parameter(description="Update Request", required=true) @NotNull ModeUpdateRequest request, @Parameter(description="Whether to force update if setting mode to IMPORT and schemas currently exist") @QueryParam(value="force") boolean force) {
        if (subject != null && !QualifiedSubject.isValidSubject((String)this.schemaRegistry.tenant(), (String)subject)) {
            throw Errors.invalidSubjectException(subject);
        }
        subject = QualifiedSubject.isDefaultContext((String)this.schemaRegistry.tenant(), (String)subject) ? null : QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            if (request.getOptionalMode().isPresent()) {
                Enum.valueOf(io.confluent.kafka.schemaregistry.storage.Mode.class, request.getMode().toUpperCase(Locale.ROOT));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RestInvalidModeException();
        }
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.setModeOrForward(subject, request, force, headerProperties);
        }
        catch (ReferenceExistsException e) {
            throw Errors.referenceExistsException(e.getMessage());
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to update mode", e);
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Update mode operation timed out", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to update mode", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding update mode request to the leader", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while updating the mode", e);
        }
        return request;
    }

    @Path(value="/{subject}")
    @GET
    @DocumentedName(value="getSubjectMode")
    @Operation(summary="Get subject mode", description="Retrieves the subject mode.", responses={@ApiResponse(responseCode="200", description="The subject mode.", content={@Content(schema=@Schema(implementation=Mode.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Modes (v1)")})
    @PerformanceMetric(value="mode.get-subject")
    public Mode getMode(@Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to return the global mode if subject mode not found") @QueryParam(value="defaultToGlobal") boolean defaultToGlobal) {
        subject = QualifiedSubject.isDefaultContext((String)this.schemaRegistry.tenant(), (String)subject) ? null : QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            io.confluent.kafka.schemaregistry.storage.Mode mode;
            io.confluent.kafka.schemaregistry.storage.Mode mode2 = mode = defaultToGlobal ? this.schemaRegistry.getModeInScope(subject) : this.schemaRegistry.getMode(subject);
            if (mode == null) {
                throw Errors.subjectLevelModeNotConfiguredException(subject);
            }
            return new Mode(mode.name());
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Failed to get mode", e);
        }
    }

    @PUT
    @DocumentedName(value="updateGlobalMode")
    @Operation(summary="Update global mode", description="Update global mode. On success, echoes the original request back to the client.", responses={@ApiResponse(responseCode="200", description="The original request.", content={@Content(schema=@Schema(implementation=ModeUpdateRequest.class))}), @ApiResponse(responseCode="422", description="Unprocessable Entity. Error code 42204 indicates an invalid mode. Error code 42205 indicates operation not permitted.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store. Error code 50003 indicates a failure forwarding the request to the primary. Error code 50004 indicates unknown leader.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Modes (v1)")})
    @PerformanceMetric(value="mode.update-global")
    public ModeUpdateRequest updateTopLevelMode(@Context HttpHeaders headers, @Parameter(description="Update Request", required=true) @NotNull ModeUpdateRequest request, @Parameter(description="Whether to force update if setting mode to IMPORT and schemas currently exist") @QueryParam(value="force") boolean force) {
        return this.updateMode(null, headers, request, force);
    }

    @GET
    @DocumentedName(value="getGlobalMode")
    @Operation(summary="Get global mode", description="Retrieves global mode.", responses={@ApiResponse(responseCode="200", description="The global mode", content={@Content(schema=@Schema(implementation=Mode.class))}), @ApiResponse(responseCode="500", description="Error code 50001 -- Error in the backend data store")})
    @Tags(value={@Tag(name="Modes (v1)")})
    @PerformanceMetric(value="mode.get-global")
    public Mode getTopLevelMode() {
        return this.getMode(null, false);
    }

    @DELETE
    @Path(value="/{subject}")
    @DocumentedName(value="deleteSubjectMode")
    @Operation(summary="Delete subject mode", description="Deletes the specified subject-level mode and reverts to the global default.", responses={@ApiResponse(responseCode="200", description="Operation succeeded. Returns old mode.", content={@Content(schema=@Schema(implementation=Mode.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Modes (v1)")})
    @PerformanceMetric(value="mode.delete-subject")
    public void deleteSubjectMode(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject) {
        Mode deleteModeResponse;
        log.debug("Deleting mode for subject {}", (Object)subject);
        if (QualifiedSubject.isDefaultContext((String)this.schemaRegistry.tenant(), (String)subject)) {
            throw Errors.invalidSubjectException(subject);
        }
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            io.confluent.kafka.schemaregistry.storage.Mode deletedMode = this.schemaRegistry.getMode(subject);
            if (deletedMode == null) {
                throw Errors.subjectNotFoundException(subject);
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.deleteSubjectModeOrForward(subject, headerProperties);
            deleteModeResponse = new Mode(deletedMode.name());
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to delete mode", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to delete mode", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete mode request to the leader", e);
        }
        asyncResponse.resume((Object)deleteModeResponse);
    }
}

