/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import java.util.Set;

public class OptimizerResultReplicaMovements {
    private final int numInterBrokerReplicaMovements;
    private final long interBrokerDataToMove;
    private final int numLeadershipMovements;

    public OptimizerResultReplicaMovements(Set<PartitionProposal> partitionProposals) {
        int numInterBrokerReplicaMovements = 0;
        int numLeadershipMovements = 0;
        long interBrokerDataToMove = 0L;
        for (PartitionProposal p : partitionProposals) {
            if (!p.replicasToAdd().isEmpty() || !p.replicasToRemove().isEmpty()) {
                ++numInterBrokerReplicaMovements;
                interBrokerDataToMove += p.interBrokerDataToMoveInMB();
                continue;
            }
            ++numLeadershipMovements;
        }
        this.numInterBrokerReplicaMovements = numInterBrokerReplicaMovements;
        this.numLeadershipMovements = numLeadershipMovements;
        this.interBrokerDataToMove = interBrokerDataToMove;
    }

    public int numInterBrokerReplicaMovements() {
        return this.numInterBrokerReplicaMovements;
    }

    public long interBrokerDataToMove() {
        return this.interBrokerDataToMove;
    }

    public int numLeadershipMovements() {
        return this.numLeadershipMovements;
    }
}

