/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityCombinator;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.RebalanceStep;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.CapacityStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.util.HotPartitionsInfo;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaSortFunctionFactory;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CapacityGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityGoal.class);
    static final double SKEW_DELTA = 1.0E-4;
    private final Map<Integer, ViolatedLimit.Builder> violatedLimitBuilderByBroker = new HashMap<Integer, ViolatedLimit.Builder>();
    private final Map<Integer, ViolatedLimit> violatedLimitByBroker = new HashMap<Integer, ViolatedLimit>();
    private GoalBalanceInfo goalBalanceInfo;

    public CapacityGoal() {
    }

    @Override
    public boolean isHardGoal() {
        return true;
    }

    CapacityGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
    }

    protected abstract Resource.CompositeResource resource();

    public final List<Resource> utilizationResources() {
        return this.resource().utilizationResources;
    }

    public final Resource capacityResource() {
        return this.resource().capacityResource;
    }

    GoalBalanceInfo goalBalanceInfo() {
        return this.goalBalanceInfo;
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        double saturatedLimit = this.goalBalanceInfo().saturatedReplicaLimit();
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                Replica destinationReplica = destinationBroker.replica(action.destinationTopicPartition());
                return this.isSwapAcceptableForCapacity(clusterModel, sourceReplica, destinationReplica, saturatedLimit) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case LEADERSHIP_MOVEMENT: {
                return this.isMovementAcceptableForCapacity(clusterModel, sourceReplica, destinationBroker, saturatedLimit) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        boolean validPartitionMove = action.replicaMoves().entrySet().stream().allMatch(replicaMove -> this.isMovementAcceptableForCapacity(clusterModel, (Replica)replicaMove.getKey(), (Broker)replicaMove.getValue(), this.goalBalanceInfo().saturatedReplicaLimit()));
        return validPartitionMove ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, this.minMonitoredPartitionPercentage, true);
    }

    @Override
    public abstract String name();

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        return this.isMovementAcceptableForCapacity(clusterModel, sourceReplica, destinationBroker, this.goalBalanceInfo().saturatedReplicaLimit());
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return true;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.eligibleSourceBrokers();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        this.initializeVariables(clusterModel, optimizationMetricsOpt);
        this.preliminaryChecks(clusterModel);
    }

    protected void initializeVariables(ClusterModel clusterModel, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        HotPartitionsInfo hotPartitionsInfo = this.initClusterModel(clusterModel);
        optimizationMetricsOpt.ifPresent(optimizationMetrics -> this.maybeRegisterMetrics((OptimizationMetrics)optimizationMetrics, clusterModel, hotPartitionsInfo.totalNumHotPartitions(), hotPartitionsInfo.maxReplicaLoad()));
        this.goalBalanceInfo = new GoalBalanceInfo(clusterModel, hotPartitionsInfo.saturatedReplicas(), this.selfHealingCapacityViolationResponse().acceptAllCapacityViolations());
    }

    protected void preliminaryChecks(ClusterModel clusterModel) throws OptimizationFailureException {
        this.checkClusterUtilizationUnderTotalCapacity(clusterModel);
    }

    protected void checkClusterUtilizationUnderTotalCapacity(ClusterModel clusterModel) throws OptimizationFailureException {
        double totalCapacity;
        double existingUtilization = this.goalBalanceInfo.existingUtilization();
        if (!GoalUtils.isUtilAcceptableForCapacity(existingUtilization, totalCapacity = this.goalBalanceInfo.totalCapacity())) {
            throw new OptimizationFailureException(String.format("[%s] Insufficient healthy cluster capacity for resource: %s. Existing cluster utilization for %s is %f%s, total capacity %f%s.", new Object[]{this.name(), this.capacityResource(), this.utilizationResources(), existingUtilization, this.capacityResource().unit(), totalCapacity, this.capacityResource().unit()}));
        }
    }

    protected boolean brokerRemovalMode(ClusterModel clusterModel) {
        return !clusterModel.deadBrokers().isEmpty();
    }

    private void maybeRegisterMetrics(OptimizationMetrics optimizationMetrics, ClusterModel clusterModel, int totalNumHotPartitions, double maxReplicaLoad) {
        Map<Integer, Double> capacityByBroker = clusterModel.aliveBrokers().stream().collect(Collectors.toMap(Broker::id, v -> v.capacity(this.capacityResource()).totalCapacityFor(this.capacityResource())));
        Optional<Double> avgCapacity = GoalUtils.validateEvenBrokerResourceCapacities(capacityByBroker, this.capacityResource());
        if (!avgCapacity.isPresent()) {
            LOG.warn("Will not be reporting metrics as part of evaluating whether to trigger the even-cluster load task for {} because a capacity stats snapshot could not be computed. Check the previous logs for more information, most notably whether the cluster had the same capacities per broker.", this.getClass());
            return;
        }
        double allowedCapacityLimit = this.balancingConstraint.allowedCapacityForBroker(this.capacityResource(), avgCapacity.get());
        CapacityStatsSnapshot capacityStatsSnapshot = new CapacityStatsSnapshot(allowedCapacityLimit, this.capacityResource(), totalNumHotPartitions, maxReplicaLoad);
        optimizationMetrics.recordCapacityStats(this, capacityStatsSnapshot);
    }

    HotPartitionsInfo initClusterModel(ClusterModel clusterModel) {
        clusterModel.trackSortedReplicas(this.sortName(), null, ReplicaSortFunctionFactory.deprioritizeOfflineReplicasThenImmigrants(), ReplicaSortFunctionFactory.sortByMetricResourcesValue(this.utilizationResources()));
        clusterModel.trackSortedReplicas(this.sortNameByLeader(), ReplicaSortFunctionFactory.selectLeaders(), ReplicaSortFunctionFactory.deprioritizeImmigrants(), ReplicaSortFunctionFactory.sortByMetricResourcesValue(this.utilizationResources()));
        return GoalUtils.analyzeHotPartitions(clusterModel.aliveBrokers(), this.resource(), this.balancingConstraint, this.name(), this.sortName());
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (this.shouldChangeAllowedCapacityThresholdLimit(clusterModel)) {
            this.bumpAllowedCapacityLimit();
            return;
        }
        this.logImperfectBalanceSummary(clusterModel);
        try {
            this.checkUtilizationUnderAllowedCapacityForBrokers(clusterModel.allBrokers());
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
            GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
            this.finish();
        }
        finally {
            clusterModel.untrackSortedReplicas(this.sortName());
            clusterModel.untrackSortedReplicas(this.sortNameByLeader());
        }
    }

    private boolean bumpAllowedCapacityLimit() {
        if (this.balancingConstraint.updateCapacityThreshold(this.capacityResource())) {
            this.violatedLimitBuilderByBroker.clear();
            this.violatedLimitByBroker.clear();
            return true;
        }
        return false;
    }

    private boolean shouldChangeAllowedCapacityThresholdLimit(ClusterModel clusterModel) {
        if (this.balancingConstraint.canCapacityThresholdBeRelaxed(this.capacityResource())) {
            return clusterModel.allBrokers().stream().filter(b -> !GoalUtils.isUtilAcceptableForCapacity(this.brokerUtilization((Broker)b), this.brokerAllowedCapacity((Broker)b))).anyMatch(b -> !this.brokerIsSaturated((Broker)b));
        }
        return false;
    }

    protected void logImperfectBalanceSummary(ClusterModel clusterModel) {
        double eligibleCapacity;
        double eligibleUtilization;
        if (this.selfHealingCapacityViolationResponse() == CapacityViolationResponse.ACCEPT_SATURATED && !this.goalBalanceInfo.saturatedReplicas().isEmpty()) {
            LOG.info("Imperfect balance for {}, due to saturated replicas:{}{}", new Object[]{this.name(), System.lineSeparator(), this.saturatedReplicasToString()});
        }
        if (this.selfHealingCapacityViolationResponse() != CapacityViolationResponse.ACCEPT_ALWAYS) {
            return;
        }
        StringBuilder imperfectBalanceSummary = new StringBuilder();
        String nl = System.lineSeparator();
        imperfectBalanceSummary.append(String.format("Imperfect balance for %s, due to:" + nl, this.name()));
        double totalUtilization = this.goalBalanceInfo.existingUtilization();
        double allowedCapacity = this.goalBalanceInfo.allowedCapacity();
        boolean perfectBalance = true;
        if (!GoalUtils.isUtilAcceptableForCapacity(totalUtilization, allowedCapacity)) {
            imperfectBalanceSummary.append("Utilization > SBC Capacity").append(nl);
            perfectBalance = false;
        }
        if (!GoalUtils.isUtilAcceptableForCapacity(eligibleUtilization = this.goalBalanceInfo.eligibleUtilization(), eligibleCapacity = this.goalBalanceInfo.eligibleCapacity())) {
            imperfectBalanceSummary.append("Eligible Utilization > Eligible SBC Capacity").append(nl);
            perfectBalance = false;
        }
        if (!this.goalBalanceInfo.saturatedReplicas().isEmpty()) {
            imperfectBalanceSummary.append(String.format("Saturated Replicas:%s%s", nl, this.saturatedReplicasToString()));
            perfectBalance = false;
        }
        if (perfectBalance) {
            return;
        }
        imperfectBalanceSummary.append("Total Utilization:  ").append(this.twoDecimal(totalUtilization)).append(nl).append("Total SBC Capacity: ").append(this.twoDecimal(allowedCapacity)).append(nl).append("Total Capacity:     ").append(this.twoDecimal(this.goalBalanceInfo.totalCapacity())).append(nl);
        double minAllowedCapacityForBroker = this.minResourceAliveBroker(clusterModel, Broker.ResourceComparator.Mode.ALLOWED).allowedCapacity(this.resource(), this.balancingConstraint);
        imperfectBalanceSummary.append("Min Allowed / Total Broker Capacity: ").append(this.twoDecimal(minAllowedCapacityForBroker)).append(" / ").append(this.twoDecimal(this.minResourceAliveBroker(clusterModel, Broker.ResourceComparator.Mode.TOTAL).capacity().totalCapacityFor(this.capacityResource()))).append(nl);
        for (Broker broker : clusterModel.allBrokers()) {
            int brokerId = broker.id();
            double originalBrokerLoad = this.goalBalanceInfo.originalBrokerLoad(brokerId);
            int originalReplicaCount = this.goalBalanceInfo.originalBrokerReplicaCount(brokerId);
            imperfectBalanceSummary.append(brokerId).append(": ").append((Object)broker.strategy()).append(", ").append(this.brokerStatusPostBalanceToString(broker, originalBrokerLoad, minAllowedCapacityForBroker)).append(", Replica Count: ").append(originalReplicaCount);
            int currentReplicaCount = broker.replicas().size();
            if (originalReplicaCount != currentReplicaCount) {
                imperfectBalanceSummary.append(" --> ").append(currentReplicaCount);
            }
            imperfectBalanceSummary.append(", Load: ").append(this.twoDecimal(originalBrokerLoad));
            double currentBrokerLoad = broker.load().expectedUtilizationFor(this.resource());
            if (originalBrokerLoad != currentBrokerLoad) {
                imperfectBalanceSummary.append(" --> ").append(this.twoDecimal(currentBrokerLoad));
            }
            imperfectBalanceSummary.append(nl);
        }
        LOG.info(imperfectBalanceSummary.toString());
    }

    private String twoDecimal(double value) {
        return String.format("%.2f", value);
    }

    protected String brokerStatusPostBalanceToString(Broker broker, double originalBrokerLoad, double minAllowedResourceForBroker) {
        if (GoalUtils.isUtilAcceptableForCapacity(originalBrokerLoad, minAllowedResourceForBroker)) {
            return "BALANCED";
        }
        if (this.isBrokerUtilizationWithinAllowedLimit(broker)) {
            return "FIXED";
        }
        if (this.brokerIsSaturated(broker)) {
            return "SATURATED";
        }
        return "OVER-UTILIZED";
    }

    protected String saturatedReplicasToString() {
        StringBuilder replicasToString = new StringBuilder();
        for (Replica replica : this.goalBalanceInfo.saturatedReplicas()) {
            TopicPartition tp = replica.topicPartition();
            replicasToString.append("Topic-Partition: ");
            replicasToString.append(tp);
            replicasToString.append(", Broker: ");
            replicasToString.append(replica.broker().id());
            replicasToString.append(", Load: ");
            replicasToString.append(this.twoDecimal(replica.load().expectedUtilizationFor(this.resource())));
            replicasToString.append(System.lineSeparator());
        }
        return replicasToString.toString();
    }

    @Override
    public void finish() {
        if (!this.violatedLimitByBroker.isEmpty()) {
            LOG.info("As part of goal {}, the following brokers violated the capacity limit and were balanced: {}", (Object)this.name(), this.violatedLimitByBroker);
            this.violatedLimitByBroker.clear();
            this.violatedLimitBuilderByBroker.clear();
        }
        this.finished = true;
    }

    protected boolean brokerIsSaturated(Broker broker) {
        return this.goalBalanceInfo.saturatedReplicas().stream().anyMatch(r -> r.broker().equals(broker));
    }

    private void checkUtilizationUnderAllowedCapacityForBrokers(Set<Broker> brokers) throws OptimizationFailureException {
        for (Broker broker : brokers) {
            double allowedCapacityLimit = this.brokerAllowedCapacity(broker);
            if (this.selfHealingCapacityViolationResponse() == CapacityViolationResponse.ACCEPT_ALWAYS || this.selfHealingCapacityViolationResponse() == CapacityViolationResponse.ACCEPT_SATURATED && this.brokerIsSaturated(broker) && allowedCapacityLimit <= this.goalBalanceInfo.saturatedReplicaLimit()) continue;
            double utilization = this.brokerUtilization(broker);
            if (broker.replicas().isEmpty() || GoalUtils.isUtilAcceptableForCapacity(utilization, allowedCapacityLimit)) continue;
            throw new OptimizationFailureException(String.format("Optimization for goal %s failed because %s utilization for broker %d is %f which is above capacity limit %f.", this.name(), this.utilizationResources(), broker.id(), utilization, allowedCapacityLimit));
        }
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        LOG.debug("balancing broker {}, optimized goals = {}", (Object)broker, optimizedGoals);
        Resource capacityResource = this.capacityResource();
        double brokerCapacityLimit = this.balancingConstraint.allowedCapacityForBroker(capacityResource, broker.capacity());
        double brokerDesiredUtilizationLimit = this.balancingConstraint.desiredUtilizationLimitForBroker(capacityResource, broker.capacity());
        double hostCapacityLimit = this.balancingConstraint.allowedCapacityForBroker(capacityResource, broker.host().capacity());
        double hostDesiredUtilizationLimit = this.balancingConstraint.desiredUtilizationLimitForBroker(capacityResource, broker.host().capacity());
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        RebalanceContext context = new RebalanceContext(broker, this.resource(), brokerCapacityLimit, hostCapacityLimit, brokerDesiredUtilizationLimit, hostDesiredUtilizationLimit, clusterModel, excludedTopics, optimizedGoals, optimizationOptions);
        RebalanceStep rebalanceStep = new CheckShouldRebalance(context).onFailureThen(new LeadershipMovementRebalance(context)).onFailureThen(new ReplicaMovementRebalance(context)).onFailureThen(new PartitionMovementRebalance(context));
        rebalanceStep.balance();
        if (this.violatedLimitBuilderByBroker.containsKey(broker.id())) {
            double util = this.resource().isBrokerResource() ? context.broker.load().expectedUtilizationFor(this.resource()) : context.broker.host().load().expectedUtilizationFor(this.resource());
            this.violatedLimitByBroker.put(broker.id(), this.violatedLimitBuilderByBroker.get(broker.id()).build(util));
        }
        this.postSanityCheck(broker, brokerCapacityLimit, hostCapacityLimit, this.brokerRemovalMode(clusterModel));
    }

    protected boolean failIfBrokerOverUtilizedPostBalance(boolean brokerRemovalMode, Broker broker) {
        return brokerRemovalMode || this.selfHealingCapacityViolationResponse().failSelfHealingIfBrokerOverUtilizedPostBalance(this.brokerIsSaturated(broker));
    }

    private boolean canRelaxAllowedCapacity() {
        return this.balancingConstraint.canCapacityThresholdBeRelaxed(this.capacityResource());
    }

    private void postSanityCheck(Broker broker, double brokerCapacityLimit, double hostCapacityLimit, boolean brokerRemovalMode) throws OptimizationFailureException {
        if (!broker.currentOfflineReplicas().isEmpty()) {
            throw new OptimizationFailureException("Failed to remove offline replicas from broker " + broker.id() + ".");
        }
        boolean utilizationOverLimit = this.isUtilizationOverLimit(broker, brokerCapacityLimit, hostCapacityLimit);
        if (utilizationOverLimit && !this.canRelaxAllowedCapacity() && this.failIfBrokerOverUtilizedPostBalance(brokerRemovalMode, broker)) {
            Resource capacityResource = this.capacityResource();
            List<Resource> utilizationResources = this.utilizationResources();
            String errMsg = capacityResource.isHostResource() ? String.format("[%s] Violated capacity limit of %f for %s via host utilization of %f for %s with hostname %s.", new Object[]{this.name(), hostCapacityLimit, capacityResource, broker.host().load().expectedUtilizationFor(this.resource()), utilizationResources, broker.host().name()}) : String.format("[%s] Violated capacity limit of %f for %s via broker utilization of %f for %s with broker %d.", new Object[]{this.name(), brokerCapacityLimit, capacityResource, broker.load().expectedUtilizationFor(this.resource()), utilizationResources, broker.id()});
            throw new OptimizationFailureException(errMsg);
        }
    }

    private String sortName() {
        return this.name() + "-" + this.utilizationResources().stream().map(Enum::name).collect(Collectors.joining("-")) + "-ALL";
    }

    private String sortNameByLeader() {
        return this.name() + "-" + this.utilizationResources().stream().map(Enum::name).collect(Collectors.joining("-")) + "-LEADER";
    }

    protected Broker minResourceAliveBroker(ClusterModel clusterModel, Broker.ResourceComparator.Mode resourceComparatorMode) {
        return GoalUtils.minResourceInBrokers(clusterModel.aliveBrokers(), this.resource(), resourceComparatorMode, this.balancingConstraint);
    }

    private double minCurrentAllowedCapacity(ClusterModel clusterModel) {
        return this.minResourceAliveBroker(clusterModel, Broker.ResourceComparator.Mode.ALLOWED).allowedCapacity(this.resource(), this.balancingConstraint);
    }

    private boolean isUtilizationOverLimit(Broker broker, double brokerCapacityLimit, double hostCapacityLimit) {
        Resource capacityResource = this.capacityResource();
        double capacityLimit = capacityResource.isHostResource() ? hostCapacityLimit : brokerCapacityLimit;
        return this.replicasOnBrokerOrHost(broker) && !GoalUtils.isUtilAcceptableForCapacity(this.brokerUtilization(broker), capacityLimit);
    }

    protected boolean isMovementAcceptableForCapacity(ClusterModel clusterModel, Replica sourceReplica, Broker destinationBroker, double saturatedLimit) {
        double replicaUtilization = sourceReplica.load().expectedUtilizationFor(this.resource());
        return this.isMovementAcceptableForCapacity(clusterModel, sourceReplica.broker(), replicaUtilization, destinationBroker, saturatedLimit);
    }

    protected boolean isMovementAcceptableForCapacity(ClusterModel clusterModel, Broker sourceBroker, double utilization, Broker destinationBroker, double saturatedLimit) {
        double dstBrokerUtilization = this.brokerUtilization(destinationBroker);
        boolean sourceAboveCapacity = !GoalUtils.isUtilAcceptableForCapacity(this.brokerUtilization(sourceBroker), this.brokerTotalCapacity(sourceBroker));
        boolean destinationBelowCapacityAfterMove = GoalUtils.isUtilAcceptableForCapacity(dstBrokerUtilization + utilization, this.brokerTotalCapacity(destinationBroker));
        boolean destinationBelowAllowedCapacityAfterMove = this.isBrokerUtilizationWithinAllowedLimitAfterAddingLoad(destinationBroker, utilization);
        if (sourceAboveCapacity && destinationBelowCapacityAfterMove && clusterModel.eligibleDestinationBrokers().stream().noneMatch(b -> this.brokerUtilization((Broker)b) < dstBrokerUtilization)) {
            if (destinationBelowAllowedCapacityAfterMove) {
                return true;
            }
            if (sourceBroker.replicas().stream().map(r -> r.load().expectedUtilizationFor(this.resource())).noneMatch(load -> load > 0.0 && load < utilization)) {
                return true;
            }
        }
        boolean moveBetweenOverUtilizedBrokersDecreasesSkew = !this.isBrokerUtilizationWithinAllowedLimit(destinationBroker) && !this.isBrokerUtilizationWithinAllowedLimit(sourceBroker) && this.isSkewDecreasedOrSameAfterMovingLoad(sourceBroker, utilization, destinationBroker);
        boolean moveIsWithinAllowedLimitOrDecreasesSkew = destinationBelowAllowedCapacityAfterMove || moveBetweenOverUtilizedBrokersDecreasesSkew;
        return utilization <= saturatedLimit && moveIsWithinAllowedLimitOrDecreasesSkew;
    }

    protected boolean isSkewDecreasedOrSameAfterMovingLoad(Broker sourceBroker, double utilToMove, Broker destinationBroker) {
        double originalSourceUtilization = this.brokerUtilization(sourceBroker);
        double originalDestinationUtilization = this.brokerUtilization(destinationBroker);
        return this.isSkewDecreasedOrSameAfterMovingLoad(originalSourceUtilization, utilToMove, originalDestinationUtilization);
    }

    protected boolean isSkewDecreasedOrSameAfterMovingLoad(double originalSourceUtilization, double utilToMove, double originalDestinationUtilization) {
        double newSkew;
        double originalSkew = Math.abs(originalSourceUtilization - originalDestinationUtilization);
        return originalSkew + 1.0E-4 >= (newSkew = Math.abs(originalSourceUtilization - utilToMove - (originalDestinationUtilization + utilToMove)));
    }

    private boolean isSwapAcceptableForCapacity(ClusterModel clusterModel, Replica replicaA, Replica replicaB, double saturatedLimit) {
        if (replicaA.isSaturatedForResource(this.capacityResource()) || replicaB.isSaturatedForResource(this.capacityResource())) {
            return false;
        }
        double replicaAUtilization = replicaA.load().expectedUtilizationFor(this.resource());
        double replicaBUtilization = replicaB.load().expectedUtilizationFor(this.resource());
        double brokerAUtilizationDelta = replicaBUtilization - replicaAUtilization;
        return brokerAUtilizationDelta > 0.0 ? this.isMovementAcceptableForCapacity(clusterModel, replicaB.broker(), brokerAUtilizationDelta, replicaA.broker(), saturatedLimit) : this.isMovementAcceptableForCapacity(clusterModel, replicaA.broker(), -brokerAUtilizationDelta, replicaB.broker(), saturatedLimit);
    }

    protected boolean isBrokerUtilizationWithinAllowedLimitAfterAddingLoad(Broker destinationBroker, double loadToAdd) {
        return GoalUtils.isUtilAcceptableForCapacity(this.brokerUtilization(destinationBroker) + loadToAdd, this.brokerAllowedCapacity(destinationBroker));
    }

    protected boolean isBrokerUtilizationWithinAllowedLimit(Broker broker) {
        return this.isBrokerUtilizationWithinAllowedLimitAfterAddingLoad(broker, 0.0);
    }

    protected double brokerUtilization(Broker broker) {
        if (this.capacityResource().isHostResource()) {
            return broker.host().load().expectedUtilizationFor(this.resource());
        }
        return broker.load().expectedUtilizationFor(this.resource());
    }

    protected boolean replicasOnBrokerOrHost(Broker broker) {
        return this.capacityResource().isHostResource() ? !broker.host().replicas().isEmpty() : !broker.replicas().isEmpty();
    }

    protected double brokerAllowedCapacity(Broker broker) {
        if (this.capacityResource().isHostResource()) {
            return this.balancingConstraint.allowedCapacityForBroker(this.capacityResource(), broker.host().capacity());
        }
        return this.balancingConstraint.allowedCapacityForBroker(this.capacityResource(), broker.capacity());
    }

    double brokerTotalCapacity(Broker broker) {
        if (this.capacityResource().isHostResource()) {
            return broker.host().capacity().totalCapacityFor(this.capacityResource());
        }
        return broker.capacity().totalCapacityFor(this.capacityResource());
    }

    public List<Broker> eligibleBrokersReplicaMove(ClusterModel clusterModel, Resource.CompositeResource compositeResource) {
        Resource capacityResource = compositeResource.capacityResource;
        List<Resource> utilResources = compositeResource.utilizationResources;
        ClusterModel.CapacityLimitProvider capacityLimitProvider = broker -> this.balancingConstraint.allowedCapacityForBroker(capacityResource, broker.capacity());
        return clusterModel.brokersUnderCapacityLimit(clusterModel.eligibleDestinationBrokers(), utilResources, capacityLimitProvider).stream().filter(Broker::isEligibleDestination).sorted((o1, o2) -> {
            double expectedLoad1 = this.brokerUtilization((Broker)o1);
            double expectedLoad2 = this.brokerUtilization((Broker)o2);
            return Double.compare(expectedLoad1, expectedLoad2);
        }).collect(Collectors.toList());
    }

    protected boolean shouldExcludeForReplicaMove(Replica replica) {
        return false;
    }

    protected CapacityViolationResponse selfHealingCapacityViolationResponse() {
        return CapacityViolationResponse.FAIL_ALWAYS;
    }

    private static class ViolatedLimit {
        public final double preBalanceUtilization;
        public final double postBalanceUtilization;
        public final double limit;

        public ViolatedLimit(double limit, double preBalanceUtilization, double postBalanceUtilization) {
            this.limit = limit;
            this.preBalanceUtilization = preBalanceUtilization;
            this.postBalanceUtilization = postBalanceUtilization;
        }

        public String toString() {
            return String.format("LimitCheck{preBalanceUtilization=%f, postBalanceUtilization=%f, limit=%f}", this.preBalanceUtilization, this.postBalanceUtilization, this.limit);
        }

        public static class Builder {
            private final double limit;
            private final double preBalanceUtilization;

            public Builder(double limit, double preBalanceUtilization) {
                this.limit = limit;
                this.preBalanceUtilization = preBalanceUtilization;
            }

            public ViolatedLimit build(double postBalanceUtilization) {
                return new ViolatedLimit(this.limit, this.preBalanceUtilization, postBalanceUtilization);
            }
        }
    }

    static class RebalanceContext {
        private final Broker broker;
        private final Resource.CompositeResource compositeResource;
        private final double brokerCapacityLimit;
        private final double hostCapacityLimit;
        private double brokerDesiredUtilizationLimit;
        private double hostDesiredUtilizationLimit;
        private final ClusterModel clusterModel;
        private final Set<String> excludedTopics;
        private final Set<Goal> optimizedGoals;
        private final OptimizationOptions optimizationOptions;

        RebalanceContext(Broker broker, Resource.CompositeResource compositeResource, double brokerCapacityLimit, double hostCapacityLimit, double brokerDesiredUtilizationLimit, double hostDesiredUtilizationLimit, ClusterModel clusterModel, Set<String> excludedTopics, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
            this.broker = broker;
            this.compositeResource = compositeResource;
            this.brokerCapacityLimit = brokerCapacityLimit;
            this.hostCapacityLimit = hostCapacityLimit;
            this.brokerDesiredUtilizationLimit = brokerDesiredUtilizationLimit;
            this.hostDesiredUtilizationLimit = hostDesiredUtilizationLimit;
            if (brokerDesiredUtilizationLimit > brokerCapacityLimit || hostDesiredUtilizationLimit > hostCapacityLimit) {
                throw new IllegalArgumentException(String.format("Desired {broker, host} utilization limit (%f, %f) cannot be greater than the allowed {broker, host} capacity limit (%f, %f).", brokerDesiredUtilizationLimit, hostDesiredUtilizationLimit, brokerCapacityLimit, hostCapacityLimit));
            }
            if (brokerDesiredUtilizationLimit < 0.0 && brokerCapacityLimit != -1.0 || hostDesiredUtilizationLimit < 0.0 && hostCapacityLimit != -1.0) {
                throw new IllegalArgumentException(String.format("Desired {broker, host} utilization limit (%f, %f) cannot be negative.", brokerDesiredUtilizationLimit, hostDesiredUtilizationLimit));
            }
            this.clusterModel = clusterModel;
            this.excludedTopics = excludedTopics;
            this.optimizedGoals = optimizedGoals;
            this.optimizationOptions = optimizationOptions;
        }

        public Broker broker() {
            return this.broker;
        }

        public List<Resource> utilizationResources() {
            return this.compositeResource.utilizationResources;
        }

        public double brokerCapacityLimit() {
            return this.brokerCapacityLimit;
        }

        public double brokerDesiredUtilizationLimit() {
            return this.brokerDesiredUtilizationLimit;
        }

        public double hostCapacityLimit() {
            return this.hostCapacityLimit;
        }

        public double hostDesiredUtilizationLimit() {
            return this.hostDesiredUtilizationLimit;
        }

        public ClusterModel clusterModel() {
            return this.clusterModel;
        }

        public Set<String> excludedTopics() {
            return this.excludedTopics;
        }

        public Set<Goal> optimizedGoals() {
            return this.optimizedGoals;
        }

        public OptimizationOptions optimizationOptions() {
            return this.optimizationOptions;
        }
    }

    class PartitionMovementRebalance
    extends AbstractDesiredCapacityGoalRebalanceStep {
        PartitionMovementRebalance(RebalanceContext context) {
            super(context);
        }

        @Override
        public boolean doBalance() {
            if (this.context.clusterModel().skipCellBalancing()) {
                return this.isBrokerBalanced();
            }
            this.rebalanceByPartitionMove(this.context.broker());
            return this.isBrokerBalanced();
        }

        private List<Replica> replicasInDescendingSize(Collection<Replica> replicas) {
            ArrayList<Replica> replicasList = new ArrayList<Replica>(replicas);
            replicasList.sort((replica1, replica2) -> {
                double replica1Utilization = replica1.load().expectedUtilizationFor(CapacityGoal.this.resource());
                double replica2Utilization = replica2.load().expectedUtilizationFor(CapacityGoal.this.resource());
                return Double.compare(replica2Utilization, replica1Utilization);
            });
            return replicasList;
        }

        private boolean movePartition(Replica replica) {
            TopicPartition topicPartition = replica.topicPartition();
            double maxReplicaResource = this.context.clusterModel.partition(topicPartition).replicas().stream().mapToDouble(r -> r.load().expectedUtilizationFor(CapacityGoal.this.resource())).max().orElseThrow(() -> new IllegalStateException(String.format("CapacityGoal cannot find maxReplicaResource since there is no replica of the topic partition %s in the ClusterModel.", topicPartition)));
            ArrayList<Cell> candidateCells = new ArrayList<Cell>(this.context.clusterModel.cells());
            candidateCells.remove(replica.broker().cell());
            Collections.shuffle(candidateCells);
            for (Cell cell : candidateCells) {
                List<Replica> replicasToMove = this.context.clusterModel().partition(topicPartition).replicasNotInCell(cell);
                boolean replicasOnExcludedBroker = replicasToMove.stream().anyMatch(r -> !r.broker().isEligible());
                if (replicasOnExcludedBroker) break;
                List availableBrokers = cell.aliveBrokers().stream().filter(broker -> GoalUtils.isUtilAcceptableForCapacity(maxReplicaResource, broker.unusedAllowedCapacity(CapacityGoal.this.resource(), CapacityGoal.this.balancingConstraint)) && !broker.hasReplicaOfPartition(topicPartition) && this.context.clusterModel.partition(topicPartition).canAssignReplicaToBroker((Broker)broker) && broker.isEligibleDestination()).collect(Collectors.toList());
                if (availableBrokers.size() < replicasToMove.size()) continue;
                availableBrokers.sort(new Broker.ResourceComparator(CapacityGoal.this.resource(), CapacityGoal.this.balancingConstraint, Broker.ResourceComparator.Mode.UNUSED_ALLOWED, false));
                Iterable<List<Broker>> candidateBrokersIterable = EntityCombinator.singleEntityListIterable(availableBrokers, replicasToMove.size());
                Map<Replica, Broker> replicaMoves = GoalUtils.getPartitionMoves(this.context.clusterModel, this.context.optimizedGoals, replicasToMove, candidateBrokersIterable);
                if (replicaMoves.isEmpty()) continue;
                replicaMoves.forEach((replicaToMove, broker) -> CapacityGoal.this.relocateReplica(this.context.clusterModel, replicaToMove.topicPartition(), replicaToMove.broker().id(), broker.id()));
                return true;
            }
            return false;
        }

        private void rebalanceByPartitionMove(Broker sourceBroker) {
            List<Replica> brokerReplicas = this.replicasInDescendingSize(sourceBroker.replicas());
            for (Replica replica : brokerReplicas) {
                boolean success;
                if (!AbstractGoal.shouldExclude(replica, this.context.excludedTopics()) && (success = this.movePartition(replica)) && this.isBrokerBalanced()) break;
            }
        }
    }

    private class ReplicaMovementRebalance
    extends AbstractDesiredCapacityGoalRebalanceStep {
        ReplicaMovementRebalance(RebalanceContext context) {
            super(context);
        }

        @Override
        public boolean doBalance() {
            List<Broker> sortedEligibleDestinationBrokersUnderCapacityLimit = CapacityGoal.this.eligibleBrokersReplicaMove(this.context.clusterModel, CapacityGoal.this.resource());
            List<Replica> replicas = this.context.broker().trackedSortedReplicas(CapacityGoal.this.sortName()).reverselySortedReplicas();
            for (Replica replica : replicas) {
                if (AbstractGoal.shouldExclude(replica, this.context.excludedTopics()) || CapacityGoal.this.shouldExcludeForReplicaMove(replica)) continue;
                double utilization = replica.load().expectedUtilizationFor(CapacityGoal.this.resource());
                if (utilization == 0.0 && replica.broker().isAlive()) {
                    LOG.debug("Skipping {} replica as it has zero utilization.", (Object)replica);
                    continue;
                }
                int numPartitionCells = GoalUtils.numPartitionCells(this.context.clusterModel.partition(replica.topicPartition()));
                List<Broker> sortedAliveBrokersUnderCapacityLimitInCell = sortedEligibleDestinationBrokersUnderCapacityLimit.stream().filter(broker -> numPartitionCells > 1 || broker.cell().equals(replica.broker().cell())).filter(b -> !b.hasReplicaOfPartition(replica.topicPartition())).collect(Collectors.toList());
                Broker b2 = CapacityGoal.this.maybeApplyBalancingAction(this.context.clusterModel(), replica, sortedAliveBrokersUnderCapacityLimitInCell, ActionType.INTER_BROKER_REPLICA_MOVEMENT, this.context.optimizedGoals(), this.context.optimizationOptions(), Optional.empty());
                if (b2 == null) {
                    LOG.debug("Failed to move replica {} to any broker in {}", (Object)replica, sortedAliveBrokersUnderCapacityLimitInCell);
                }
                if (this.isBrokerBalanced()) break;
                sortedEligibleDestinationBrokersUnderCapacityLimit = CapacityGoal.this.eligibleBrokersReplicaMove(this.context.clusterModel, CapacityGoal.this.resource());
            }
            return this.isBrokerBalanced();
        }
    }

    private class LeadershipMovementRebalance
    extends AbstractDesiredCapacityGoalRebalanceStep {
        LeadershipMovementRebalance(RebalanceContext context) {
            super(context);
        }

        @Override
        public boolean doBalance() {
            if (CapacityGoal.this.shouldTryLeadershipMovement(this.context.utilizationResources())) {
                List<Replica> sortedLeadersInSourceBroker = this.context.broker().trackedSortedReplicas(CapacityGoal.this.sortNameByLeader()).reverselySortedReplicas();
                for (Replica leader : sortedLeadersInSourceBroker) {
                    if (AbstractGoal.shouldExclude(leader, this.context.excludedTopics())) continue;
                    double utilization = leader.load().expectedUtilizationFor(CapacityGoal.this.resource());
                    if (utilization == 0.0 && leader.broker().isAlive()) {
                        LOG.debug("Skipping {} leader replica as it has zero utilization.", (Object)leader);
                        continue;
                    }
                    List<Replica> onlineFollowers = this.context.clusterModel().partition(leader.topicPartition()).onlineFollowers();
                    GoalUtils.sortReplicasInAscendingOrderByBrokerResourceUtilization(onlineFollowers, this.context.compositeResource);
                    List<Broker> eligibleBrokers = onlineFollowers.stream().map(Replica::broker).filter(Broker::isEligibleDestination).collect(Collectors.toList());
                    Broker b = CapacityGoal.this.maybeApplyBalancingAction(this.context.clusterModel(), leader, eligibleBrokers, ActionType.LEADERSHIP_MOVEMENT, this.context.optimizedGoals(), this.context.optimizationOptions(), Optional.empty());
                    if (b == null) {
                        LOG.debug("Failed to move leader replica {} to any other brokers in {}", (Object)leader, eligibleBrokers);
                    }
                    if (!this.isBrokerUtilizationUnderLimit()) continue;
                    break;
                }
            }
            return this.isBrokerBalanced();
        }
    }

    private class CheckShouldRebalance
    extends AbstractCapacityGoalRebalanceStep {
        CheckShouldRebalance(RebalanceContext context) {
            super(context);
        }

        @Override
        double hostCapacityLimit() {
            return this.context.hostCapacityLimit();
        }

        @Override
        double brokerCapacityLimit() {
            return this.context.brokerCapacityLimit();
        }

        @Override
        public boolean doBalance() {
            boolean isBrokerBalanced = this.isBrokerBalanced();
            boolean isOverLimit = CapacityGoal.this.isUtilizationOverLimit(this.context.broker, this.context.brokerCapacityLimit, this.context.hostCapacityLimit);
            if (isOverLimit) {
                double capacity = CapacityGoal.this.resource().isBrokerResource() ? this.context.brokerCapacityLimit : this.context.hostCapacityLimit;
                double util = CapacityGoal.this.resource().isBrokerResource() ? this.context.broker.load().expectedUtilizationFor(CapacityGoal.this.resource()) : this.context.broker.host().load().expectedUtilizationFor(CapacityGoal.this.resource());
                CapacityGoal.this.violatedLimitBuilderByBroker.put(this.context.broker().id(), new ViolatedLimit.Builder(capacity, util));
            }
            return isBrokerBalanced;
        }
    }

    private abstract class AbstractDesiredCapacityGoalRebalanceStep
    extends AbstractCapacityGoalRebalanceStep {
        AbstractDesiredCapacityGoalRebalanceStep(RebalanceContext context) {
            super(context);
        }

        @Override
        double hostCapacityLimit() {
            return this.context.hostDesiredUtilizationLimit();
        }

        @Override
        double brokerCapacityLimit() {
            return this.context.brokerDesiredUtilizationLimit();
        }
    }

    private abstract class AbstractCapacityGoalRebalanceStep
    implements RebalanceStep {
        protected final RebalanceContext context;

        AbstractCapacityGoalRebalanceStep(RebalanceContext context) {
            this.context = context;
        }

        private boolean isUtilizationOverLimit() {
            return CapacityGoal.this.isUtilizationOverLimit(this.context.broker(), this.brokerCapacityLimit(), this.hostCapacityLimit());
        }

        abstract double hostCapacityLimit();

        abstract double brokerCapacityLimit();

        protected boolean isBrokerUtilizationUnderLimit() {
            return !this.isUtilizationOverLimit();
        }

        protected boolean isBrokerBalanced() {
            return this.isBrokerUtilizationUnderLimit() && this.context.broker().currentOfflineReplicas().isEmpty();
        }
    }

    protected class GoalBalanceInfo {
        private final Map<Integer, Integer> originalReplicaCountPerBroker = new HashMap<Integer, Integer>();
        private final Map<Integer, Double> originalLoadPerBroker = new HashMap<Integer, Double>();
        private final Set<Replica> saturatedReplicas;
        private final double saturatedReplicaLimit;
        private final double existingUtilization;
        private final double allowedCapacity;
        private final double totalCapacity;
        private double eligibleUtilization;
        private double eligibleCapacity;

        GoalBalanceInfo(ClusterModel clusterModel, Set<Replica> saturatedReplicas, boolean storeOriginalBrokerLoadAndCount) {
            this.saturatedReplicas = saturatedReplicas;
            this.saturatedReplicaLimit = CapacityGoal.this.minCurrentAllowedCapacity(clusterModel);
            Resource capacityResource = CapacityGoal.this.capacityResource();
            this.existingUtilization = clusterModel.load().expectedUtilizationFor(CapacityGoal.this.resource());
            this.allowedCapacity = clusterModel.aliveBrokers().stream().map(b -> CapacityGoal.this.balancingConstraint.allowedCapacityForBroker(capacityResource, b.capacity())).mapToDouble(Double::doubleValue).sum();
            this.totalCapacity = clusterModel.aliveBrokers().stream().map(b -> b.capacity().totalCapacityFor(capacityResource)).mapToDouble(Double::doubleValue).sum();
            this.eligibleUtilization = 0.0;
            this.eligibleCapacity = 0.0;
            for (Broker broker : clusterModel.eligibleSourceBrokers()) {
                this.eligibleUtilization += broker.load().expectedUtilizationFor(CapacityGoal.this.resource());
            }
            for (Broker broker : clusterModel.eligibleDestinationBrokers()) {
                Capacity capacity = broker.capacity(capacityResource);
                double brokerCapacity = CapacityGoal.this.balancingConstraint.allowedCapacityForBroker(capacityResource, capacity);
                this.eligibleCapacity += brokerCapacity;
            }
            if (storeOriginalBrokerLoadAndCount) {
                for (Broker broker : clusterModel.allBrokers()) {
                    this.originalReplicaCountPerBroker.put(broker.id(), broker.numReplicas());
                    this.originalLoadPerBroker.put(broker.id(), broker.load().expectedUtilizationFor(CapacityGoal.this.resource()));
                }
            }
        }

        protected Set<Replica> saturatedReplicas() {
            return this.saturatedReplicas;
        }

        protected double saturatedReplicaLimit() {
            return this.saturatedReplicaLimit;
        }

        protected double existingUtilization() {
            return this.existingUtilization;
        }

        protected double allowedCapacity() {
            return this.allowedCapacity;
        }

        protected double totalCapacity() {
            return this.totalCapacity;
        }

        protected double eligibleUtilization() {
            return this.eligibleUtilization;
        }

        protected double eligibleCapacity() {
            return this.eligibleCapacity;
        }

        protected double originalBrokerLoad(int id) {
            return this.originalLoadPerBroker.getOrDefault(id, -1.0);
        }

        protected int originalBrokerReplicaCount(int id) {
            return this.originalReplicaCountPerBroker.getOrDefault(id, -1);
        }
    }

    static enum CapacityViolationResponse {
        FAIL_ALWAYS,
        ACCEPT_SATURATED,
        ACCEPT_ALWAYS;


        boolean acceptAllCapacityViolations() {
            return this == ACCEPT_ALWAYS;
        }

        boolean failOnAnyCapacityViolation() {
            return this == FAIL_ALWAYS;
        }

        boolean onlyAcceptOverUtilizedBrokerIfSaturated() {
            return this == ACCEPT_SATURATED;
        }

        private boolean failSelfHealingIfBrokerOverUtilizedPostBalance(boolean brokerIsSaturated) {
            return this.failOnAnyCapacityViolation() || this.onlyAcceptOverUtilizedBrokerIfSaturated() && !brokerIsSaturated;
        }
    }
}

