/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerProposalLeaderboard;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalLeaderboard;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ProposalObservabilityTrackingOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public class ProposalStats {
    private final int numProposalsGenerated;
    private final int numProposalsRejected;
    private final int numProposalsAccepted;
    private final int numMovesAccepted;
    private final int numSwapsAccepted;
    private final int numPartitionMovesAccepted;
    private final Map<String, Integer> rejectingGoalCount;
    private final ProposalLeaderboard.Result proposalLeaderboardResult;

    private ProposalStats(int numProposalsGenerated, int numProposalsRejected, int numProposalsAccepted, int numMovesAccepted, int numSwapsAccepted, int numPartitionMovesAccepted, Map<String, Integer> rejectingGoalCount, ProposalLeaderboard.Result proposalLeaderboardResult) {
        this.numProposalsGenerated = numProposalsGenerated;
        this.numProposalsRejected = numProposalsRejected;
        this.numProposalsAccepted = numProposalsAccepted;
        this.numMovesAccepted = numMovesAccepted;
        this.numSwapsAccepted = numSwapsAccepted;
        this.numPartitionMovesAccepted = numPartitionMovesAccepted;
        this.rejectingGoalCount = rejectingGoalCount;
        this.proposalLeaderboardResult = proposalLeaderboardResult;
    }

    public int proposalsGenerated() {
        return this.numProposalsGenerated;
    }

    public int proposalsRejected() {
        return this.numProposalsRejected;
    }

    public double proposalsRejectedPercent() {
        return this.numProposalsGenerated == 0 ? 0.0 : (double)this.numProposalsRejected / (double)this.numProposalsGenerated;
    }

    public int proposalsAccepted() {
        return this.numProposalsAccepted;
    }

    public double proposalsAcceptedPercent() {
        return this.numProposalsGenerated == 0 ? 0.0 : (double)this.numProposalsAccepted / (double)this.numProposalsGenerated;
    }

    public int movesAccepted() {
        return this.numMovesAccepted;
    }

    public int swapsAccepted() {
        return this.numSwapsAccepted;
    }

    public int partitionMovesAccepted() {
        return this.numPartitionMovesAccepted;
    }

    public Map<String, Integer> rejectingGoalCount() {
        return this.rejectingGoalCount;
    }

    public String toString() {
        return this.generateString(false);
    }

    public String generateString(boolean isVerbose) {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.lineSeparator();
        sb.append(String.format("%d proposals generated -- %d rejected (%.2g), %d accepted (%.2g) -- %d moves, %d swaps%s%s", this.numProposalsGenerated, this.numProposalsRejected, this.numProposalsGenerated == 0 ? 0.0 : (double)this.numProposalsRejected / (double)this.numProposalsGenerated, this.numProposalsAccepted, this.numProposalsGenerated == 0 ? 0.0 : (double)this.numProposalsAccepted / (double)this.numProposalsGenerated, this.numMovesAccepted, this.numSwapsAccepted, this.numPartitionMovesAccepted > 0 ? String.format(", %d partition moves", this.numPartitionMovesAccepted) : "", lineSep));
        if (!this.rejectingGoalCount.isEmpty()) {
            sb.append(String.format("Proposal rejections by rejecting goal:%s", lineSep));
            for (String rejectingGoal : this.rejectingGoalCount.keySet()) {
                sb.append(String.format("%8s%s: %d%s", " ", rejectingGoal, this.rejectingGoalCount.get(rejectingGoal), lineSep));
            }
        }
        if (isVerbose) {
            sb.append(this.generateProposalLeaderboardString());
        }
        return sb.toString();
    }

    String generateProposalLeaderboardString() {
        if (this.proposalLeaderboardResult.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String lineSep = System.lineSeparator();
        sb.append(String.format("Top-%d proposals by broker being rebalanced:%s", this.proposalLeaderboardResult.maxNumProposalsPerLeaderboard(), lineSep));
        for (Map.Entry<Integer, BrokerProposalLeaderboard.Result> entry : this.proposalLeaderboardResult.leaderboardByBroker().entrySet()) {
            int brokerId = entry.getKey();
            BrokerProposalLeaderboard.Result brokerResult = entry.getValue();
            this.populateLeaderboard(sb, brokerResult.topAcceptedProposals(), "ACCEPTED", brokerId, lineSep);
            this.populateLeaderboard(sb, brokerResult.topRejectedProposals(), "REJECTED", brokerId, lineSep);
        }
        return sb.toString();
    }

    private void populateLeaderboard(StringBuilder sb, List<DetailedProposal.Result> topProposals, String acceptedStr, int brokerId, String lineSeparator) {
        if (topProposals.size() > 0) {
            sb.append(String.format(" Broker %d top-%d %s proposals:%s", brokerId, topProposals.size(), acceptedStr, lineSeparator));
            int i = 1;
            for (DetailedProposal.Result proposal : topProposals) {
                sb.append(String.format("  %d. %s%s", i, proposal.toString(), lineSeparator));
                ++i;
            }
        } else {
            sb.append(String.format(" Broker %d had no %s proposals.%s", brokerId, acceptedStr, lineSeparator));
        }
    }

    @NotThreadSafe
    public static class Builder {
        private int numProposalsGenerated = 0;
        private int numProposalsRejected = 0;
        private int numProposalsAccepted = 0;
        private int numMovesAccepted = 0;
        private int numSwapsAccepted = 0;
        private int numPartitionMovesAccepted = 0;
        private final Map<String, Integer> rejectingGoalCount = new HashMap<String, Integer>();
        private final ProposalLeaderboard proposalLeaderboard;
        private boolean closed = false;
        private ProposalStats stats = null;

        public Builder(ProposalObservabilityTrackingOptions proposalObservabilityTrackingOptions) {
            this.proposalLeaderboard = new ProposalLeaderboard(proposalObservabilityTrackingOptions);
        }

        public void trackProposalGenerated() {
            this.checkClosed();
            ++this.numProposalsGenerated;
        }

        public void trackProposalRejected(Optional<String> rejectingGoal, Optional<DetailedProposal.Result> detailedProposal) {
            this.checkClosed();
            ++this.numProposalsRejected;
            rejectingGoal.ifPresent(goal -> this.rejectingGoalCount.merge((String)goal, 1, Integer::sum));
            detailedProposal.ifPresent(this.proposalLeaderboard::submitProposal);
        }

        public void trackProposalAccepted(ActionType actionType, Optional<DetailedProposal.Result> detailedProposal) {
            this.checkClosed();
            ++this.numProposalsAccepted;
            switch (actionType) {
                case INTER_BROKER_REPLICA_MOVEMENT: {
                    ++this.numMovesAccepted;
                    break;
                }
                case INTER_BROKER_REPLICA_SWAP: {
                    ++this.numSwapsAccepted;
                    break;
                }
                case INTER_CELL_PARTITION_MOVEMENT: {
                    ++this.numPartitionMovesAccepted;
                }
            }
            detailedProposal.ifPresent(this.proposalLeaderboard::submitProposal);
        }

        public void revertAcceptedProposals(int brokerId, int numProposalsAcceptedForBroker, int numMovesAcceptedForBroker, Optional<String> rejectingGoal) {
            this.checkClosed();
            this.numProposalsAccepted -= numProposalsAcceptedForBroker;
            this.numMovesAccepted -= numMovesAcceptedForBroker;
            this.numProposalsRejected += numProposalsAcceptedForBroker;
            rejectingGoal.ifPresent(goal -> this.rejectingGoalCount.merge((String)goal, numProposalsAcceptedForBroker, Integer::sum));
            this.proposalLeaderboard.revertAcceptedProposals(brokerId);
        }

        public ProposalStats seal() {
            if (!this.closed) {
                this.stats = new ProposalStats(this.numProposalsGenerated, this.numProposalsRejected, this.numProposalsAccepted, this.numMovesAccepted, this.numSwapsAccepted, this.numPartitionMovesAccepted, this.rejectingGoalCount, this.proposalLeaderboard.finish());
                this.closed = true;
            }
            return this.stats;
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Cannot modify a closed ProposalStatsBuilder");
            }
        }
    }
}

