/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BrokerResourceMetric {
    static final String BROKER_TAG = "broker";
    private final String metricName;
    private final String goalName;
    private final DataBalancerMetricsRegistry metricsRegistry;
    private final Class<?> metricClass;
    private final SortedMap<String, String> baseTags;
    volatile BrokerResourceStats currentResource = null;

    private BrokerResourceMetric(String metricName, String goalName, DataBalancerMetricsRegistry metricsRegistry, SortedMap<String, String> baseTags, Class<?> metricClass) {
        this.baseTags = baseTags;
        this.metricName = metricName;
        this.goalName = goalName;
        this.metricsRegistry = metricsRegistry;
        this.metricClass = metricClass;
    }

    public synchronized void updateResource(BrokerResourceStats resource) {
        boolean shouldRegisterMetric;
        if (resource == null) {
            this.maybeRemoveMetric();
            shouldRegisterMetric = false;
        } else if (this.currentResource != null) {
            if (this.currentResource.brokerId == resource.brokerId) {
                shouldRegisterMetric = false;
            } else {
                this.maybeRemoveMetric();
                shouldRegisterMetric = true;
            }
        } else {
            shouldRegisterMetric = true;
        }
        this.currentResource = resource;
        if (shouldRegisterMetric) {
            this.metricsRegistry.newGauge(this.metricClass, this.metricName, this.metricSupplier(), this.tags(this.currentResource));
        }
    }

    private Supplier<Double> metricSupplier() {
        return () -> this.currentResource.utilizationValue;
    }

    private void maybeRemoveMetric() {
        if (this.currentResource != null) {
            this.metricsRegistry.clearShortLivedMetric(this.metricClass, this.metricName, this.tags(this.currentResource));
        }
    }

    private SortedMap<String, String> tags(BrokerResourceStats resource) {
        TreeMap<String, String> tags = new TreeMap<String, String>(this.baseTags);
        tags.put(BROKER_TAG, Integer.toString(resource.brokerId));
        return tags;
    }

    public static class Builder {
        private final String metricName;
        private final String goalName;
        private final Class<?> metricClass;
        private final DataBalancerMetricsRegistry metricsRegistry;

        public Builder(String metricName, String goalName, DataBalancerMetricsRegistry metricsRegistry, Class<?> metricClass) {
            this.metricName = metricName;
            this.goalName = goalName;
            this.metricsRegistry = metricsRegistry;
            this.metricClass = metricClass;
        }

        public BrokerResourceMetric build(SortedMap<String, String> baseTags) {
            return new BrokerResourceMetric(this.metricName, this.goalName, this.metricsRegistry, baseTags, this.metricClass);
        }
    }
}

