/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.DistributionThresholdUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholds;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;

public final class BalancingThresholdsFactory {
    public static ResourceUtilizationRatioThresholds computeRelativeThresholds(ClusterModel clusterModel, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource, boolean needValidation) {
        double meanUtilizationRatio = DistributionThresholdUtils.clusterUtilizationAverage(clusterModel, resource);
        double balanceUpperThreshold = DistributionThresholdUtils.computeBalanceRelativeUpperThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double balanceLowerThreshold = DistributionThresholdUtils.computeBalanceRelativeLowerThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double lowUtilizationRatio = balancingConstraint.lowUtilizationRatio(resource);
        return ResourceUtilizationRatioThresholds.create(balanceUpperThreshold, balanceLowerThreshold, meanUtilizationRatio, lowUtilizationRatio, resource, needValidation);
    }

    public static ResourceUtilizationRatioThresholds computeAbsoluteThresholds(ClusterModel clusterModel, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource, boolean needValidation) {
        double meanUtilizationRatio = DistributionThresholdUtils.clusterUtilizationAverage(clusterModel, resource);
        double balanceUpperThreshold = DistributionThresholdUtils.computeBalanceAbsoluteUpperThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double balanceLowerThreshold = DistributionThresholdUtils.computeBalanceAbsoluteLowerThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double lowUtilizationRatio = balancingConstraint.lowUtilizationRatio(resource);
        return ResourceUtilizationRatioThresholds.create(balanceUpperThreshold, balanceLowerThreshold, meanUtilizationRatio, lowUtilizationRatio, resource, needValidation);
    }

    public static ResourceUtilizationRatioThresholds computeRelativeThresholdsForCell(Cell cell, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource, boolean needValidation) {
        double meanUtilizationRatio = cell.utilizationRatioBetweenSourceAndDestinationBrokers(resource);
        double balanceUpperThreshold = DistributionThresholdUtils.computeBalanceRelativeUpperThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double balanceLowerThreshold = DistributionThresholdUtils.computeBalanceRelativeLowerThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double lowUtilizationRatio = balancingConstraint.lowUtilizationRatio(resource);
        return ResourceUtilizationRatioThresholds.create(balanceUpperThreshold, balanceLowerThreshold, meanUtilizationRatio, lowUtilizationRatio, resource, needValidation);
    }

    public static ResourceUtilizationRatioThresholds computeAbsoluteThresholdsForCell(Cell cell, OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, Resource resource, boolean needValidation) {
        double meanUtilizationRatio = cell.utilizationRatioBetweenSourceAndDestinationBrokers(resource);
        double balanceUpperThreshold = DistributionThresholdUtils.computeBalanceAbsoluteUpperThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double balanceLowerThreshold = DistributionThresholdUtils.computeBalanceAbsoluteLowerThresholdPercentage(meanUtilizationRatio, optimizationOptions, balancingConstraint, resource);
        double lowUtilizationRatio = balancingConstraint.lowUtilizationRatio(resource);
        return ResourceUtilizationRatioThresholds.create(balanceUpperThreshold, balanceLowerThreshold, meanUtilizationRatio, lowUtilizationRatio, resource, needValidation);
    }
}

