/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds;

import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.DistributionThresholdUtils;
import java.util.Objects;

public final class ReplicaCountThresholds {
    public final int numReplicasUpperLimit;
    public final int numReplicasLowerLimit;

    public ReplicaCountThresholds(int numReplicasUpperLimit, int numReplicasLowerLimit) {
        this.numReplicasUpperLimit = numReplicasUpperLimit;
        this.numReplicasLowerLimit = numReplicasLowerLimit;
    }

    public static ReplicaCountThresholds compute(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double avgReplicasOnBroker, double balancePercentage) {
        return new ReplicaCountThresholds(ReplicaCountThresholds.replicaBalanceUpperLimit(optimizationOptions, balancingConstraint, avgReplicasOnBroker, balancePercentage), ReplicaCountThresholds.replicaBalanceLowerLimit(optimizationOptions, balancingConstraint, avgReplicasOnBroker, balancePercentage));
    }

    private static int replicaBalanceUpperLimit(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double avgReplicasOnBroker, double balancePercentage) {
        double adjustedBalancePct = DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, balancePercentage);
        return (int)Math.ceil(avgReplicasOnBroker * (1.0 + adjustedBalancePct));
    }

    private static int replicaBalanceLowerLimit(OptimizationOptions optimizationOptions, BalancingConstraint balancingConstraint, double avgReplicasOnBroker, double balancePercentage) {
        double adjustedBalancePct = DistributionThresholdUtils.balancePercentage(optimizationOptions, balancingConstraint, balancePercentage);
        return (int)Math.floor(avgReplicasOnBroker * Math.max(0.0, 1.0 - adjustedBalancePct));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaCountThresholds that = (ReplicaCountThresholds)o;
        return this.numReplicasUpperLimit == that.numReplicasUpperLimit && this.numReplicasLowerLimit == that.numReplicasLowerLimit;
    }

    public int hashCode() {
        return Objects.hash(this.numReplicasUpperLimit, this.numReplicasLowerLimit);
    }

    public String toString() {
        return "ReplicaCountThresholds{numReplicasUpperLimit=" + this.numReplicasUpperLimit + ", numReplicasLowerLimit=" + this.numReplicasLowerLimit + "}";
    }
}

