/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.util;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public class HotPartitionsInfo {
    private final Map<Integer, List<TopicPartition>> hotPartitionsByBroker;
    private final Map<TopicPartition, Double> hotPartitionsWithCorrespondingUsages;
    private final int totalNumHotPartitions;
    Map<Replica, Double> saturatedReplicasWithCorrespondingUsages;
    private final double maxReplicaLoad;

    public HotPartitionsInfo(Map<Integer, List<TopicPartition>> hotPartitionsByBroker, Map<TopicPartition, Double> hotPartitionsWithCorrespondingUsages, Map<Replica, Double> saturatedReplicasWithCorrespondingUsages, double maxReplicaLoad) {
        this.hotPartitionsByBroker = hotPartitionsByBroker;
        this.totalNumHotPartitions = this.hotPartitionsByBroker().values().stream().mapToInt(List::size).sum();
        this.hotPartitionsWithCorrespondingUsages = hotPartitionsWithCorrespondingUsages;
        this.saturatedReplicasWithCorrespondingUsages = saturatedReplicasWithCorrespondingUsages;
        this.maxReplicaLoad = maxReplicaLoad;
    }

    public final Map<Integer, List<TopicPartition>> hotPartitionsByBroker() {
        return this.hotPartitionsByBroker;
    }

    public Map<TopicPartition, Double> hotPartitionsWithCorrespondingUsages() {
        return this.hotPartitionsWithCorrespondingUsages;
    }

    public Set<Replica> saturatedReplicas() {
        return this.saturatedReplicasWithCorrespondingUsages.keySet();
    }

    public double maxReplicaLoad() {
        return this.maxReplicaLoad;
    }

    public int totalNumHotPartitions() {
        return this.totalNumHotPartitions;
    }

    public String saturatedReplicasLog(String goalName, Resource resource) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append(goalName + " found ");
        logMsg.append(this.saturatedReplicasWithCorrespondingUsages.size());
        logMsg.append(" saturated replicas for " + (Object)((Object)resource) + " resource: ");
        List saturatedReplicaUsagePretty = this.saturatedReplicasWithCorrespondingUsages.entrySet().stream().map(e -> String.format("%s with utilization %s", ((Replica)e.getKey()).shortString(), e.getValue())).collect(Collectors.toList());
        logMsg.append(saturatedReplicaUsagePretty);
        return logMsg.toString();
    }

    public String hotPartitionsLog(String goalName, Resource resource, double hotPartitionUtilizationThreshold) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append(goalName + " found ");
        logMsg.append(this.hotPartitionsWithCorrespondingUsages.keySet().size());
        logMsg.append(" hot partitions with over ");
        logMsg.append(hotPartitionUtilizationThreshold);
        logMsg.append("% broker " + (Object)((Object)resource) + " resource usage - their resource usage is ");
        logMsg.append(this.hotPartitionsWithCorrespondingUsages);
        logMsg.append(" on brokers ");
        logMsg.append(this.hotPartitionsByBroker);
        return logMsg.toString();
    }

    public Map<Replica, Double> saturatedReplicasWithCorrespondingUsages() {
        return this.saturatedReplicasWithCorrespondingUsages;
    }
}

