/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.ResourceVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

public enum Resource {
    DISK("disk", 3, false, true, 100.0, "MiB"),
    NW_IN("networkInbound", 1, true, false, 10.0, "KiB/s"),
    NW_OUT("networkOutbound", 2, true, false, 10.0, "KiB/s"),
    CPU("cpu", 0, true, true, 0.001, "%"),
    PRODUCE_IN("produceInbound", 4, false, true, 10.0, "KiB/s"),
    CONSUME_OUT("consumeOutbound", 5, false, true, 10.0, "KiB/s"),
    MIRROR_IN("mirrorInbound", 6, false, true, 10.0, "KiB/s");

    private static final double EPSILON_PERCENT = 8.0E-4;
    private final String resource;
    private final int id;
    private final boolean isHostResource;
    private final boolean isBrokerResource;
    private final double epsilon;
    private String unit;
    private static final List<Resource> CACHED_VALUES;
    public static final Set<Resource> LEADER_INFLUENCED_RESOURCES;

    public static List<Resource> cachedValues() {
        return CACHED_VALUES;
    }

    private Resource(String resource, int id, boolean isHostResource, boolean isBrokerResource, double epsilon, String unit) {
        this.resource = resource;
        this.id = id;
        this.isHostResource = isHostResource;
        this.isBrokerResource = isBrokerResource;
        this.epsilon = epsilon;
        this.unit = unit;
    }

    public String resource() {
        return this.resource;
    }

    public int id() {
        return this.id;
    }

    public String unit() {
        return this.unit;
    }

    public boolean isHostResource() {
        return this.isHostResource;
    }

    public boolean isBrokerResource() {
        return this.isBrokerResource;
    }

    public double epsilon(double value1, double value2) {
        return Math.max(this.epsilon, 8.0E-4 * (value1 + value2));
    }

    public <T> T visit(ResourceVisitor<T> visitor) {
        switch (this) {
            case CPU: {
                return visitor.visitCpuResource();
            }
            case NW_IN: {
                return visitor.visitNetworkInResource();
            }
            case NW_OUT: {
                return visitor.visitNetworkOutResource();
            }
            case DISK: {
                return visitor.visitDiskResource();
            }
            case PRODUCE_IN: {
                return visitor.visitProduceInResource();
            }
            case CONSUME_OUT: {
                return visitor.visitConsumeOutResource();
            }
            case MIRROR_IN: {
                return visitor.visitMirrorInResource();
            }
        }
        throw new IllegalStateException("Enum type " + (Object)((Object)this) + " not recognized.");
    }

    public String toString() {
        return this.resource;
    }

    static {
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(Resource.values()));
        LEADER_INFLUENCED_RESOURCES = Collections.unmodifiableSet(new HashSet<Resource>(Arrays.asList(CPU, PRODUCE_IN, CONSUME_OUT, NW_OUT, MIRROR_IN)));
    }

    @Immutable
    public static class CompositeResource {
        public final Resource capacityResource;
        public final List<Resource> utilizationResources;

        private CompositeResource(Resource capacityResource, List<Resource> utilizationResources) {
            this.validateResources(capacityResource, utilizationResources);
            this.capacityResource = capacityResource;
            this.utilizationResources = utilizationResources;
        }

        public static CompositeResource ofResource(Resource resource) {
            return new CompositeResource(resource, Collections.singletonList(resource));
        }

        public static CompositeResource ofResources(Resource capacityResource, Resource otherUtilizationResource) {
            if (capacityResource == otherUtilizationResource) {
                throw new IllegalArgumentException("The other utilization resource should be different than the capacity. The capacity one is already included in the utilization resources.");
            }
            return new CompositeResource(capacityResource, Arrays.asList(capacityResource, otherUtilizationResource));
        }

        public boolean isBrokerResource() {
            return this.capacityResource.isBrokerResource;
        }

        private void validateResources(Resource capacityResource, List<Resource> utilizationResources) {
            boolean isDisjoint;
            if (utilizationResources.size() == 1 && utilizationResources.get(0) == capacityResource) {
                return;
            }
            boolean bl = isDisjoint = !utilizationResources.contains((Object)capacityResource);
            if (isDisjoint) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with disjoint capacity (%s) and utilization resources (%s).", new Object[]{capacityResource, utilizationResources}));
            }
            HashSet<Boolean> isLeaderInfluenced = new HashSet<Boolean>(Collections.singletonList(LEADER_INFLUENCED_RESOURCES.contains((Object)capacityResource)));
            HashSet<Boolean> hostResources = new HashSet<Boolean>(Collections.singletonList(capacityResource.isHostResource()));
            HashSet<Boolean> brokerResources = new HashSet<Boolean>(Collections.singletonList(capacityResource.isBrokerResource));
            HashSet<String> resourceUnits = new HashSet<String>(Collections.singletonList(capacityResource.unit()));
            for (Resource utilR : utilizationResources) {
                hostResources.add(utilR.isHostResource());
                resourceUnits.add(utilR.unit());
                brokerResources.add(utilR.isBrokerResource());
                isLeaderInfluenced.add(LEADER_INFLUENCED_RESOURCES.contains((Object)utilR));
            }
            if (hostResources.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with host and broker resources: %s", utilizationResources));
            }
            if (brokerResources.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with host and broker resources: %s", utilizationResources));
            }
            if (resourceUnits.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with different units: %s", utilizationResources));
            }
            if (isLeaderInfluenced.size() > 1) {
                throw new IllegalArgumentException(String.format("Cannot configure a composite resource with different leader influence: %s", utilizationResources));
            }
        }
    }
}

