/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.record.CellOverloadOccurrenceDelta;

public class CellOverloadOccurrenceRecorder {
    private final ApiStatePersistenceStore apiStatePersistenceStore;
    private static final int VERSION = 1;

    public CellOverloadOccurrenceRecorder(ApiStatePersistenceStore apiStatePersistenceStore) {
        this.apiStatePersistenceStore = apiStatePersistenceStore;
    }

    public void addOccurrence(int cellId) throws InterruptedException {
        CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta = CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).setOp(CellOverloadOccurrenceDelta.Operation.record_once).setCellId(cellId).build();
        this.apiStatePersistenceStore.save(cellOverloadOccurrenceDelta);
    }

    public void deleteOccurrence(int cellId) throws InterruptedException {
        CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta = CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).setOp(CellOverloadOccurrenceDelta.Operation.delete_once).setCellId(cellId).build();
        this.apiStatePersistenceStore.save(cellOverloadOccurrenceDelta);
    }

    public void clearOccurrence(int cellId) throws InterruptedException {
        CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta = CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto.newBuilder().setVersion(1).setTimestamp(System.currentTimeMillis()).setOp(CellOverloadOccurrenceDelta.Operation.clear).setCellId(cellId).build();
        this.apiStatePersistenceStore.save(cellOverloadOccurrenceDelta);
    }
}

