/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BrokerExecutionTaskTracker {
    private final Map<Integer, Integer> inProgressMovements;
    private final int maxInProgressMovements;

    public BrokerExecutionTaskTracker(int maxInProgressMovements) {
        this.inProgressMovements = new HashMap<Integer, Integer>();
        this.maxInProgressMovements = maxInProgressMovements;
    }

    private BrokerExecutionTaskTracker(BrokerExecutionTaskTracker that) {
        this.inProgressMovements = new HashMap<Integer, Integer>(that.inProgressMovements);
        this.maxInProgressMovements = that.maxInProgressMovements;
    }

    public static BrokerExecutionTaskTracker duplicate(BrokerExecutionTaskTracker that) {
        return new BrokerExecutionTaskTracker(that);
    }

    public void maybeAddBroker(int brokerId) {
        this.inProgressMovements.putIfAbsent(brokerId, 0);
    }

    public Set<Integer> knownBrokers() {
        return Collections.unmodifiableSet(this.inProgressMovements.keySet());
    }

    public void addTaskForBroker(int brokerId, int numMovements) throws IllegalArgumentException {
        if (!this.inProgressMovements.containsKey(brokerId)) {
            throw new IllegalArgumentException(String.format("Unknown broker ID %d", brokerId));
        }
        if (numMovements <= 0) {
            throw new IllegalArgumentException(String.format("Number of replica movements to track must be positive (%d requested)", numMovements));
        }
        if (!this.brokerHasCapacity(brokerId, numMovements = this.adjustMovementCount(numMovements))) {
            throw new IllegalArgumentException(String.format("Broker %d doesn't have space for %d movements (currently at %d)", brokerId, numMovements, this.brokerTaskCount(brokerId)));
        }
        this.inProgressMovements.put(brokerId, this.brokerTaskCount(brokerId) + numMovements);
    }

    public void removeTaskForBroker(int brokerId, int numMovements) throws IllegalArgumentException {
        if (numMovements <= 0) {
            throw new IllegalArgumentException(String.format("Number of replica movements to remove must be positive (%d requested)", numMovements));
        }
        if (this.brokerHasCapacity(brokerId, -(numMovements = this.adjustMovementCount(numMovements)))) {
            this.inProgressMovements.put(brokerId, this.brokerTaskCount(brokerId) - numMovements);
        }
    }

    public int brokerTaskCount(int brokerId) {
        return this.inProgressMovements.get(brokerId);
    }

    public boolean wouldOverloadBroker(int brokerId, int numMovements) throws IllegalArgumentException {
        return !this.brokerHasCapacity(brokerId, numMovements = this.adjustMovementCount(numMovements));
    }

    public void clear() {
        this.inProgressMovements.clear();
    }

    Map<Integer, Integer> readonlyView() {
        return Collections.unmodifiableMap(this.inProgressMovements);
    }

    public String toString() {
        return "BrokerExecutionTaskTracker{maxInProgressMovements=" + this.maxInProgressMovements + ", inProgressMovements=" + this.inProgressMovements + '}';
    }

    private boolean brokerHasCapacity(int brokerId, int numMovements) {
        int movementsAfter = this.brokerTaskCount(brokerId) + numMovements;
        if (movementsAfter < 0) {
            throw new IllegalArgumentException(String.format("Request of %d  brings broker %d active executions (currently %d) below 0", numMovements, brokerId, this.brokerTaskCount(brokerId)));
        }
        return movementsAfter <= this.maxInProgressMovements;
    }

    private int adjustMovementCount(int providedMovements) {
        if (providedMovements < 0) {
            throw new IllegalArgumentException("Can't have a negative movement count!");
        }
        return Math.min(providedMovements, this.maxInProgressMovements);
    }
}

