/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.executor.AbstractExecutorReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskManager;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskTracker;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.executor.ReplicationThrottleHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ElectionNotNeededException;

@NotThreadSafe
public class ExecutorLeadershipReplicaMovement
extends AbstractExecutorReplicaMovement {
    public ExecutorLeadershipReplicaMovement(String executionUuid, ExecutionTaskManager executionTaskManager, Set<Integer> recentlyRemovedBrokers, ReplicationThrottleHelper throttleHelper, ConfluentAdmin adminClient, SbkAdminUtils adminUtils, AtomicBoolean stopRequested) {
        super(executionUuid, executionTaskManager, recentlyRemovedBrokers, throttleHelper, adminClient, adminUtils, stopRequested);
    }

    @Override
    public void move(Executor.ExecutionTaskWaiter taskWaiter) throws InterruptedException {
        int numTotalLeadershipMovements = this.executionTaskManager.numPendingLeadershipMovements();
        LOG.info("Starting {} leadership movements.", (Object)numTotalLeadershipMovements);
        int numFinishedLeadershipMovements = 0;
        while (this.executionTaskManager.numPendingLeadershipMovements() != 0 && !this.stopRequested.get()) {
            LOG.info("{}/{} ({}%) leadership movements completed.", new Object[]{numFinishedLeadershipMovements += this.moveLeadershipInBatch(taskWaiter), numTotalLeadershipMovements, numFinishedLeadershipMovements * 100 / numTotalLeadershipMovements});
        }
        if (this.executionTaskManager.inExecutionTasks().isEmpty()) {
            LOG.info("Leadership movements finished.");
        } else if (this.stopRequested.get()) {
            ExecutionTaskTracker.ExecutionTasksSummary summary = this.executionTaskManager.getExecutionTasksSummary(Collections.emptySet());
            LOG.info("Leadership movements stopped. {}.", (Object)summary.summarize(ExecutionTask.TaskType.LEADER_ACTION));
        }
    }

    private int moveLeadershipInBatch(Executor.ExecutionTaskWaiter taskWaiter) {
        List<ExecutionTask> leadershipMovementTasks = this.executionTaskManager.getLeadershipMovementTasks();
        int numLeadershipToMove = leadershipMovementTasks.size();
        LOG.debug("Executing {} leadership movements in a batch: {}", (Object)numLeadershipToMove, leadershipMovementTasks);
        if (!leadershipMovementTasks.isEmpty() && !this.stopRequested.get()) {
            this.executionTaskManager.markTasksInProgress(leadershipMovementTasks);
            try {
                this.executePreferredLeaderElection(leadershipMovementTasks);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Leadership tasks failed to execute, aborting: {}", leadershipMovementTasks, (Object)e);
                this.executionTaskManager.markTasksAborting(leadershipMovementTasks);
            }
            LOG.trace("Waiting for leadership movement batch to finish.");
            while (!this.executionTaskManager.inExecutionTasks().isEmpty() && !this.stopRequested.get()) {
                taskWaiter.waitForAnyTaskToFinish(this);
            }
        }
        return numLeadershipToMove;
    }

    private void executePreferredLeaderElection(List<ExecutionTask> tasks) throws ExecutionException, InterruptedException {
        Set partitionsToExecute = tasks.stream().map(task -> new TopicPartition(task.partitionProposal().topic(), task.partitionProposal().partitionId())).collect(Collectors.toSet());
        Map electionResults = (Map)this.adminClient.electLeaders(ElectionType.PREFERRED, partitionsToExecute).partitions().get();
        Optional<Throwable> exc = electionResults.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent() && !(((Optional)e.getValue()).get() instanceof ElectionNotNeededException)).map(e -> (Throwable)((Optional)e.getValue()).get()).findFirst();
        if (exc.isPresent()) {
            throw new ExecutionException(exc.get());
        }
    }

    @Override
    ExecutionTask.TaskType taskType() {
        return ExecutionTask.TaskType.LEADER_ACTION;
    }

    @Override
    ExecutorState.State state() {
        return ExecutorState.State.LEADER_MOVEMENT_TASK_IN_PROGRESS;
    }

    @Override
    ExecutorState executorState() {
        return ExecutorState.operationInProgress(ExecutorState.State.LEADER_MOVEMENT_TASK_IN_PROGRESS, this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.LEADER_ACTION)), this.executionTaskManager.interBrokerPartitionMovementConcurrency(), this.executionTaskManager.leadershipMovementConcurrency(), this.uuid, this.recentlyRemovedBrokers);
    }
}

