/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import java.util.Collection;
import java.util.EnumSet;

public class OverloadedCell {
    private final Cell cell;
    private final Collection<Resource> overloadedResources;
    private final boolean isReplicaCountOverloaded;

    private OverloadedCell(Builder builder) {
        this.cell = builder.cell;
        this.overloadedResources = builder.overloadedResources;
        this.isReplicaCountOverloaded = builder.isReplicaCountOverloaded;
    }

    public static Builder builder(Cell cell) {
        return new Builder(cell);
    }

    public boolean isOverloaded() {
        return !this.overloadedResources.isEmpty() || this.isReplicaCountOverloaded;
    }

    public Cell cell() {
        return this.cell;
    }

    public Collection<Resource> overloadedResources() {
        return this.overloadedResources;
    }

    public boolean isReplicaCountOverloaded() {
        return this.isReplicaCountOverloaded;
    }

    public static class Builder {
        private final Cell cell;
        private final Collection<Resource> overloadedResources;
        private boolean isReplicaCountOverloaded;

        public Builder(Cell cell) {
            this.cell = cell;
            this.overloadedResources = EnumSet.noneOf(Resource.class);
            this.isReplicaCountOverloaded = false;
        }

        public Builder addOverloadedResource(Resource resource) {
            this.overloadedResources.add(resource);
            return this;
        }

        public Builder setOverloadedReplicaCount() {
            this.isReplicaCountOverloaded = true;
            return this;
        }

        public OverloadedCell build() {
            return new OverloadedCell(this);
        }
    }
}

