/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.CompositeEntityUtilization;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.SingleEntityUtilization;
import java.util.List;
import java.util.Optional;

public interface Utilization {
    public static Utilization from(Load load) {
        return new CompositeEntityUtilization(load);
    }

    public static Utilization from(Load load, Broker.Strategy strategy) {
        return new SingleEntityUtilization(load, strategy);
    }

    public Load totalUtilization();

    public Optional<Load> ignoredSourceUtilization();

    public Optional<Load> eligibleSourceUtilization();

    public Optional<Load> ignoredDestinationUtilization();

    public Optional<Load> eligibleDestinationUtilization();

    public void addLoad(Broker.Strategy var1, Load var2);

    public void addLoad(Broker.Strategy var1, AggregatedMetricValues var2);

    public void subtractLoad(Broker.Strategy var1, Load var2);

    public void subtractLoad(Broker.Strategy var1, AggregatedMetricValues var2);

    public void addMetricValues(Broker.Strategy var1, AggregatedMetricValues var2, List<Long> var3);
}

