/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;

class ValueAndCount
implements ValueHolder {
    static final double NO_RECORD_EXISTS = -1.0;
    private double value = 0.0;
    private int count = 0;

    ValueAndCount() {
    }

    @Override
    public void recordValue(double value, long time) {
        this.value += value;
        ++this.count;
    }

    @Override
    public void reset() {
        this.value = 0.0;
        this.count = 0;
    }

    @Override
    public double value() {
        return this.count == 0 ? 0.0 : this.value / (double)this.count;
    }

    @Override
    public double value(boolean assertNonZeroCount) {
        return this.count == 0 ? (assertNonZeroCount ? -1.0 : 0.0) : this.value / (double)this.count;
    }
}

