/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityCombinator;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import kafka.common.TenantHelpers;
import org.apache.kafka.common.PartitionPlacementStrategy;

public class CellAwareGoal
extends AbstractGoal {
    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        if (clusterModel.skipCellBalancing() || CellAwareGoal.isTenantClusterWide(clusterModel, action.topic()) && CellAwareGoal.isTenantClusterWide(clusterModel, action.destinationTopic())) {
            return ActionAcceptance.ACCEPT;
        }
        Cell destinationCell = clusterModel.broker(action.destinationBrokerId()).cell();
        Cell sourceCell = clusterModel.broker(action.sourceBrokerId()).cell();
        List<Replica> replicasOfPartition = clusterModel.partition(action.topicPartition()).replicas();
        return replicasOfPartition.size() == 1 || sourceCell.equals(destinationCell) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        if (clusterModel.skipCellBalancing() || CellAwareGoal.isTenantClusterWide(clusterModel, action.topicPartition().topic())) {
            return ActionAcceptance.ACCEPT;
        }
        Set destinationCells = action.replicaMoves().values().stream().map(Broker::cell).collect(Collectors.toSet());
        if (destinationCells.size() != 1) {
            return ActionAcceptance.REPLICA_REJECT;
        }
        List<Replica> partitionReplicas = clusterModel.partition(action.topicPartition()).replicas();
        Cell originalCell = partitionReplicas.get(0).broker().cell();
        Cell destinationCell = (Cell)destinationCells.iterator().next();
        if (GoalUtils.nonTenantTopic(action.topicPartition().topic()) && !originalCell.equals(destinationCell) && destinationCell.isQuarantined()) {
            return ActionAcceptance.REPLICA_REJECT;
        }
        if (action.replicaMoves().size() == partitionReplicas.size()) {
            return ActionAcceptance.ACCEPT;
        }
        return originalCell.equals(destinationCell) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true, false);
    }

    @Override
    public String name() {
        return CellAwareGoal.class.getSimpleName();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean canChangeReplicationFactor() {
        return false;
    }

    @Override
    public boolean isHardGoal() {
        return true;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.allBrokers();
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        return true;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return true;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        if (clusterModel.skipCellBalancing()) {
            return;
        }
        int maxCellSize = clusterModel.cellsById().values().stream().mapToInt(cell -> cell.brokers().size()).max().orElseThrow(() -> new IllegalStateException("CellAwareGoal cannot find maxCellSize since ClusterModel doesn't have cell information"));
        for (Map.Entry<String, List<Partition>> partitionsByTopic : clusterModel.getPartitionsByTopic().entrySet()) {
            List<Partition> topicPartitions;
            if (optimizationOptions.excludedTopics().contains(partitionsByTopic.getKey()) || (topicPartitions = partitionsByTopic.getValue()).isEmpty() || topicPartitions.get(0).partitionBrokers().size() <= maxCellSize) continue;
            throw new OptimizationFailureException(String.format("Partition %d of topic %s has %d replicas, which is greater than the max cell size of %d brokers", topicPartitions.get(0).topicPartition().partition(), topicPartitions.get(0).topicPartition().topic(), topicPartitions.get(0).partitionBrokers().size(), maxCellSize));
        }
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        CellAwareGoal.cellBoundariesAreMet(clusterModel, excludedTopics);
        this.finish();
    }

    @Override
    protected void rebalanceForBroker(Broker sourceBroker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        if (clusterModel.skipCellBalancing()) {
            return;
        }
        if (sourceBroker.cell().isQuarantined()) {
            this.drainBrokerInQuarantineCell(clusterModel, sourceBroker, optimizedGoals, optimizationOptions);
        }
        HashSet<Replica> replicas = new HashSet<Replica>(sourceBroker.replicas());
        for (Replica replica : replicas) {
            if (CellAwareGoal.shouldExclude(replica, optimizationOptions.excludedTopics()) || CellAwareGoal.isTenantClusterWide(clusterModel, replica)) continue;
            Partition partition = clusterModel.partition(replica.topicPartition());
            Cell leaderCell = partition.leader().broker().cell();
            if (replica.broker().cell().equals(leaderCell)) continue;
            this.movePartitionToCell(sourceBroker, clusterModel, optimizedGoals, replica, leaderCell);
        }
    }

    private void movePartitionToCell(Broker sourceBroker, ClusterModel clusterModel, Set<Goal> optimizedGoals, Replica replica, Cell destinationCell) throws OptimizationFailureException {
        Partition partition = clusterModel.partition(replica.topicPartition());
        List<Replica> replicasToRelocate = partition.replicas().stream().filter(replica1 -> !replica1.broker().cell().equals(destinationCell)).collect(Collectors.toList());
        if (replicasToRelocate.stream().anyMatch(r -> !r.broker().isEligibleSource())) {
            throw new OptimizationFailureException(String.format("Can't move replica of partition %s as there are replica on excluded brokers.", partition));
        }
        HashSet<Broker> partitionBrokers = new HashSet<Broker>(partition.partitionBrokers());
        List validBrokers = destinationCell.brokers().stream().filter(broker -> !partitionBrokers.contains(broker)).filter(Broker::isEligibleDestination).collect(Collectors.toList());
        if (validBrokers.size() < replicasToRelocate.size()) {
            throw new OptimizationFailureException(String.format("[%s] Can't meet cell-awareness requirement for broker with id %d. The partition %s has %d replicas but the leader cell (%s) has only %d brokers (%s) which are eligible destinations for this partition (out of total %d brokers (%s) in the cell).", this.name(), sourceBroker.id(), partition, partitionBrokers.size(), destinationCell.id(), validBrokers.size(), validBrokers.stream().map(Broker::id).collect(Collectors.toSet()), destinationCell.brokers().size(), destinationCell.brokers().stream().map(Broker::id).collect(Collectors.toSet())));
        }
        Iterable<List<Broker>> candidateBrokersIterable = EntityCombinator.singleEntityListIterable(validBrokers, replicasToRelocate.size());
        Map<Replica, Broker> replicaMoves = GoalUtils.getPartitionMoves(clusterModel, optimizedGoals, replicasToRelocate, candidateBrokersIterable);
        if (replicaMoves.isEmpty()) {
            throw new OptimizationFailureException(String.format("[%s] Violated cell-awareness requirement for broker with id %d. replica: %s", this.name(), sourceBroker.id(), replica));
        }
        replicaMoves.forEach((replicaToMove, broker) -> this.relocateReplica(clusterModel, replicaToMove.topicPartition(), replicaToMove.broker().id(), broker.id()));
    }

    private void drainBrokerInQuarantineCell(ClusterModel clusterModel, Broker broker, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        List nonTenantTopics = broker.topics().stream().filter(GoalUtils::nonTenantTopic).collect(Collectors.toList());
        List destinationCells = clusterModel.cells().stream().filter(cell -> !cell.equals(broker.cell())).filter(cell -> !cell.isQuarantined()).filter(Cell::isEligibleDestination).collect(Collectors.toList());
        for (String topic : nonTenantTopics) {
            HashSet<Replica> replicas = new HashSet<Replica>(broker.replicasOfTopicInBroker(topic));
            for (Replica replica : replicas) {
                if (CellAwareGoal.shouldExclude(replica, optimizationOptions.excludedTopics())) continue;
                Collections.shuffle(destinationCells);
                Partition partition = clusterModel.partition(replica.topicPartition());
                Cell leaderCell = partition.leader().broker().cell();
                if (!replica.broker().cell().equals(leaderCell) && destinationCells.remove(leaderCell)) {
                    destinationCells.add(0, leaderCell);
                }
                boolean success = false;
                for (Cell cell2 : destinationCells) {
                    try {
                        this.movePartitionToCell(broker, clusterModel, optimizedGoals, replica, cell2);
                        success = true;
                        break;
                    }
                    catch (OptimizationFailureException optimizationFailureException) {
                    }
                }
                if (success) continue;
                throw new OptimizationFailureException(String.format("Unable to find a destination cell for replica: %s", replica));
            }
        }
    }

    public static void cellBoundariesAreMet(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (clusterModel.skipCellBalancing()) {
            return;
        }
        for (Map.Entry<String, List<Partition>> partitionsByTopic : clusterModel.getPartitionsByTopic().entrySet()) {
            String topic = partitionsByTopic.getKey();
            if (excludedTopics.contains(topic) || CellAwareGoal.isTenantClusterWide(clusterModel, topic)) continue;
            for (Partition partition : partitionsByTopic.getValue()) {
                Set cells = partition.partitionBrokers().stream().map(Broker::cell).collect(Collectors.toSet());
                if (cells.size() > 1) {
                    throw new OptimizationFailureException(String.format("Partition %d of topic %s has replicas in more than one cells: %s", partition.topicPartition().partition(), partition.topicPartition().topic(), cells));
                }
                Cell partitionCell = partition.leader().broker().cell();
                if (!GoalUtils.nonTenantTopic(topic) || !partitionCell.isQuarantined()) continue;
                throw new OptimizationFailureException(String.format("Partition %d of topic %s has replicas in quarantined cell: %s", partition.topicPartition().partition(), partition.topicPartition().topic(), partitionCell));
            }
        }
    }

    private static boolean isTenantClusterWide(ClusterModel clusterModel, Replica replica) {
        return CellAwareGoal.isTenantClusterWide(clusterModel, replica.topicPartition().topic());
    }

    private static boolean isTenantClusterWide(ClusterModel clusterModel, String topic) {
        boolean ret = false;
        String tenantId = TenantHelpers.extractTenantPrefix((String)topic, (boolean)false);
        if (tenantId != null) {
            Optional<Tenant> tenant = clusterModel.tenant(tenantId);
            ret = tenant.map(t -> t.placementPolicy().equals((Object)PartitionPlacementStrategy.CLUSTER_WIDE)).orElse(false);
        }
        return ret;
    }
}

