/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.EntityCombinator;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaPlacementGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaPlacementGoal.class);
    private static final String SYNC_REPLICA_NAME = "sync-replica";
    private static final String OBSERVER_NAME = "observer";

    public ReplicaPlacementGoal() {
    }

    ReplicaPlacementGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
        Broker destBroker = clusterModel.broker(action.destinationBrokerId());
        Replica sourceReplica = sourceBroker.replica(action.topicPartition());
        Replica destReplica = destBroker.replica(action.destinationTopicPartition());
        switch (action.balancingAction()) {
            case LEADERSHIP_MOVEMENT: {
                return destReplica.isObserver() ? ActionAcceptance.REPLICA_REJECT : ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case INTER_BROKER_REPLICA_SWAP: {
                if (this.isInvalidReplicaMovement(clusterModel, sourceBroker, destBroker, sourceReplica)) {
                    return ActionAcceptance.BROKER_REJECT;
                }
                if (action.balancingAction() == ActionType.INTER_BROKER_REPLICA_SWAP && this.isInvalidReplicaMovement(clusterModel, destBroker, sourceBroker, destReplica)) {
                    return ActionAcceptance.REPLICA_REJECT;
                }
                return ActionAcceptance.ACCEPT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    private boolean ensureConstraintsMatchReplicaMoves(Map<Replica, Broker> replicaMoves, List<TopicPlacement.ConstraintCount> constraints, Boolean areObserverConstraints, List<Replica> fixedReplicas) {
        for (TopicPlacement.ConstraintCount constraint : constraints) {
            long numMovedReplicasMatch;
            long numFixedReplicasMatch = fixedReplicas.stream().filter(replica -> constraint.matches(replica.broker().attributes()) && replica.isObserver() == areObserverConstraints.booleanValue() && (areObserverConstraints == false || !replica.isLeader())).count();
            if (numFixedReplicasMatch + (numMovedReplicasMatch = replicaMoves.entrySet().stream().filter(entry -> constraint.matches(((Broker)entry.getValue()).attributes()) && ((Replica)entry.getKey()).isObserver() == areObserverConstraints.booleanValue() && (areObserverConstraints == false || !((Replica)entry.getKey()).isLeader())).count()) == (long)constraint.count()) continue;
            LOG.debug("Proposed partition move doesn't match placement constraint. Constraint: {}, Replica Moves: {}, Fixed Replicas: {}", new Object[]{constraint, replicaMoves.size(), fixedReplicas.size()});
            return false;
        }
        return true;
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        Optional<TopicPlacement> topicPlacementOpt = clusterModel.getTopicPlacement(action.topicPartition().topic());
        if (!topicPlacementOpt.isPresent()) {
            return ActionAcceptance.ACCEPT;
        }
        TopicPlacement topicPlacement = topicPlacementOpt.get();
        ArrayList<Replica> fixedReplicas = new ArrayList<Replica>(clusterModel.partition(action.topicPartition()).replicas());
        fixedReplicas.removeAll(action.replicaMoves().keySet());
        return this.ensureConstraintsMatchReplicaMoves(action.replicaMoves(), topicPlacement.replicas(), false, fixedReplicas) && this.ensureConstraintsMatchReplicaMoves(action.replicaMoves(), topicPlacement.observers(), true, fixedReplicas) ? ActionAcceptance.ACCEPT : ActionAcceptance.BROKER_REJECT;
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(1, 0.0, true, true);
    }

    @Override
    public String name() {
        return ReplicaPlacementGoal.class.getSimpleName();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean canChangeReplicationFactor() {
        return true;
    }

    @Override
    public boolean isHardGoal() {
        return true;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        return clusterModel.allBrokersWithStateOtherThan(Broker.Strategy.IGNORE);
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        return true;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return true;
    }

    @Override
    public void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        SortedMap<String, List<Partition>> partitionsByTopic = this.topicsForWhichToSatisfyTopicPlacementConstraint(clusterModel, optimizationOptions);
        HashMap<Short, Set<String>> topicsByReplicationFactor = new HashMap<Short, Set<String>>();
        for (Map.Entry<String, List<Partition>> topicEntry : partitionsByTopic.entrySet()) {
            String topic = topicEntry.getKey();
            Map numReplicasRequiredByAttributeGroup = clusterModel.getTopicPlacement(topic).map(this::numReplicasRequiredByAttributeGroup).orElseGet(Collections::emptyMap);
            this.updateTopicsByReplicationFactorMap(topicsByReplicationFactor, numReplicasRequiredByAttributeGroup, topic);
            for (Partition partition : topicEntry.getValue()) {
                int ignoredPartitionReplicasThatSatisfyARequiredGroup = 0;
                for (Map.Entry replicasRequiredByAttributeGroupEntry : numReplicasRequiredByAttributeGroup.entrySet()) {
                    Map attributeGroup = (Map)replicasRequiredByAttributeGroupEntry.getKey();
                    int numRequiredReplicas = (Integer)replicasRequiredByAttributeGroupEntry.getValue();
                    int numIgnoredReplicasMatchingAttributes = this.checkIgnoredBrokersMatchingAttributesUnderNumRequired(clusterModel, partition, attributeGroup, numRequiredReplicas);
                    ignoredPartitionReplicasThatSatisfyARequiredGroup += numIgnoredReplicasMatchingAttributes;
                    this.checkEnoughBrokersToMeetConstraintForPartition(numRequiredReplicas, numIgnoredReplicasMatchingAttributes, clusterModel, attributeGroup, partition);
                }
                this.checkAllIgnoredBrokersSatisfyARequiredGroup(partition, ignoredPartitionReplicasThatSatisfyARequiredGroup);
            }
        }
        this.updateReplicationFactor(clusterModel, topicsByReplicationFactor, this.brokersToExcludeFromReplicaCreationAndDeletion(optimizationOptions, clusterModel));
    }

    private SortedMap<String, List<Partition>> topicsForWhichToSatisfyTopicPlacementConstraint(ClusterModel clusterModel, OptimizationOptions opt) {
        SortedMap<String, List<Partition>> partitionsByTopic = clusterModel.getPartitionsByTopic();
        Set<String> excludedTopics = opt.excludedTopics();
        partitionsByTopic.keySet().removeAll(excludedTopics);
        partitionsByTopic.keySet().removeIf(topic -> !clusterModel.getTopicPlacement((String)topic).isPresent());
        return partitionsByTopic;
    }

    private void updateTopicsByReplicationFactorMap(Map<Short, Set<String>> topicsByReplicationFactor, Map<Map<String, String>, Integer> numReplicasRequiredByAttributeGroup, String topic) {
        int requiredReplicasPerPartition = numReplicasRequiredByAttributeGroup.values().stream().mapToInt(Integer::intValue).sum();
        topicsByReplicationFactor.computeIfAbsent((short)requiredReplicasPerPartition, rf -> new HashSet()).add(topic);
    }

    private void checkAllIgnoredBrokersSatisfyARequiredGroup(Partition partition, int ignoredPartitionReplicasThatSatisfyARequiredGroup) throws OptimizationFailureException {
        int ignoredPartitionReplicas = (int)partition.partitionBrokers().stream().filter(b -> b.strategy().equals((Object)Broker.Strategy.IGNORE)).count();
        if (ignoredPartitionReplicas != ignoredPartitionReplicasThatSatisfyARequiredGroup) {
            throw new OptimizationFailureException(String.format("There are %d replicas of partition %s in ignored brokers that belong to no required attribute group", ignoredPartitionReplicas - ignoredPartitionReplicasThatSatisfyARequiredGroup, partition.topicPartition()));
        }
    }

    private void checkEnoughBrokersToMeetConstraintForPartition(int numRequiredReplicas, int numIgnoredReplicasMatchingAttributes, ClusterModel clusterModel, Map<String, String> attributeGroup, Partition partition) throws OptimizationFailureException {
        int numNonIgnoredAndNonDeadReplicasRequired = numRequiredReplicas - numIgnoredReplicasMatchingAttributes;
        EnumSet<Broker.Strategy> unacceptableStates = EnumSet.of(Broker.Strategy.DEAD, Broker.Strategy.IGNORE);
        int numNonIgnoredAndNonDeadBrokersMatchingAttributes = clusterModel.brokersNotOfStatesMatchingAttributes(clusterModel.allBrokers(), unacceptableStates, attributeGroup).size();
        if (numNonIgnoredAndNonDeadReplicasRequired > numNonIgnoredAndNonDeadBrokersMatchingAttributes) {
            throw new OptimizationFailureException(String.format("Topic partition %s requires %d alive non-ignored brokers with attributes %s but only %d are available.", partition.topicPartition(), numNonIgnoredAndNonDeadReplicasRequired, attributeGroup.toString(), numNonIgnoredAndNonDeadBrokersMatchingAttributes));
        }
    }

    private int checkIgnoredBrokersMatchingAttributesUnderNumRequired(ClusterModel clusterModel, Partition partition, Map<String, String> attributeGroup, int numRequiredReplicas) throws OptimizationFailureException {
        int numIgnoredReplicasMatchingAttributes = clusterModel.brokersOfStatesMatchingAttributes(partition.partitionBrokers(), EnumSet.of(Broker.Strategy.IGNORE), attributeGroup).size();
        if (numIgnoredReplicasMatchingAttributes > numRequiredReplicas) {
            throw new OptimizationFailureException(String.format("There are %d replicas of partition %s in ignored brokers with attributes %s but only %d are required", numIgnoredReplicasMatchingAttributes, partition.topicPartition(), attributeGroup.toString(), numRequiredReplicas));
        }
        return numIgnoredReplicasMatchingAttributes;
    }

    private Set<Integer> brokersToExcludeFromReplicaCreationAndDeletion(OptimizationOptions optimizationOptions, ClusterModel clusterModel) {
        HashSet<Integer> result = new HashSet<Integer>(optimizationOptions.excludedBrokersForReplicaMove());
        clusterModel.ignoredBrokers().forEach(broker -> result.add(broker.id()));
        return result;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        SortedMap<String, List<Partition>> topicsToBalance = clusterModel.getPartitionsByTopic();
        topicsToBalance.keySet().removeAll(excludedTopics);
        topicsToBalance.keySet().removeIf(topic -> !clusterModel.getTopicPlacement((String)topic).isPresent());
        this.validateTopicPlacements(clusterModel, topicsToBalance);
        GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        LOG.debug("balancing broker {}, optimized goals = {}", (Object)broker, optimizedGoals);
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        TreeSet<Replica> replicas = new TreeSet<Replica>(broker.replicas());
        for (Replica replica : replicas) {
            if (ReplicaPlacementGoal.shouldExclude(replica, excludedTopics)) continue;
            boolean moveOfflineReplica = !broker.isAlive() || broker.currentOfflineReplicas().contains(replica);
            boolean movedPartition = false;
            if (moveOfflineReplica || this.shouldMoveReplica(replica, clusterModel)) {
                List<Broker> eligibleBrokers = this.replicaMovementEligibleBrokers(replica, clusterModel);
                LOG.debug("Trying to satisfy constraint for replica {} by moving to potential brokers {}", (Object)replica, eligibleBrokers);
                if (this.maybeApplyBalancingAction(clusterModel, replica, eligibleBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty()) == null) {
                    if (clusterModel.skipCellBalancing() || !this.movePartition(clusterModel, replica.broker().cell(), replica.topicPartition(), optimizedGoals)) {
                        throw new OptimizationFailureException(String.format("[%s] Could not move neither replica %s nor replica's partition off broker %d / cell to satisfy topic placement.", this.name(), replica, broker.id()));
                    }
                    movedPartition = true;
                }
            }
            ArrayList<Replica> relocatedReplicas = new ArrayList<Replica>();
            if (movedPartition) {
                relocatedReplicas.addAll(clusterModel.partition(replica.topicPartition()).replicas());
            } else {
                relocatedReplicas.add(replica);
            }
            this.adjustObservershipOfRelocatedReplicas(clusterModel, relocatedReplicas);
            Partition partition = clusterModel.partition(replica.topicPartition());
            boolean tryLeadershipChange = partition.leader().isObserver();
            if (!tryLeadershipChange || this.maybeApplyBalancingAction(clusterModel, partition.leader(), partition.partitionSyncBrokersOfStateOtherThan(Broker.Strategy.IGNORE), ActionType.LEADERSHIP_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty()) != null) continue;
            LOG.debug("Failed to move leadership off of observer replica {} for partition {}", (Object)replica, (Object)partition);
        }
    }

    private void adjustObservershipOfRelocatedReplicas(ClusterModel clusterModel, List<Replica> relocatedReplicas) {
        for (Replica relocatedReplica : relocatedReplicas) {
            if (!this.shouldChangeObservership(relocatedReplica, clusterModel)) continue;
            String nextRole = relocatedReplica.isObserver() ? SYNC_REPLICA_NAME : OBSERVER_NAME;
            LOG.debug("Changing observership for replica {} to {}", (Object)relocatedReplica, (Object)nextRole);
            this.changeObservership(clusterModel, relocatedReplica.topicPartition(), relocatedReplica.broker().id());
        }
    }

    private boolean movePartition(ClusterModel clusterModel, Cell sourceCell, TopicPartition topicPartition, Set<Goal> optimizedGoals) {
        if (GoalUtils.partitionHasReplicaOnIgnoredBroker(clusterModel.partition(topicPartition))) {
            LOG.debug("Unable to move partition {} because it has a replica on an ignored broker.", (Object)topicPartition.toString());
            return false;
        }
        Optional<TopicPlacement> topicPlacementOpt = clusterModel.getTopicPlacement(topicPartition.topic());
        ArrayList<Cell> candidateCells = new ArrayList<Cell>(clusterModel.cells());
        Collections.shuffle(candidateCells);
        for (Cell cell : clusterModel.cells()) {
            if (cell.equals(sourceCell)) continue;
            int replicasNotInCell = (int)clusterModel.partition(topicPartition).replicas().stream().filter(replica -> !replica.broker().cell().equals(cell)).count();
            List<Broker> candidateBrokers = cell.brokers().stream().filter(broker -> !broker.hasReplicaOfPartition(topicPartition)).collect(Collectors.toList());
            List<BrokerCount> brokerCounts = topicPlacementOpt.map(tp -> this.findCandidateBrokers((TopicPlacement)tp, cell, clusterModel.partition(topicPartition))).orElse(Collections.singletonList(new BrokerCount(candidateBrokers, replicasNotInCell)));
            if (brokerCounts.isEmpty()) continue;
            ArrayList<Replica> replicasToMove = new ArrayList<Replica>(clusterModel.partition(topicPartition).replicas());
            Set<Broker> partitionBrokers = clusterModel.partition(topicPartition).partitionBrokers();
            for (BrokerCount brokerCount2 : brokerCounts) {
                List brokersToSkip = brokerCount2.candidateBrokers.stream().filter(partitionBrokers::contains).limit(brokerCount2.count).collect(Collectors.toList());
                brokerCount2.candidateBrokers.removeAll(brokersToSkip);
                Set replicasToSkip = brokersToSkip.stream().map(broker -> broker.replica(topicPartition)).collect(Collectors.toSet());
                replicasToMove.removeAll(replicasToSkip);
                brokerCount2.count -= brokersToSkip.size();
            }
            if ((brokerCounts = brokerCounts.stream().filter(brokerCount -> brokerCount.count > 0).collect(Collectors.toList())).isEmpty()) {
                return true;
            }
            Iterable<List<Broker>> candidateBrokersIterable = brokerCounts.size() > 1 ? EntityCombinator.multiEntityListIterable(this.brokerCountsToMap(brokerCounts)) : EntityCombinator.singleEntityListIterable(brokerCounts.get((int)0).candidateBrokers, brokerCounts.get((int)0).count);
            Map<Replica, Broker> replicaMoves = GoalUtils.getPartitionMoves(clusterModel, optimizedGoals, replicasToMove, candidateBrokersIterable);
            if (replicaMoves.isEmpty()) continue;
            replicaMoves.forEach((replicaToMove, broker) -> this.relocateReplica(clusterModel, replicaToMove.topicPartition(), replicaToMove.broker().id(), broker.id()));
            return true;
        }
        return false;
    }

    private List<BrokerCount> findCandidateBrokers(TopicPlacement topicPlacement, Cell cell, Partition partition) {
        HashMap<Map, BrokerCount> constraintToBrokerCounts = new HashMap<Map, BrokerCount>();
        for (TopicPlacement.ConstraintCount constraintCount : topicPlacement.replicas()) {
            List<Broker> matchingBrokers = this.matchingBrokers(cell, constraintCount, partition);
            if (constraintCount.count() > matchingBrokers.size()) {
                return Collections.emptyList();
            }
            constraintToBrokerCounts.put(constraintCount.constraints(), new BrokerCount(matchingBrokers, constraintCount.count()));
        }
        for (TopicPlacement.ConstraintCount constraintCount : topicPlacement.observers()) {
            BrokerCount syncReplicasBrokerCount = (BrokerCount)constraintToBrokerCounts.get(constraintCount.constraints());
            List<Broker> matchingBrokers = syncReplicasBrokerCount == null ? this.matchingBrokers(cell, constraintCount, partition) : syncReplicasBrokerCount.candidateBrokers;
            int syncReplicasCount = syncReplicasBrokerCount == null ? 0 : syncReplicasBrokerCount.count;
            int totalCount = syncReplicasCount + constraintCount.count();
            if (totalCount > matchingBrokers.size()) {
                return Collections.emptyList();
            }
            constraintToBrokerCounts.put(constraintCount.constraints(), new BrokerCount(matchingBrokers, totalCount));
        }
        return Collections.unmodifiableList(new ArrayList(constraintToBrokerCounts.values()));
    }

    private List<Broker> matchingBrokers(Cell cell, TopicPlacement.ConstraintCount constraintCount, Partition partition) {
        return cell.brokers().stream().filter(b -> constraintCount.matches(b.attributes()) && !b.strategy().equals((Object)Broker.Strategy.IGNORE) && partition.canAssignReplicaToBroker((Broker)b)).collect(Collectors.toList());
    }

    private LinkedHashMap<List<Broker>, Integer> brokerCountsToMap(List<BrokerCount> brokerCounts) {
        LinkedHashMap<List<Broker>, Integer> result = new LinkedHashMap<List<Broker>, Integer>();
        for (BrokerCount brokerCount : brokerCounts) {
            result.put(brokerCount.candidateBrokers, brokerCount.count);
        }
        return result;
    }

    private boolean shouldChangeObservership(Replica replica, ClusterModel clusterModel) {
        TopicPartition tp = replica.topicPartition();
        if (!clusterModel.getTopicPlacement(tp.topic()).isPresent()) {
            return false;
        }
        Map<String, String> attributes = replica.broker().attributes();
        int constraintCount = this.countForConstraint(this.constraintsForReplica(replica, clusterModel), attributes);
        int roleReplicasOnRack = this.numReplicasMatchingConstraint(attributes, tp, clusterModel, replica.isObserver());
        return roleReplicasOnRack > constraintCount;
    }

    private void validateTopicPlacements(ClusterModel clusterModel, Map<String, List<Partition>> partitionsByTopic) throws OptimizationFailureException {
        for (Map.Entry<String, List<Partition>> entry : partitionsByTopic.entrySet()) {
            String topic = entry.getKey();
            List<Partition> partitions = entry.getValue();
            TopicPlacement topicPlacement = clusterModel.getTopicPlacement(topic).orElseThrow(() -> new IllegalStateException(String.format("ReplicaPlacementGoal cannot find topic placement for topic %s", topic)));
            for (TopicPlacement.ConstraintCount constraint : topicPlacement.replicas()) {
                this.validateConstraint(constraint, partitions, clusterModel, false);
            }
            for (TopicPlacement.ConstraintCount constraint : topicPlacement.observers()) {
                this.validateConstraint(constraint, partitions, clusterModel, true);
            }
        }
    }

    private void validateConstraint(TopicPlacement.ConstraintCount constraint, List<Partition> partitions, ClusterModel clusterModel, boolean isObserver) throws OptimizationFailureException {
        Map attributes = constraint.constraints();
        int expectedCount = constraint.count();
        for (Partition partition : partitions) {
            TopicPartition tp = partition.topicPartition();
            int numReplicasMatchingConstraint = this.numReplicasMatchingConstraint(attributes, tp, clusterModel, isObserver);
            if (expectedCount != numReplicasMatchingConstraint) {
                String replicaType = isObserver ? OBSERVER_NAME : SYNC_REPLICA_NAME;
                throw new OptimizationFailureException(String.format("[%s] Violated %s topic placement requirement for attributes: %s with partition: %s. Required: %d replicas, Actual: %d replicas", this.name(), replicaType, attributes, tp, expectedCount, numReplicasMatchingConstraint));
            }
            if (!partition.leader().isObserver()) continue;
            throw new OptimizationFailureException(String.format("[%s] Violated failed goal optimization, failed to move leadership off of observer replica for partition %s during plan computation", this.name(), tp));
        }
    }

    private boolean isInvalidReplicaMovement(ClusterModel clusterModel, Broker sourceBroker, Broker destBroker, Replica replica) {
        List<TopicPlacement.ConstraintCount> constraints = this.constraintsForReplica(replica, clusterModel);
        return !constraints.isEmpty() && !sourceBroker.attributes().equals(destBroker.attributes());
    }

    List<Broker> replicaMovementEligibleBrokers(Replica replica, ClusterModel clusterModel) {
        ArrayList<Broker> eligibleBrokers = new ArrayList<Broker>();
        String topic = replica.topicPartition().topic();
        Map constraints = clusterModel.getTopicPlacement(topic).map(this::numReplicasRequiredByAttributeGroup).orElseGet(Collections::emptyMap);
        if (constraints.isEmpty()) {
            eligibleBrokers.addAll(clusterModel.aliveBrokers());
        } else {
            for (Map.Entry constraint : constraints.entrySet()) {
                Map constraintAttributes = (Map)constraint.getKey();
                Integer constraintCount = (Integer)constraint.getValue();
                int totalReplicasSatisfyingConstraint = this.totalReplicasMatchingConstraint(constraintAttributes, replica.topicPartition(), clusterModel);
                if (totalReplicasSatisfyingConstraint >= constraintCount) continue;
                eligibleBrokers.addAll(clusterModel.aliveBrokersMatchingAttributes(constraintAttributes));
            }
        }
        int numPartitionCells = GoalUtils.numPartitionCells(clusterModel.partition(replica.topicPartition()));
        eligibleBrokers = eligibleBrokers.stream().filter(broker -> !broker.hasReplicaOfPartition(replica.topicPartition()) && broker.isAlive() && broker.strategy() != Broker.Strategy.IGNORE && (numPartitionCells > 1 || broker.cell().equals(replica.broker().cell()))).collect(Collectors.toList());
        Collections.shuffle(eligibleBrokers);
        return eligibleBrokers;
    }

    protected boolean shouldMoveReplica(Replica replica, ClusterModel clusterModel) {
        String topic = replica.topicPartition().topic();
        Map constraints = clusterModel.getTopicPlacement(topic).map(this::numReplicasRequiredByAttributeGroup).orElseGet(Collections::emptyMap);
        if (constraints.isEmpty()) {
            return false;
        }
        Map<String, String> brokerAttributes = replica.broker().attributes();
        Integer attributeConstraintCount = constraints.getOrDefault(brokerAttributes, 0);
        return this.totalReplicasMatchingConstraint(brokerAttributes, replica.topicPartition(), clusterModel) > attributeConstraintCount;
    }

    protected int totalReplicasMatchingConstraint(Map<String, String> constraint, TopicPartition topicPartition, ClusterModel clusterModel) {
        return this.numReplicasMatchingConstraint(constraint, topicPartition, clusterModel, true) + this.numReplicasMatchingConstraint(constraint, topicPartition, clusterModel, false);
    }

    private int numReplicasMatchingConstraint(Map<String, String> constraint, TopicPartition topicPartition, ClusterModel clusterModel, boolean isObserver) {
        Partition partition = clusterModel.partition(topicPartition);
        Set<Broker> partitionBrokersOnRack = isObserver ? partition.partitionObserverBrokers() : partition.partitionSyncBrokers();
        partitionBrokersOnRack.retainAll(clusterModel.aliveBrokersMatchingAttributes(constraint));
        return partitionBrokersOnRack.size();
    }

    private int countForConstraint(List<TopicPlacement.ConstraintCount> constraints, Map<String, String> attributes) {
        return constraints.stream().filter(constraint -> constraint.matches(attributes)).mapToInt(TopicPlacement.ConstraintCount::count).sum();
    }

    private List<TopicPlacement.ConstraintCount> constraintsForReplica(Replica replica, ClusterModel clusterModel) {
        Optional<TopicPlacement> topicPlacement = clusterModel.getTopicPlacement(replica.topicPartition().topic());
        if (!topicPlacement.isPresent()) {
            return Collections.emptyList();
        }
        return replica.isObserver() ? topicPlacement.get().observers() : topicPlacement.get().replicas();
    }

    protected Map<Map<String, String>, Integer> numReplicasRequiredByAttributeGroup(TopicPlacement topicPlacement) {
        Stream replicaConstraints = topicPlacement.replicas().stream();
        Stream observerConstraints = topicPlacement.observers().stream();
        return Stream.concat(replicaConstraints, observerConstraints).collect(Collectors.toMap(TopicPlacement.ConstraintCount::constraints, TopicPlacement.ConstraintCount::count, Integer::sum));
    }

    private static class BrokerCount {
        final List<Broker> candidateBrokers;
        int count;

        BrokerCount(List<Broker> candidateBrokers, int count) {
            Objects.requireNonNull(candidateBrokers);
            if (candidateBrokers.isEmpty() || count < 1 || count > candidateBrokers.size()) {
                throw new IllegalArgumentException("Number of brokers to select is %d and needs to be greater than 0.Candidate brokers to meet constraint are %s and their amount needs to be in [1, count].");
            }
            this.candidateBrokers = candidateBrokers;
            this.count = count;
        }
    }
}

