/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter.opentelemetry;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.AttributeResult;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.WireFormatHelpers;
import io.opentelemetry.proto.common.v1.AnyValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

final class FilteringAttributeParser
extends AbstractParser<AttributeResult> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int KEY_FIELD_TAG = WireFormatHelpers.makeTag(1, 2);
    private static final int VALUE_FIELD_NUMBER = 2;
    private static final int VALUE_FIELD_TAG = WireFormatHelpers.makeTag(2, 2);
    private final int interestedAttributeKeyContentSize;
    private final String interestedAttributeKeyContent;

    FilteringAttributeParser(String interestedAttributeKeyContent) {
        this.interestedAttributeKeyContentSize = interestedAttributeKeyContent.length();
        this.interestedAttributeKeyContent = interestedAttributeKeyContent;
    }

    public AttributeResult parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        try {
            boolean found = false;
            AnyValue value = null;
            while (!WireFormatHelpers.isMessageEndReached(input)) {
                int tag = input.readTag();
                if (tag == KEY_FIELD_TAG) {
                    int size = input.readRawVarint32();
                    if (size == this.interestedAttributeKeyContentSize) {
                        String tagType = new String(input.readRawBytes(size), StandardCharsets.UTF_8);
                        if (this.interestedAttributeKeyContent.equals(tagType)) {
                            found = true;
                            continue;
                        }
                    } else {
                        input.skipRawBytes(size);
                    }
                    found = false;
                    continue;
                }
                if (tag == VALUE_FIELD_TAG && this.isTheValueOfInterest(input, found)) {
                    value = (AnyValue)input.readMessage(AnyValue.parser(), extensionRegistry);
                    continue;
                }
                input.skipField(tag);
            }
            if (!found) {
                return AttributeResult.DEFAULT_INSTANCE;
            }
            return new AttributeResult(true, value);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e);
        }
    }

    private boolean isTheValueOfInterest(CodedInputStream input, boolean found) {
        if (found) {
            return true;
        }
        return input.getBytesUntilLimit() > this.interestedAttributeKeyContentSize;
    }
}

