/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kafka.common.CellLoadDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.requests.ApiError;

public class SbcCellLoadEvent
extends SbcEvent {
    private ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<CellLoadDescriptionInternal> cb;
    private List<Integer> cellIds;

    public SbcCellLoadEvent(SbcContext sbcContext, List<Integer> cellIds, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<CellLoadDescriptionInternal> cb) {
        super(sbcContext);
        this.cb = cb;
        this.cellIds = cellIds;
    }

    @Override
    @Nonnull
    protected SbcEvent.SbcEventHandlerResult handleEvent() throws Exception {
        return new SbcCellLoadEventHandlerResult(new CellLoadDescriptionInternal(this.eventContext.kafkaDataBalanceManager().getBalanceEngine().cellLoad(this.cellIds)));
    }

    @Override
    protected void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        if (result instanceof SbcCellLoadEventHandlerResult) {
            this.cb.respond(error, Optional.ofNullable(((SbcCellLoadEventHandlerResult)result).getCellLoadDescriptionInternal()));
        } else {
            this.cb.respond(error, Optional.empty());
        }
    }

    private static class SbcCellLoadEventHandlerResult
    extends SbcEvent.SbcEventHandlerResult {
        private final CellLoadDescriptionInternal cellLoad;

        public SbcCellLoadEventHandlerResult(CellLoadDescriptionInternal cellLoad) {
            this.cellLoad = cellLoad;
        }

        public CellLoadDescriptionInternal getCellLoadDescriptionInternal() {
            return this.cellLoad;
        }
    }
}

