/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kafka.common.EvenClusterLoadPlanInternal;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.requests.ApiError;

public class SbcComputeEvenClusterLoadPlanEvent
extends SbcEvent {
    private final ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> callback;
    private final List<String> goalList;

    public SbcComputeEvenClusterLoadPlanEvent(List<String> goalList, SbcContext context, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<EvenClusterLoadPlanInternal> callback) {
        super(context);
        this.callback = callback;
        this.goalList = goalList;
    }

    @Override
    @Nonnull
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        this.eventContext.kafkaDataBalanceManager().computeEvenClusterLoadPlan(this.goalList, this.callback);
        return SbcEvent.SbcEventHandlerResult.SUCCESS;
    }

    @Override
    protected void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        if (result.equals(SbcEvent.SbcEventHandlerResult.SUCCESS)) {
            return;
        }
        this.callback.respond(error, Optional.empty());
    }
}

