/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.BrokersMetadataSnapshot;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcAbstractScheduleBrokerRemovalEvent;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.resource.SbcResources;
import io.confluent.databalancer.metadata.TopicsImageMetadataSnapshot;
import java.util.List;
import java.util.Optional;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.TopicsImage;

public class SbcKRaftScheduleBrokerRemovalEvent
extends SbcAbstractScheduleBrokerRemovalEvent {
    public SbcKRaftScheduleBrokerRemovalEvent(SbcContext context, List<Integer> brokersToRemove, boolean shouldShutdown, ClusterBalanceManager.BalanceManagerOperationInvocationClientCallback cb) {
        super(context, brokersToRemove, shouldShutdown, cb);
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        Optional<ClusterImage> clusterImageOpt = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.CLUSTER_IMAGE);
        Optional<TopicsImage> topicsImageOpt = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.TOPICS_IMAGE);
        Optional<BrokerReplicaExclusionsImage> exclusionsImageOpt = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.EXCLUSIONS_IMAGE);
        if (!clusterImageOpt.isPresent()) {
            LOG.info("Pausing processing for removal request for brokers {} due to lacking a cluster image.", (Object)this.brokersToRemove);
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.CLUSTER_IMAGE);
        }
        if (!topicsImageOpt.isPresent()) {
            LOG.info("Pausing processing for removal request for brokers {} due to lacking a topics image.", (Object)this.brokersToRemove);
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.TOPICS_IMAGE);
        }
        if (!exclusionsImageOpt.isPresent()) {
            LOG.info("Pausing processing for removal request for brokers {} due to lacking an exclusions image.", (Object)this.brokersToRemove);
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.EXCLUSIONS_IMAGE);
        }
        ClusterImage clusterImage = clusterImageOpt.get();
        TopicsImage topicsImage = topicsImageOpt.get();
        BrokerReplicaExclusionsImage exclusionsImage = exclusionsImageOpt.get();
        BrokersMetadataSnapshot brokersMetadata = BrokersMetadataSnapshot.of(clusterImage.brokers(), exclusionsImage.activeBrokerReplicaExclusions().keySet());
        TopicsImageMetadataSnapshot topicsMetadata = new TopicsImageMetadataSnapshot(topicsImage);
        return this.validateAndScheduleRemoval(brokersMetadata, topicsMetadata);
    }
}

