/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import io.confluent.databalancer.operation.StateMachine;
import io.confluent.databalancer.operation.StateTransitioner;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.common.utils.Time;

public class BalancerStatusStateMachine
extends StateMachine<BalancerState, BalancerEvent> {
    private static StateTransitioner<BalancerState, BalancerEvent> transitioner = new StateTransitioner.Builder().with(BalancerStatusStateMachine.transition().from(BalancerState.BALANCER_EVENT_RECEIVED).to(BalancerState.STARTING).when(new BalancerEvent[]{BalancerEvent.INITIALIZING_CRUISE_CONTROL})).with(BalancerStatusStateMachine.transition().from(BalancerState.DISABLED).to(BalancerState.STARTING).when(new BalancerEvent[]{BalancerEvent.BALANCER_ENABLED})).with(BalancerStatusStateMachine.transition().from(BalancerState.BALANCER_EVENT_RECEIVED).to(BalancerState.JBOD_ENABLED_ERROR).when(new BalancerEvent[]{BalancerEvent.JBOD_ENABLED})).with(BalancerStatusStateMachine.transition().from(BalancerState.STARTING).to(BalancerState.RUNNING).when(new BalancerEvent[]{BalancerEvent.CRUISE_CONTROL_INITIALIZATION_COMPLETED})).with(BalancerStatusStateMachine.transition().from(BalancerState.STARTING).to(BalancerState.JBOD_ENABLED_ERROR).when(new BalancerEvent[]{BalancerEvent.JBOD_ENABLED})).with(BalancerStatusStateMachine.transition().from(BalancerState.STARTING).to(BalancerState.ERROR).when(new BalancerEvent[]{BalancerEvent.CRUISE_CONTROL_ERRORED})).with(BalancerStatusStateMachine.transition().from(BalancerState.RUNNING).to(BalancerState.ERROR).when(new BalancerEvent[]{BalancerEvent.CRUISE_CONTROL_ERRORED})).addEventBasedTransition(BalancerEvent.BALANCER_DISABLED, BalancerState.DISABLED).addEventBasedTransition(BalancerEvent.CONTROLLER_FAILS_OVER, BalancerState.STOPPED).build();
    private static final BalancerState START_STATE = BalancerState.BALANCER_EVENT_RECEIVED;

    public BalancerStatusStateMachine(int brokerId) {
        this(brokerId, Time.SYSTEM);
    }

    public BalancerStatusStateMachine(int brokerId, Time time) {
        super(brokerId, "Balancer Status", START_STATE, time);
    }

    private static StateTransitioner.TransitionBuilder<BalancerState, BalancerEvent> transition() {
        return new StateTransitioner.TransitionBuilder<BalancerState, BalancerEvent>();
    }

    @Override
    StateTransitioner<BalancerState, BalancerEvent> transitioner() {
        return transitioner;
    }

    public static enum BalancerEvent implements BalancerOperationEvent
    {
        BALANCER_DISABLED,
        BALANCER_ENABLED,
        JBOD_ENABLED,
        BALANCER_MISCONFIGURED,
        CRUISE_CONTROL_ERRORED,
        INITIALIZING_CRUISE_CONTROL,
        CRUISE_CONTROL_INITIALIZATION_COMPLETED,
        CONTROLLER_FAILS_OVER;

    }

    @Immutable
    public static enum BalancerState implements BalancerOperationState
    {
        BALANCER_EVENT_RECEIVED(BalancerStatus.BOOTSTRAPPING),
        STARTING(BalancerStatus.STARTING),
        RUNNING(BalancerStatus.ENABLED),
        DISABLED(BalancerStatus.DISABLED),
        JBOD_ENABLED_ERROR(BalancerStatus.ERROR),
        ERROR(BalancerStatus.ERROR),
        STOPPED(BalancerStatus.FAILOVER, true);

        private final BalancerStatus status;
        private final boolean isTerminal;

        private BalancerState(BalancerStatus status) {
            this(status, false);
        }

        private BalancerState(BalancerStatus status, boolean isTerminal) {
            this.status = status;
            this.isTerminal = isTerminal;
        }

        public BalancerStatus status() {
            return this.status;
        }

        @Override
        public boolean isTerminal() {
            return this.isTerminal;
        }
    }
}

