/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BrokerRemovalCancellationMode;
import io.confluent.databalancer.operation.BrokerRemovalExclusionCancellationData;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BrokerRemovalCancellationProposal {
    public final BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent;
    public final BrokerRemovalCancellationMode cancellationMode;
    public final Exception eventException;
    public final Optional<BrokerRemovalExclusionCancellationData> modifiedExclusions;
    public final Optional<Set<Integer>> demotedBrokers;

    private BrokerRemovalCancellationProposal(BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent, BrokerRemovalCancellationMode cancellationMode, Exception eventException, Optional<BrokerRemovalExclusionCancellationData> modifiedExclusions, Optional<Set<Integer>> demotedBrokers) {
        this.cancellationEvent = cancellationEvent;
        this.cancellationMode = cancellationMode;
        this.eventException = eventException;
        this.modifiedExclusions = modifiedExclusions;
        this.demotedBrokers = demotedBrokers;
    }

    public BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent() {
        return this.cancellationEvent;
    }

    public BrokerRemovalCancellationMode cancellationMode() {
        return this.cancellationMode;
    }

    public Exception eventException() {
        return this.eventException;
    }

    public Optional<BrokerRemovalExclusionCancellationData> exclusionData() {
        return this.modifiedExclusions;
    }

    public Optional<Set<Integer>> demotedBrokers() {
        return this.demotedBrokers;
    }

    public static class BrokerRemovalCancellationProposalBuilder {
        private BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent;
        private BrokerRemovalCancellationMode cancellationMode = BrokerRemovalCancellationMode.PERSISTENT_CANCELLATION;
        private Exception eventException = null;
        private BrokerRemovalExclusionCancellationData modifiedExclusionsData = null;
        private Set<Integer> demotedBrokers = null;

        public BrokerRemovalCancellationProposalBuilder setCancellationEvent(BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent) {
            this.cancellationEvent = cancellationEvent;
            return this;
        }

        public BrokerRemovalCancellationProposalBuilder setCancellationMode(BrokerRemovalCancellationMode cancellationMode) {
            this.cancellationMode = cancellationMode;
            return this;
        }

        public BrokerRemovalCancellationProposalBuilder setEventException(Exception eventException) {
            this.eventException = eventException;
            return this;
        }

        public BrokerRemovalCancellationProposalBuilder setModifiedExclusionsData(BrokerRemovalExclusionCancellationData modifiedExclusionsData) {
            this.modifiedExclusionsData = modifiedExclusionsData;
            return this;
        }

        public BrokerRemovalCancellationProposalBuilder setDemotedBrokers(Set<Integer> brokers) {
            this.demotedBrokers = brokers;
            return this;
        }

        public BrokerRemovalStateMachine.BrokerRemovalEvent cancellationEvent() {
            return this.cancellationEvent;
        }

        public BrokerRemovalCancellationMode cancellationMode() {
            return this.cancellationMode;
        }

        public BrokerRemovalCancellationProposal build() {
            if (this.cancellationEvent == null || this.cancellationMode == null) {
                throw new IllegalArgumentException(String.format("Must specify cancellation mode and event when creating cancellation request, currently %s", this));
            }
            if (this.cancellationEvent == BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_ADDED || this.cancellationEvent == BrokerRemovalStateMachine.BrokerRemovalEvent.EXCLUSION_REMOVED) {
                if (this.modifiedExclusionsData == null || this.modifiedExclusionsData.modifiedExclusions.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Must specify modified exclusions brokers for %s event when creating cancellation request, currently %s", this.cancellationEvent, this));
                }
            } else if (this.cancellationEvent == BrokerRemovalStateMachine.BrokerRemovalEvent.DEMOTED_ADDED && (this.demotedBrokers == null || this.demotedBrokers.isEmpty())) {
                throw new IllegalArgumentException(String.format("Must specify demoted brokers for %s event when creating cancellation request, currently %s", this.cancellationEvent, this));
            }
            return new BrokerRemovalCancellationProposal(this.cancellationEvent, this.cancellationMode, this.eventException, Optional.ofNullable(this.modifiedExclusionsData), Optional.ofNullable(this.demotedBrokers));
        }

        public String toString() {
            return "BrokerRemovalCancellationProposalBuilder{cancellationEvent=" + this.cancellationEvent + ", cancellationMode=" + (Object)((Object)this.cancellationMode) + ", eventException=" + this.eventException + ", modifiedExclusionData=" + this.modifiedExclusionsData + ", demotedBrokers=" + this.demotedBrokers + "}";
        }
    }
}

