/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTransitioner<S extends BalancerOperationState, E extends BalancerOperationEvent> {
    private static final Logger log = LoggerFactory.getLogger(StateTransitioner.class);
    private Map<S, Map<E, S>> stateTransitions;
    private Map<E, S> eventBasedTransitions;

    private StateTransitioner(List<Transition<S, E>> transitionsList, Map<E, S> eventBasedTransitions) {
        this.eventBasedTransitions = eventBasedTransitions;
        this.stateTransitions = new HashMap<S, Map<E, S>>();
        for (Transition<S, E> t : transitionsList) {
            Map<E, S> transitions;
            if (!this.stateTransitions.containsKey(((Transition)t).startState)) {
                this.stateTransitions.put(((Transition)t).startState, new HashMap());
            }
            if ((transitions = this.stateTransitions.get(((Transition)t).startState)).containsKey(((Transition)t).event)) {
                String existingTransition = String.format("%s transitions to %s on a %s event", ((Transition)t).startState, transitions.get(((Transition)t).event), ((Transition)t).event);
                String newTransition = String.format("%s transitions to %s on a %s event", ((Transition)t).startState, ((Transition)t).endState, ((Transition)t).event);
                String errMsg = String.format("Found duplicate state transition event - registered transition (%s) and new transition (%s)", existingTransition, newTransition);
                throw new IllegalArgumentException(errMsg);
            }
            transitions.put(((Transition)t).event, ((Transition)t).endState);
        }
    }

    public Optional<S> transition(S currentState, E event) {
        if (this.eventBasedTransitions.containsKey(event)) {
            return currentState.isTerminal() ? Optional.empty() : Optional.ofNullable(this.eventBasedTransitions.get(event));
        }
        S newState = this.nextState(currentState, event);
        return Optional.ofNullable(newState);
    }

    public boolean isTerminalState(S state) {
        return state.isTerminal();
    }

    public boolean canTransition(S currentState, E event) {
        S newState = this.nextState(currentState, event);
        return newState != null;
    }

    private S nextState(S currentState, E event) {
        Map<E, S> transitions = this.stateTransitions.get(currentState);
        if (transitions == null) {
            log.warn("No transition found from state {}", currentState);
            return null;
        }
        BalancerOperationState newState = (BalancerOperationState)transitions.get(event);
        if (newState == null) {
            log.warn("No transition found from state {} with event {}", currentState, event);
            return null;
        }
        return (S)newState;
    }

    static class TransitionBuilder<S extends BalancerOperationState, E extends BalancerOperationEvent> {
        private S startState;
        private S endState;

        TransitionBuilder() {
        }

        public TransitionBuilder<S, E> from(S startState) {
            this.startState = startState;
            return this;
        }

        public TransitionBuilder<S, E> to(S endState) {
            this.endState = endState;
            return this;
        }

        @SafeVarargs
        public final List<Transition<S, E>> when(E ... events) {
            if (this.startState == null || this.endState == null) {
                throw new IllegalStateException("Cannot build Transition when start or end state is not defined.");
            }
            ArrayList<Transition<S, Transition<S, E>>> transitionList = new ArrayList<Transition<S, Transition<S, E>>>();
            for (E event : events) {
                transitionList.add(new Transition<S, E>(this.startState, event, this.endState));
            }
            return transitionList;
        }
    }

    public static class Builder<S extends BalancerOperationState, E extends BalancerOperationEvent> {
        List<Transition<S, E>> transitions;
        Map<E, S> eventBasedTransitions = new HashMap<E, S>();

        public Builder() {
            this.transitions = new ArrayList<Transition<S, E>>();
        }

        public Builder<S, E> with(Transition<S, E> transition) {
            return this.with(Collections.singletonList(transition));
        }

        public Builder<S, E> with(List<Transition<S, E>> givenTransitions) {
            for (Transition<S, E> transition : givenTransitions) {
                if (((Transition)transition).startState.isTerminal()) {
                    throw new IllegalStateException(String.format("Cannot add transition from %s as its a terminal state", ((Transition)transition).startState.name()));
                }
                this.transitions.add(transition);
            }
            return this;
        }

        public Builder<S, E> addEventBasedTransition(E event, S eventBasedTransitionState) {
            this.eventBasedTransitions.put(event, eventBasedTransitionState);
            return this;
        }

        public StateTransitioner<S, E> build() {
            return new StateTransitioner(this.transitions, this.eventBasedTransitions);
        }
    }

    public static class Transition<S extends BalancerOperationState, E extends BalancerOperationEvent> {
        private final S startState;
        private final E event;
        private final S endState;

        public Transition(S startState, E event, S endState) {
            this.startState = startState;
            this.event = event;
            this.endState = endState;
        }
    }
}

