/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import java.util.Map;

public abstract class AbstractStateSerializer<S, PS> {
    abstract Map<S, Mapping<S, PS>> stateToMappings();

    abstract Map<PS, Mapping<S, PS>> persistedStateToMappings();

    public PS serialize(S state) {
        if (!this.stateToMappings().containsKey(state)) {
            throw new IllegalArgumentException(String.format("Cannot serialize state %s as it is not recognized", state));
        }
        return this.stateToMappings().get(state).persistedState;
    }

    public S deserialize(PS persistedState) {
        if (!this.persistedStateToMappings().containsKey(persistedState)) {
            throw new IllegalArgumentException(String.format("Cannot deserialize persisted state %s as it is not recognized", persistedState));
        }
        return this.persistedStateToMappings().get(persistedState).state;
    }

    public static class Mapping<S, PS> {
        public final S state;
        public final PS persistedState;

        public Mapping(S state, PS persistedState) {
            this.state = state;
            this.persistedState = persistedState;
        }
    }
}

