/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import io.confluent.databalancer.operation.BrokerAdditionV2StateMachine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import kafka.common.BrokerAdditionDescriptionInternal;

public class BrokerAdditionStateRecord {
    private final int brokerId;
    private final BrokerAdditionV2StateMachine.BrokerAdditionV2State state;
    private final Exception exception;
    private final long startTimeMs;
    private final long lastUpdateTimeMs;

    public BrokerAdditionStateRecord(int brokerId, BrokerAdditionV2StateMachine.BrokerAdditionV2State state, Exception exception, long startTimeMs, long lastUpdateTimeMs) {
        this.brokerId = brokerId;
        this.state = state;
        this.exception = exception;
        this.startTimeMs = startTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimeMs;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerAdditionV2StateMachine.BrokerAdditionV2State state() {
        return this.state;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public Exception exception() {
        return this.exception;
    }

    public BrokerAdditionDescriptionInternal toBrokerAdditionDescriptionInternal() {
        return new BrokerAdditionDescriptionInternal(this.brokerId, this.state.status(), BrokerAdditionV2StateMachine.convertBrokerAdditionV2Status(this.state.status()), this.startTimeMs, this.lastUpdateTimeMs, this.exception);
    }

    public String toString() {
        return "BrokerAdditionStateRecord{brokerId=" + this.brokerId + ", state=" + this.state + ", exception=" + this.exception + ", startTimeMs=" + this.startTimeMs + ", lastUpdateTimeMs=" + this.lastUpdateTimeMs + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerAdditionStateRecord that = (BrokerAdditionStateRecord)o;
        return this.brokerId == that.brokerId && this.startTimeMs == that.startTimeMs && this.lastUpdateTimeMs == that.lastUpdateTimeMs && this.state == that.state && this.exceptionEquals(that);
    }

    private boolean exceptionEquals(BrokerAdditionStateRecord that) {
        if (this.exception != null && that.exception != null) {
            return Objects.equals(this.exception.getClass(), that.exception.getClass()) && Objects.equals(this.exception.getMessage(), that.exception.getMessage());
        }
        return this.exception == that.exception;
    }

    public int hashCode() {
        ArrayList<Serializable> objectsToHash = new ArrayList<Serializable>(Arrays.asList(this.brokerId, this.state, this.startTimeMs, this.lastUpdateTimeMs));
        if (this.exception != null) {
            objectsToHash.addAll(Arrays.asList(this.exception.getClass(), this.exception.getMessage()));
        }
        return Objects.hash(objectsToHash.toArray(new Object[0]));
    }
}

