/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.utils.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.common.BrokerRemovalDescriptionInternal;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

public class BrokerRemovalStateRecord {
    private final ImmutableSet<Integer> brokerIds;
    private final BrokerRemovalStateMachine.BrokerRemovalState state;
    private final Exception exception;
    private final boolean shouldShutdown;
    private long startTime;
    private long lastUpdateTime;

    public BrokerRemovalStateRecord(Set<Integer> brokerIds, BrokerRemovalStateMachine.BrokerRemovalState state, Exception exception, boolean shouldShutdown) {
        this.brokerIds = new ImmutableSet<Integer>(brokerIds);
        this.state = state;
        this.exception = exception;
        this.shouldShutdown = shouldShutdown;
    }

    public long startTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public ImmutableSet<Integer> brokerIds() {
        return this.brokerIds;
    }

    public BrokerRemovalStateMachine.BrokerRemovalState state() {
        return this.state;
    }

    public Exception exception() {
        return this.exception;
    }

    public PartitionReassignmentsStatus partitionReassignmentsStatus() {
        return this.state.partitionReassignmentsStatus();
    }

    public BrokerShutdownStatus brokerShutdownStatus() {
        return this.state.brokerShutdownStatus();
    }

    public BrokerReplicaExclusionStatus replicaExclusionStatus() {
        return this.state.replicaExclusionStatus();
    }

    public boolean shouldShutdown() {
        return this.shouldShutdown;
    }

    public List<BrokerRemovalDescriptionInternal> toRemovalDescriptions() {
        return this.brokerIds.stream().map(id -> new BrokerRemovalDescriptionInternal(id.intValue(), this.state.toBalancerOperationStatus(), this.state.replicaExclusionStatus(), this.state.partitionReassignmentsStatus(), this.state.brokerShutdownStatus(), this.exception, this.startTime(), this.lastUpdateTime(), this.shouldShutdown)).collect(Collectors.toList());
    }

    public String toString() {
        return "BrokerRemovalStateRecord{brokerId=" + this.brokerIds + ", state=" + this.state + ", replicaExclusionStatus=" + this.replicaExclusionStatus().name() + ", partitionReassignmentsStatus=" + this.partitionReassignmentsStatus().name() + ", brokerShutdownStatus=" + this.brokerShutdownStatus().name() + ", exception=" + this.exception + ", startTime=" + this.startTime + ", lastUpdateTime=" + this.lastUpdateTime + ", shouldShutdown=" + this.shouldShutdown + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerRemovalStateRecord that = (BrokerRemovalStateRecord)o;
        return this.shouldShutdown == that.shouldShutdown && this.startTime == that.startTime && this.lastUpdateTime == that.lastUpdateTime && Objects.equals(this.brokerIds, that.brokerIds) && this.state == that.state && this.exceptionEquals(that);
    }

    private boolean exceptionEquals(BrokerRemovalStateRecord that) {
        if (this.exception != null && that.exception != null) {
            return Objects.equals(this.exception.getClass(), that.exception.getClass()) && Objects.equals(this.exception.getMessage(), that.exception.getMessage());
        }
        return this.exception == that.exception;
    }

    public int hashCode() {
        ArrayList<Object> objectsToHash = new ArrayList<Object>(Arrays.asList(this.brokerIds, this.state, this.shouldShutdown, this.startTime, this.lastUpdateTime));
        if (this.exception != null) {
            objectsToHash.addAll(Arrays.asList(this.exception.getClass(), this.exception.getMessage()));
        }
        return Objects.hash(objectsToHash.toArray(new Object[0]));
    }
}

