/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import io.confluent.databalancer.operation.EvenClusterLoadStateMachine;
import java.util.Objects;
import kafka.common.EvenClusterLoadStatusDescriptionInternal;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;

public class EvenClusterLoadStateRecord {
    private final EvenClusterLoadStateMachine.EvenClusterLoadState currentState;
    private long currentStateCreatedAt;
    private long currentStateLastUpdatedAt;
    private final EvenClusterLoadStateMachine.EvenClusterLoadState previousState;
    private long previousStateCreatedAt;
    private long previousStateLastUpdatedAt;
    private final Exception currentStateException;
    private final Exception previousStateException;

    public EvenClusterLoadStateRecord(EvenClusterLoadStateMachine.EvenClusterLoadState currentState, Long currentStateCreatedAt, Long currentStateLastUpdatedAt, Exception currentStateException, EvenClusterLoadStateMachine.EvenClusterLoadState previousState, Long previousStateCreatedAt, Long previousStateLastUpdatedAt, Exception previousStateException) {
        this.currentState = currentState;
        this.currentStateCreatedAt = currentStateCreatedAt;
        this.currentStateLastUpdatedAt = currentStateLastUpdatedAt != null ? currentStateLastUpdatedAt : 0L;
        this.currentStateException = currentStateException;
        this.previousState = previousState;
        this.previousStateCreatedAt = previousStateCreatedAt != null ? previousStateCreatedAt : 0L;
        this.previousStateLastUpdatedAt = previousStateLastUpdatedAt != null ? previousStateLastUpdatedAt : 0L;
        this.previousStateException = previousStateException;
    }

    public EvenClusterLoadStateMachine.EvenClusterLoadState currentState() {
        return this.currentState;
    }

    public long currentStateCreatedAt() {
        return this.currentStateCreatedAt;
    }

    public long currentStateLastUpdatedAt() {
        return this.currentStateLastUpdatedAt;
    }

    public Exception currentStateException() {
        return this.currentStateException;
    }

    public EvenClusterLoadStateMachine.EvenClusterLoadState previousState() {
        return this.previousState;
    }

    public long previousStateCreatedAt() {
        return this.previousStateCreatedAt;
    }

    public long previousStateLastUpdatedAt() {
        return this.previousStateLastUpdatedAt;
    }

    public Exception previousStateException() {
        return this.previousStateException;
    }

    public EvenClusterLoadStatusDescriptionInternal toEvenClusterLoadDescriptionInternal(boolean anyUnevenLoadEnabled) {
        Exception e = this.currentStateException != null ? this.currentStateException : this.previousStateException;
        EvenClusterLoadStatus currentStatus = this.currentState != null ? this.currentState.status() : null;
        EvenClusterLoadStatus previousStatus = this.previousState != null ? this.previousState.status() : null;
        BalancerSelfHealMode healUnevenLoadTrigger = anyUnevenLoadEnabled ? BalancerSelfHealMode.ANY_UNEVEN_LOAD : BalancerSelfHealMode.EMPTY_BROKER;
        return new EvenClusterLoadStatusDescriptionInternal(healUnevenLoadTrigger, currentStatus, Long.valueOf(this.currentStateLastUpdatedAt), previousStatus, Long.valueOf(this.previousStateLastUpdatedAt), e);
    }

    public String toString() {
        return "EvenClusterLoadStateRecord{ currentState=" + this.currentState + ", currentStateCreatedAt=" + this.currentStateCreatedAt + ", currentStateLastUpdatedAt=" + this.currentStateLastUpdatedAt + ", currentStateException=" + this.currentStateException + ", previousState=" + this.previousState + ", previousStateCreatedAt=" + this.previousStateCreatedAt + ", previousStateLastUpdatedAt=" + this.previousStateLastUpdatedAt + ", previousStateException=" + this.previousStateException + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvenClusterLoadStateRecord that = (EvenClusterLoadStateRecord)o;
        return this.currentState == that.currentState && this.currentStateCreatedAt == that.currentStateCreatedAt && this.currentStateLastUpdatedAt == that.currentStateLastUpdatedAt && this.currentStateException == null ? that.currentStateException == null : (this.currentStateException.equals(that.currentStateException) && this.previousState == that.previousState && this.previousStateCreatedAt == that.previousStateCreatedAt && this.previousStateLastUpdatedAt == that.previousStateLastUpdatedAt && this.previousStateException == null ? that.previousStateException == null : this.previousStateException.equals(that.previousStateException));
    }

    public int hashCode() {
        return Objects.hash(this.currentState, this.currentStateCreatedAt, this.currentStateLastUpdatedAt, this.currentStateException, this.previousState, this.previousStateCreatedAt, this.previousStateLastUpdatedAt, this.previousStateException);
    }
}

