/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.startup;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleStoreTopicCleanUp;
import io.confluent.cruisecontrol.metricsreporter.ConfluentMetricsSamplerBase;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StartupComponents {
    private static final Logger LOG = LoggerFactory.getLogger(StartupComponents.class);
    private final Semaphore abortStartupCheck;
    List<StartupComponent> components;
    private KafkaCruiseControlConfig config;

    StartupComponents(Semaphore abortStartupCheck, List<StartupComponent> components, KafkaCruiseControlConfig config) {
        this.abortStartupCheck = abortStartupCheck;
        this.components = components;
        this.config = config;
    }

    public void checkStartupCondition() {
        for (StartupComponent startupComponent : this.components) {
            LOG.info("DataBalancer: Checking startup component {}", (Object)startupComponent);
            startupComponent.start(this.config, this.abortStartupCheck);
            LOG.info("DataBalancer: Startup component {} ready to proceed", (Object)startupComponent);
        }
        LOG.info("DataBalancer: Startup checking succeeded, proceeding to full validation.");
    }

    public static final class Builder {
        private Semaphore abortStartupCheck;

        public Builder(Semaphore abortStartupCheck) {
            this.abortStartupCheck = abortStartupCheck;
        }

        public StartupComponents build(KafkaCruiseControlConfig config) {
            LinkedList<StartupComponent> components = new LinkedList<StartupComponent>();
            Class sampler = config.getClass("metric.sampler.class");
            if (sampler != null && ConfluentMetricsSamplerBase.class.isAssignableFrom(sampler)) {
                components.add(new StartupComponent(sampler.getSimpleName(), ConfluentMetricsSamplerBase::checkStartupCondition));
            }
            components.add(new StartupComponent(SampleStoreTopicCleanUp.class.getSimpleName(), SampleStoreTopicCleanUp::maybeDeleteSampleStoreTopic));
            components.add(new StartupComponent(ApiStatePersistenceStore.class.getSimpleName(), ApiStatePersistenceStore::checkStartupCondition));
            return new StartupComponents(this.abortStartupCheck, components, config);
        }
    }

    static class StartupComponent {
        private final String componentName;
        private final BiConsumer<KafkaCruiseControlConfig, Semaphore> startUpLambda;

        public StartupComponent(String componentName, BiConsumer<KafkaCruiseControlConfig, Semaphore> startUpLambda) {
            this.componentName = componentName;
            this.startUpLambda = startUpLambda;
        }

        public void start(KafkaCruiseControlConfig config, Semaphore semaphore) {
            this.startUpLambda.accept(config, semaphore);
        }

        public String toString() {
            return String.format("StartupComponent %s", this.componentName);
        }
    }
}

