/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.properties.LocalProperties;
import io.confluent.ksql.rest.client.BasicCredentials;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.rest.client.KsqlTarget;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.client.StreamPublisher;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.rest.entity.ClusterStatusResponse;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.entity.CommandStatuses;
import io.confluent.ksql.rest.entity.HealthCheckResponse;
import io.confluent.ksql.rest.entity.HeartbeatResponse;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.confluent.ksql.rest.entity.LagReportingResponse;
import io.confluent.ksql.rest.entity.ServerClusterId;
import io.confluent.ksql.rest.entity.ServerInfo;
import io.confluent.ksql.rest.entity.ServerMetadata;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public final class KsqlRestClient
implements Closeable {
    static final String CCLOUD_CONNECT_USERNAME_HEADER = "X-Confluent-API-Key";
    static final String CCLOUD_CONNECT_PASSWORD_HEADER = "X-Confluent-API-Secret";
    private final KsqlClient client;
    private final LocalProperties localProperties;
    private final AtomicReference<String> serializedConsistencyVector;
    private final Optional<BasicCredentials> ccloudApiKey;
    private List<URI> serverAddresses;
    private boolean isCCloudServer;

    @Deprecated
    public static KsqlRestClient create(String serverAddress, Map<String, ?> localProps, Map<String, String> clientProps, Optional<BasicCredentials> creds) {
        return KsqlRestClient.create(serverAddress, localProps, clientProps, creds, Optional.empty(), (cprops, credz, lprops) -> new KsqlClient(cprops, credz, lprops, new HttpClientOptions(), Optional.of(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2))));
    }

    public static KsqlRestClient create(String serverAddress, Map<String, ?> localProps, Map<String, String> clientProps, Optional<BasicCredentials> creds, Optional<BasicCredentials> ccloudApiKey) {
        return KsqlRestClient.create(serverAddress, localProps, clientProps, creds, ccloudApiKey, (cprops, credz, lprops) -> new KsqlClient(cprops, credz, lprops, new HttpClientOptions(), Optional.of(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2))));
    }

    @VisibleForTesting
    static KsqlRestClient create(String serverAddress, Map<String, ?> localProps, Map<String, String> clientProps, Optional<BasicCredentials> creds, Optional<BasicCredentials> ccloudApiKey, KsqlClientSupplier clientSupplier) {
        LocalProperties localProperties = new LocalProperties(localProps);
        KsqlClient client = clientSupplier.get(clientProps, creds, localProperties);
        return new KsqlRestClient(client, serverAddress, localProperties, ccloudApiKey);
    }

    private KsqlRestClient(KsqlClient client, String serverAddress, LocalProperties localProps, Optional<BasicCredentials> ccloudApiKey) {
        this.client = Objects.requireNonNull(client, "client");
        this.serverAddresses = KsqlRestClient.parseServerAddresses(serverAddress);
        this.localProperties = Objects.requireNonNull(localProps, "localProps");
        this.ccloudApiKey = ccloudApiKey;
        this.serializedConsistencyVector = new AtomicReference();
        this.isCCloudServer = false;
    }

    public URI getServerAddress() {
        return this.serverAddresses.get(0);
    }

    public boolean getIsCCloudServer() {
        return this.isCCloudServer;
    }

    public boolean getHasCCloudApiKey() {
        return this.ccloudApiKey.isPresent();
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddresses = KsqlRestClient.parseServerAddresses(serverAddress);
    }

    public void setIsCCloudServer(boolean isCCloudServer) {
        this.isCCloudServer = isCCloudServer;
    }

    public RestResponse<ServerInfo> getServerInfo() {
        return this.target().getServerInfo();
    }

    public RestResponse<CommandStatus> getStatus(String commandId) {
        return this.target().getStatus(commandId);
    }

    public RestResponse<CommandStatuses> getAllStatuses() {
        return this.target().getStatuses();
    }

    public RestResponse<ServerMetadata> getServerMetadata() {
        return this.target().getServerMetadata();
    }

    public RestResponse<ServerClusterId> getServerMetadataId() {
        return this.target().getServerMetadataId();
    }

    public RestResponse<HealthCheckResponse> getServerHealth() {
        return this.target().getServerHealth();
    }

    public CompletableFuture<RestResponse<HeartbeatResponse>> makeAsyncHeartbeatRequest(KsqlHostInfoEntity host, long timestamp) {
        return this.target().postAsyncHeartbeatRequest(host, timestamp);
    }

    public RestResponse<ClusterStatusResponse> makeClusterStatusRequest() {
        return this.target().getClusterStatus();
    }

    public CompletableFuture<RestResponse<LagReportingResponse>> makeAsyncLagReportingRequest(LagReportingMessage lagReportingMessage) {
        return this.target().postAsyncLagReportingRequest(lagReportingMessage);
    }

    public RestResponse<KsqlEntityList> makeKsqlRequest(String ksql) {
        return this.target().postKsqlRequest(ksql, Collections.emptyMap(), Optional.empty());
    }

    public RestResponse<KsqlEntityList> makeKsqlRequest(String ksql, Long commandSeqNum) {
        return this.target().postKsqlRequest(ksql, Collections.emptyMap(), Optional.ofNullable(commandSeqNum));
    }

    public RestResponse<KsqlEntityList> makeConnectorRequest(String ksql, Long commandSeqNum) {
        return this.target(true).postKsqlRequest(ksql, Collections.emptyMap(), Optional.ofNullable(commandSeqNum));
    }

    public RestResponse<CommandStatuses> makeStatusRequest() {
        return this.target().getStatuses();
    }

    public RestResponse<CommandStatus> makeStatusRequest(String commandId) {
        return this.target().getStatus(commandId);
    }

    public RestResponse<Boolean> makeIsValidRequest(String propertyName) {
        return this.target().getIsValidRequest(propertyName);
    }

    public RestResponse<StreamPublisher<StreamedRow>> makeQueryRequestStreamed(String ksql, Long commandSeqNum) {
        return this.makeQueryRequestStreamed(ksql, commandSeqNum, null);
    }

    public RestResponse<StreamPublisher<StreamedRow>> makeQueryRequestStreamed(String ksql, Long commandSeqNum, Map<String, ?> properties) {
        return this.makeQueryRequestStreamed(ksql, commandSeqNum, properties, Collections.emptyMap());
    }

    public RestResponse<StreamPublisher<StreamedRow>> makeQueryRequestStreamed(String ksql, Long commandSeqNum, Map<String, ?> properties, Map<String, ?> requestProperties) {
        KsqlTarget target = this.target();
        Map<String, Object> requestPropertiesToSend = this.setConsistencyVector(requestProperties);
        if (properties != null) {
            target = target.properties(properties);
        }
        RestResponse<StreamPublisher<StreamedRow>> response = target.postQueryRequestStreamed(ksql, requestPropertiesToSend, Optional.ofNullable(commandSeqNum));
        return response;
    }

    @VisibleForTesting
    public CompletableFuture<RestResponse<StreamPublisher<StreamedRow>>> makeQueryRequestStreamedAsync(String ksql, Map<String, ?> properties) {
        KsqlTarget targetHttp2 = this.targetHttp2();
        if (!properties.isEmpty()) {
            targetHttp2 = targetHttp2.properties(properties);
        }
        return targetHttp2.postQueryRequestStreamedAsync(ksql, properties);
    }

    public RestResponse<List<StreamedRow>> makeQueryRequest(String ksql, Long commandSeqNum) {
        return this.makeQueryRequest(ksql, commandSeqNum, null, Collections.emptyMap());
    }

    public RestResponse<List<StreamedRow>> makeQueryRequest(String ksql, Long commandSeqNum, Map<String, ?> properties, Map<String, ?> requestProperties) {
        KsqlTarget target = this.target();
        if (properties != null) {
            target = target.properties(properties);
        }
        Map<String, Object> requestPropertiesToSend = this.setConsistencyVector(requestProperties);
        return target.postQueryRequest(ksql, requestPropertiesToSend, Optional.ofNullable(commandSeqNum));
    }

    public RestResponse<List<StreamedRow>> makeQueryStreamRequestProto(String ksql, Map<String, Object> requestProperties) {
        KsqlTarget target = this.target();
        return target.postQueryStreamRequestProto(ksql, requestProperties);
    }

    public RestResponse<StreamPublisher<String>> makePrintTopicRequest(String ksql, Long commandSeqNum) {
        return this.target().postPrintTopicRequest(ksql, Optional.ofNullable(commandSeqNum));
    }

    @Override
    public void close() {
        this.client.close();
    }

    public Object setProperty(String property, Object value) {
        return this.localProperties.set(property, value);
    }

    public Object unsetProperty(String property) {
        return this.localProperties.unset(property);
    }

    public Object getProperty(String property) {
        return this.localProperties.get(property);
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public AtomicReference<String> getSerializedConsistencyVector() {
        return this.serializedConsistencyVector;
    }

    private KsqlTarget target() {
        return this.target(false);
    }

    private KsqlTarget target(boolean includeConnectorHeaders) {
        Map<String, String> additionalHeaders = includeConnectorHeaders && this.isCCloudServer ? this.ccloudConnectorHeaders() : Collections.emptyMap();
        return this.client.target(this.getServerAddress(), additionalHeaders);
    }

    private KsqlTarget targetHttp2() {
        return this.client.targetHttp2(this.getServerAddress());
    }

    private Map<String, String> ccloudConnectorHeaders() {
        if (!this.ccloudApiKey.isPresent()) {
            throw new IllegalStateException("Should not request headers if no credentials provided.");
        }
        return ImmutableMap.of((Object)CCLOUD_CONNECT_USERNAME_HEADER, (Object)this.ccloudApiKey.get().username(), (Object)CCLOUD_CONNECT_PASSWORD_HEADER, (Object)this.ccloudApiKey.get().password());
    }

    private static List<URI> parseServerAddresses(String serverAddresses) {
        Objects.requireNonNull(serverAddresses, "serverAddress");
        return ImmutableList.copyOf((Collection)Arrays.stream(serverAddresses.split(",")).map(String::trim).map(KsqlRestClient::parseUri).collect(Collectors.toList()));
    }

    private static URI parseUri(String serverAddress) {
        try {
            URL url = new URL(serverAddress);
            if (url.getPort() == -1) {
                return new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getFile()).toURI();
            }
            return url.toURI();
        }
        catch (Exception e) {
            throw new KsqlRestClientException("The supplied serverAddress is invalid: " + serverAddress, e);
        }
    }

    private Map<String, Object> setConsistencyVector(Map<String, ?> requestProperties) {
        HashMap<String, Object> requestPropertiesToSend = new HashMap<String, Object>();
        if (requestProperties != null) {
            requestPropertiesToSend.putAll(requestProperties);
        }
        return requestPropertiesToSend;
    }

    @FunctionalInterface
    static interface KsqlClientSupplier {
        public KsqlClient get(Map<String, String> var1, Optional<BasicCredentials> var2, LocalProperties var3);
    }
}

