/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.client.KsqlClientUtil;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.BytesUtils;
import io.confluent.ksql.util.Pair;
import io.vertx.core.buffer.Buffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class KsqlTargetUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private KsqlTargetUtil() {
    }

    public static List<StreamedRow> toRows(Buffer buff, Function<StreamedRow, StreamedRow> addHostInfo) {
        ArrayList<StreamedRow> rows = new ArrayList<StreamedRow>();
        int begin = 0;
        for (int i = 0; i <= buff.length(); ++i) {
            Buffer sliced;
            Buffer tidied;
            if ((i != buff.length() || i - begin <= 1) && (i >= buff.length() || buff.getByte(i) != 10)) continue;
            if (begin != i && (tidied = BytesUtils.toJsonMsg((Buffer)(sliced = buff.slice(begin, i)), (boolean)true)).length() > 0) {
                StreamedRow row = KsqlClientUtil.deserialize(tidied, StreamedRow.class);
                rows.add(addHostInfo.apply(row));
            }
            begin = i + 1;
        }
        return rows;
    }

    public static StreamedRow toRowFromDelimited(Buffer buff) {
        try {
            QueryResponseMetadata metadata = KsqlClientUtil.deserialize(buff, QueryResponseMetadata.class);
            return StreamedRow.header((QueryId)new QueryId(Strings.nullToEmpty((String)metadata.queryId)), (LogicalSchema)KsqlTargetUtil.createSchema(metadata));
        }
        catch (KsqlRestClientException metadata) {
            try {
                KsqlErrorMessage error = KsqlClientUtil.deserialize(buff, KsqlErrorMessage.class);
                return StreamedRow.error((Throwable)new RuntimeException(error.getMessage()), (int)error.getErrorCode());
            }
            catch (KsqlRestClientException error) {
                try {
                    PushContinuationToken continuationToken = KsqlClientUtil.deserialize(buff, PushContinuationToken.class);
                    return StreamedRow.continuationToken((PushContinuationToken)continuationToken);
                }
                catch (KsqlRestClientException continuationToken) {
                    try {
                        List row = KsqlClientUtil.deserialize(buff, List.class);
                        return StreamedRow.pushRow((GenericRow)GenericRow.fromList((List)row));
                    }
                    catch (KsqlRestClientException ksqlRestClientException) {
                        throw new IllegalStateException("Couldn't parse message: " + buff.toString());
                    }
                }
            }
        }
    }

    private static LogicalSchema createSchema(QueryResponseMetadata metadata) {
        SqlTypeParser parser = SqlTypeParser.create((TypeRegistry)TypeRegistry.EMPTY);
        return LogicalSchema.builder().valueColumns((Iterable)Streams.zip(metadata.columnNames.stream(), metadata.columnTypes.stream(), Pair::of).map(pair -> {
            final SqlType sqlType = parser.parse((String)pair.getRight()).getSqlType();
            final ColumnName name = ColumnName.of((String)((String)pair.getLeft()));
            return new SimpleColumn(){

                public ColumnName name() {
                    return name;
                }

                public SqlType type() {
                    return sqlType;
                }
            };
        }).collect(Collectors.toList())).build();
    }
}

