/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.rest.client.ResponseWithBody;
import io.confluent.ksql.util.BytesUtils;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class StreamPublisher<T>
extends BufferedPublisher<T> {
    private final HttpClientResponse response;
    private boolean drainHandlerSet;

    StreamPublisher(Context context, HttpClientResponse response, Function<Buffer, T> mapper, CompletableFuture<ResponseWithBody> bodyFuture, boolean stripArray) {
        super(context);
        this.response = response;
        RecordParser recordParser = RecordParser.newDelimited((String)"\n", (ReadStream)response);
        recordParser.exceptionHandler(bodyFuture::completeExceptionally).handler(buff -> {
            if (buff.length() == 0) {
                return;
            }
            Buffer jsonMsg = BytesUtils.toJsonMsg((Buffer)buff, (boolean)stripArray);
            if (!this.accept(mapper.apply(jsonMsg)) && !this.drainHandlerSet) {
                recordParser.pause();
                this.drainHandlerSet = true;
                this.drainHandler(() -> {
                    this.drainHandlerSet = false;
                    recordParser.resume();
                });
            }
        }).endHandler(v -> this.complete());
        response.request().connection().closeHandler(v -> this.complete());
    }

    public Future<Void> close() {
        return this.response.request().connection().close();
    }
}

