/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.common.RangeRestriction;
import com.github.rvesse.airline.utils.comparators.ByteComparator;
import com.github.rvesse.airline.utils.comparators.DoubleComparator;
import com.github.rvesse.airline.utils.comparators.FloatComparator;
import com.github.rvesse.airline.utils.comparators.IntegerComparator;
import com.github.rvesse.airline.utils.comparators.LongComparator;
import com.github.rvesse.airline.utils.comparators.ShortComparator;

public class PositiveNegativeRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final RangeRestriction byteRestrictor;
    private final RangeRestriction shortRestrictor;
    private final RangeRestriction integerRestrictor;
    private final RangeRestriction longRestrictor;
    private final RangeRestriction floatRestrictor;
    private final RangeRestriction doubleRestrictor;
    private final boolean positive;
    private final boolean includeZero;
    private final String type;
    private final String range;

    public PositiveNegativeRestriction(boolean positive, boolean includeZero) {
        this.positive = positive;
        this.includeZero = includeZero;
        String string = this.type = this.positive ? "positive" : "negative";
        String comparator = this.positive ? (this.includeZero ? ">=" : ">") : (this.includeZero ? "<=" : "<");
        this.range = String.format("value %s 0", comparator);
        if (this.positive) {
            this.byteRestrictor = new RangeRestriction((byte)0, includeZero, (byte)127, true, new ByteComparator());
            this.shortRestrictor = new RangeRestriction((short)0, includeZero, (short)Short.MAX_VALUE, true, new ShortComparator());
            this.integerRestrictor = new RangeRestriction(0, includeZero, Integer.MAX_VALUE, true, new IntegerComparator());
            this.longRestrictor = new RangeRestriction(0L, includeZero, Long.MAX_VALUE, true, new LongComparator());
            this.floatRestrictor = new RangeRestriction(Float.valueOf(0.0f), includeZero, Float.valueOf(Float.MAX_VALUE), true, new FloatComparator());
            this.doubleRestrictor = new RangeRestriction(0.0, includeZero, Double.MAX_VALUE, true, new DoubleComparator());
        } else {
            this.byteRestrictor = new RangeRestriction((byte)-128, true, (byte)0, includeZero, new ByteComparator());
            this.shortRestrictor = new RangeRestriction((short)Short.MIN_VALUE, true, (short)0, includeZero, new ShortComparator());
            this.integerRestrictor = new RangeRestriction(Integer.MIN_VALUE, true, 0, includeZero, new IntegerComparator());
            this.longRestrictor = new RangeRestriction(Long.MIN_VALUE, true, 0L, includeZero, new LongComparator());
            this.floatRestrictor = new RangeRestriction(Float.valueOf(Float.MIN_VALUE), true, Float.valueOf(0.0f), includeZero, new FloatComparator());
            this.doubleRestrictor = new RangeRestriction(Double.MIN_VALUE, true, 0.0, includeZero, new DoubleComparator());
        }
    }

    protected boolean isValid(Object value) {
        if (value instanceof Byte) {
            return this.byteRestrictor.inRange(value);
        }
        if (value instanceof Short) {
            return this.shortRestrictor.inRange(value);
        }
        if (value instanceof Integer) {
            return this.integerRestrictor.inRange(value);
        }
        if (value instanceof Long) {
            return this.longRestrictor.inRange(value);
        }
        if (value instanceof Float) {
            return this.floatRestrictor.inRange(value);
        }
        if (value instanceof Double) {
            return this.doubleRestrictor.inRange(value);
        }
        return false;
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
        if (!this.isValid(value)) {
            throw new ParseRestrictionViolatedException("Option '%s' must have a %s value (%s) but got %s", option.getTitle(), this.type, this.range, value);
        }
    }

    @Override
    public <T> void postValidate(ParseState<T> state, ArgumentsMetadata arguments, Object value) {
        if (!this.isValid(value)) {
            throw new ParseRestrictionViolatedException("Option '%s' must have a %s value (%s) but got %s", AbstractCommonRestriction.getArgumentTitle(state, arguments), this.type, this.range, value);
        }
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This options value must be a %s value i.e. respects the range %s", this.type, this.range)};
    }
}

