/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkSourceMetrics;

public class MultiTenantInterceptor
implements BrokerInterceptor {
    private final Time time;
    private final TenantMetrics tenantMetrics;
    private Optional<ClusterLinkSourceMetrics> clusterLinkSourceMetrics;
    private MultiTenantInterceptorConfig multiTenantInterceptorConfig;
    private boolean clusterLinkMetricReductionEnabled;
    private boolean recordApiVersionsRequests;

    public MultiTenantInterceptor() {
        this(Time.SYSTEM);
    }

    public MultiTenantInterceptor(Time time) {
        this.time = time;
        this.tenantMetrics = new TenantMetrics();
        this.clusterLinkSourceMetrics = Optional.empty();
    }

    public void onAuthenticatedConnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
        if (!(principal instanceof MultiTenantPrincipal)) {
            throw new IllegalStateException("Not a tenant connection");
        }
        this.tenantMetrics.recordAuthenticatedConnection(metrics, (MultiTenantPrincipal)principal, clientAddress);
    }

    public void onAuthenticatedDisconnection(String connectionId, InetAddress clientAddress, KafkaPrincipal principal, Metrics metrics) {
        this.tenantMetrics.recordAuthenticatedDisconnection();
    }

    public void onFailedAuthentication(String connectionId, InetAddress clientAddress, Metrics metrics) {
        this.tenantMetrics.recordFailedAuthentication(metrics, clientAddress);
    }

    public void onApiVersionsRequest(ClientInformation clientInformation, String clientId, KafkaPrincipal principal, Metrics metrics) {
        if (principal instanceof MultiTenantPrincipal) {
            if (this.recordApiVersionsRequests) {
                this.tenantMetrics.recordClientInformation(metrics, (MultiTenantPrincipal)principal, clientInformation, clientId);
            }
        } else {
            throw new IllegalStateException("Not a tenant connection");
        }
    }

    public void configure(Map<String, ?> configs) {
        this.multiTenantInterceptorConfig = new MultiTenantInterceptorConfig(configs);
        this.clusterLinkMetricReductionEnabled = ConfluentConfigs.clusterLinkMetricReductionEnabled(configs);
        this.recordApiVersionsRequests = ConfluentConfigs.multiTenantInterceptorCollectApiVersionsEnabled(configs);
    }

    public RequestContext newContext(RequestHeader header, String connectionId, long requestId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, Metrics metrics, PathAwareSniHostName sniHostName, boolean isPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde, AuthenticationContext authenticationContext, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker, boolean isProxyModeLocal) {
        if (!(principal instanceof MultiTenantPrincipal)) {
            throw new IllegalArgumentException("Unexpected principal type " + principal);
        }
        MultiTenantPrincipal tenantPrincipal = (MultiTenantPrincipal)principal;
        header.clusterLinkId().ifPresent(linkId -> {
            this.clusterLinkSourceMetrics.ifPresent(linkMetrics -> linkMetrics.ensureLinkId(linkId));
            if (!this.clusterLinkSourceMetrics.isPresent()) {
                HashMap<String, String> tenantTags = new HashMap<String, String>();
                tenantTags.put("tenant", tenantPrincipal.tenantMetadata().tenantName);
                String sensorSuffix = String.format(":%s-%s", "tenant", tenantPrincipal.tenantMetadata().tenantName);
                this.clusterLinkSourceMetrics = Optional.of(new ClusterLinkSourceMetrics(metrics, linkId, tenantTags, sensorSuffix, this.clusterLinkMetricReductionEnabled));
            }
        });
        return new MultiTenantRequestContext(header, connectionId, requestId, clientAddress, (MultiTenantPrincipal)principal, listenerName, securityProtocol, clientInformation, sniHostName, this.time, metrics, this.tenantMetrics, this.multiTenantInterceptorConfig, this.clusterLinkSourceMetrics, isPrivilegedListener, principalSerde, authenticationContext, produceConsumeAuditLogTracker, isProxyModeLocal);
    }
}

