/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.ZoneUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;

public class MultiTenantInterceptorConfig {
    public static final MultiTenantInterceptorConfig DEFAULT = new MultiTenantInterceptorConfig(false, false, false, ConfluentConfigs.MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT, null, null, ConfluentConfigs.VALID_BROKER_RACK_SET_DEFAULT, MultiTenantInterceptorConfig.mapConfig("confluent.subdomain.separator.map", ConfluentConfigs.SUBDOMAIN_SEPARATOR_MAP_DEFAULT), "%sep", false);
    private final boolean clusterPrefixForHostnameEnabled;
    private final boolean schemaValidationEnabled;
    private final boolean sbcApisEnabled;
    private final String brokerRack;
    private final Set<String> validBrokerRackSet;
    private final boolean isFetchFromFollowerEnabled;
    private final boolean shouldAppendSubdomainToHostname;
    private final Map<String, String> subdomainSeparatorMap;
    private final String subdomainSeparatorVariable;
    private final boolean fetchFromFollowerRequireLeaderEpochEnabled;

    public MultiTenantInterceptorConfig(Map<String, ?> configs) {
        this(MultiTenantInterceptorConfig.boolConfig(configs, "confluent.multitenant.listener.hostname.cluster.prefix.enable"), MultiTenantInterceptorConfig.boolConfig(configs, "confluent.schema.validator.multitenant.enable"), MultiTenantInterceptorConfig.boolConfig(configs, "confluent.multitenant.interceptor.balancer.apis.enabled"), MultiTenantInterceptorConfig.boolConfig(configs, "confluent.multitenant.listener.hostname.subdomain.suffix.enable"), (String)configs.get(KafkaConfig.ReplicaSelectorClassProp()), (String)configs.get(KafkaConfig.RackProp()), (String)configs.get("confluent.valid.broker.rack.set"), MultiTenantInterceptorConfig.mapConfig("confluent.subdomain.separator.map", (String)configs.get("confluent.subdomain.separator.map")), (String)configs.get("confluent.subdomain.separator.variable"), MultiTenantInterceptorConfig.boolConfig(configs, "confluent.fetch.from.follower.require.leader.epoch.enable"));
    }

    public MultiTenantInterceptorConfig(boolean clusterPrefixForHostnameEnabled, boolean schemaValidationEnabled, boolean sbcApisEnabled, boolean shouldAppendSubdomainToHostname, String replicaSelectorClass, String brokerRack, String validBrokerRackList, Map<String, String> subdomainSeparatorMap, String subdomainSeparatorVariable, boolean fetchFromFollowerRequireLeaderEpochEnabled) {
        this.clusterPrefixForHostnameEnabled = clusterPrefixForHostnameEnabled;
        this.schemaValidationEnabled = schemaValidationEnabled;
        this.sbcApisEnabled = sbcApisEnabled;
        this.shouldAppendSubdomainToHostname = shouldAppendSubdomainToHostname;
        this.brokerRack = brokerRack;
        this.validBrokerRackSet = ZoneUtils.getValidBrokerRackSet((String)validBrokerRackList);
        this.isFetchFromFollowerEnabled = ZoneUtils.isFetchFromFollowerEnabled((String)replicaSelectorClass, (String)brokerRack, this.validBrokerRackSet);
        this.subdomainSeparatorMap = subdomainSeparatorMap;
        this.subdomainSeparatorVariable = subdomainSeparatorVariable;
        this.fetchFromFollowerRequireLeaderEpochEnabled = fetchFromFollowerRequireLeaderEpochEnabled;
    }

    public boolean isClusterPrefixForHostnameEnabled() {
        return this.clusterPrefixForHostnameEnabled;
    }

    public boolean isFetchFromFollowerRequireLeaderEpochEnabled() {
        return this.fetchFromFollowerRequireLeaderEpochEnabled;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidationEnabled;
    }

    public boolean sbcApisEnabled() {
        return this.sbcApisEnabled;
    }

    public boolean shouldAppendSubdomainToHostname() {
        return this.shouldAppendSubdomainToHostname;
    }

    public Map<String, String> subdomainSeparatorMap() {
        return this.subdomainSeparatorMap;
    }

    public String subdomainSeparatorVariable() {
        return this.subdomainSeparatorVariable;
    }

    public String brokerRack() {
        return this.brokerRack;
    }

    public Set<String> validBrokerRackSet() {
        return this.validBrokerRackSet;
    }

    public boolean isFetchFromFollowerEnabled() {
        return this.isFetchFromFollowerEnabled;
    }

    public static int intConfig(Map<String, ?> configs, String configName) {
        Object configValue = configs.get(configName);
        if (configValue == null) {
            throw new ConfigException(configName + " is not set");
        }
        return Integer.parseInt(configValue.toString());
    }

    private static boolean boolConfig(Map<String, ?> configs, String configName) {
        Object configValue = configs.get(configName);
        if (configValue == null) {
            throw new ConfigException(configName + " is not set");
        }
        return Boolean.parseBoolean(configValue.toString());
    }

    private static Map<String, String> mapConfig(String configName, String configVal) {
        if (configVal == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> mapVal = new HashMap<String, String>();
        for (String config : configVal.split(",")) {
            String[] entry = config.split(":");
            if (entry.length != 2) {
                throw new ConfigException("invalid format for config " + configName);
            }
            mapVal.put(entry[0].trim(), entry[1].trim());
        }
        return mapVal;
    }
}

