/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.TenantMetadata;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;

public class UserTenantPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde {
    private final MultiTenantPrincipalBuilder multiTenantPrincipalBuilder = new MultiTenantPrincipalBuilder();

    public KafkaPrincipal build(AuthenticationContext authenticationContext) {
        String user = KafkaPrincipal.ANONYMOUS.getName();
        boolean apiKeyAuthenticated = false;
        if (authenticationContext instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)authenticationContext).server();
            user = saslServer.getAuthorizationID();
            apiKeyAuthenticated = !(saslServer instanceof OAuthBearerSaslServer);
        }
        TenantMetadata tenantMetadata = new TenantMetadata.Builder(user, "u-" + user).apiKeyAuthenticated(apiKeyAuthenticated).serviceAccount(true).healthcheckTenant(false).build();
        return new MultiTenantPrincipal(user, user, tenantMetadata);
    }

    public byte[] serialize(KafkaPrincipal principal) throws SerializationException {
        return this.multiTenantPrincipalBuilder.serialize(principal);
    }

    public KafkaPrincipal deserialize(byte[] bytes) throws SerializationException {
        return this.multiTenantPrincipalBuilder.deserialize(bytes);
    }
}

