/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.assignor.RackMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterMetadata
implements RackMetadata {
    private static final Logger log = LoggerFactory.getLogger(ClusterMetadata.class);
    private final String tenant;
    private final ClusterDescriber cluster;
    private final Map<Integer, NodeMetadata> nodeMetadatas;
    private boolean rackAware;
    private final Set<Integer> eligibleBrokers;
    private final Set<Integer> excludedBrokerIds;
    private final Map<Integer, String> brokerRackMap;
    private final Map<Integer, Integer> brokerCellMap;
    private final Map<Integer, Set<Integer>> cellEligibleBrokerMap;
    private final PartitionPlacementStrategy targetPlacementStrategy;

    ClusterMetadata(String tenant, ClusterDescriber cluster, Set<Integer> excludedBrokerIds, PartitionPlacementStrategy targetPlacementStrategy) {
        this(tenant, cluster, ClusterMetadata.usableBrokers(cluster.usableBrokers()), excludedBrokerIds, cluster.getTenantCellId(tenant), targetPlacementStrategy);
    }

    private ClusterMetadata(String tenant, ClusterDescriber cluster, List<UsableBroker> brokers, Set<Integer> excludedBrokerIds, int targetCellId, PartitionPlacementStrategy targetPlacementStrategy) {
        this.cluster = cluster;
        this.tenant = tenant;
        this.nodeMetadatas = this.nodeMetadata();
        this.excludedBrokerIds = excludedBrokerIds;
        this.targetPlacementStrategy = targetPlacementStrategy;
        this.eligibleBrokers = ClusterMetadata.calculateEligibleBrokers(brokers, excludedBrokerIds, this.targetPlacementStrategy, targetCellId);
        this.rackAware = brokers.stream().allMatch(b -> b.rack().isPresent());
        this.brokerRackMap = this.rackAware ? brokers.stream().collect(Collectors.toMap(UsableBroker::id, b -> (String)b.rack().get())) : new HashMap<Integer, String>();
        this.brokerCellMap = brokers.stream().filter(b -> b.cell() != -1).collect(Collectors.toMap(UsableBroker::id, UsableBroker::cell));
        this.cellEligibleBrokerMap = brokers.stream().filter(b -> this.brokerCellMap.containsKey(b.id()) && this.eligibleBrokers.contains(b.id())).collect(Collectors.groupingBy(UsableBroker::cell, Collectors.mapping(UsableBroker::id, Collectors.toSet())));
    }

    public Set<Integer> excludedBrokerIds() {
        return this.excludedBrokerIds;
    }

    @Override
    public String rackForBroker(int brokerId) {
        return this.brokerRackMap.get(brokerId);
    }

    public int cellForBroker(int brokerId) {
        return this.brokerCellMap.getOrDefault(brokerId, -1);
    }

    Set<Integer> eligibleBrokers() {
        return this.eligibleBrokers;
    }

    Set<Integer> eligibleBrokersFromCell(int cellId) {
        return this.cellEligibleBrokerMap.getOrDefault(cellId, new HashSet());
    }

    boolean isBrokerEligibleForReplicaPlacement(int brokerId) {
        return this.eligibleBrokers.contains(brokerId);
    }

    boolean rackAware() {
        return this.rackAware;
    }

    boolean partitionCellAware() {
        return this.targetPlacementStrategy == PartitionPlacementStrategy.PARTITION_IN_CELL;
    }

    boolean tenantCellAware() {
        return this.targetPlacementStrategy == PartitionPlacementStrategy.TENANT_IN_CELL;
    }

    boolean brokersInSameCell(Integer brokerA, Integer brokerB) {
        if (this.partitionCellAware() || this.tenantCellAware()) {
            return this.brokerCellMap.get(brokerA).equals(this.brokerCellMap.get(brokerB));
        }
        return true;
    }

    NodeReplicaCounter nodeReplicaCounts(List<List<Integer>> existingPartitions) {
        HashMap<Integer, ReplicaCounts> leaderCount = new HashMap<Integer, ReplicaCounts>(this.nodeMetadatas.size());
        HashMap<Integer, ReplicaCounts> followerCount = new HashMap<Integer, ReplicaCounts>(this.nodeMetadatas.size());
        for (Boolean leader : Arrays.asList(false, true)) {
            HashMap<Integer, ReplicaCounts> nodeReplicaCounts = leader != false ? leaderCount : followerCount;
            for (Map.Entry<Integer, NodeMetadata> entry : this.nodeMetadatas.entrySet()) {
                Integer nodeId = entry.getKey();
                NodeMetadata nodeMetadata = entry.getValue();
                int tenantCount = leader != false ? nodeMetadata.tenantLeaders : nodeMetadata.tenantFollowers;
                int totalCount = leader != false ? nodeMetadata.totalLeaders : nodeMetadata.totalFollowers;
                ReplicaCounts replicaCounts = new ReplicaCounts(tenantCount, totalCount);
                nodeReplicaCounts.put(nodeId, replicaCounts);
            }
            for (List list : existingPartitions) {
                for (int i = 0; i < list.size(); ++i) {
                    Integer replica = (Integer)list.get(i);
                    ReplicaCounts replicaCounts = (ReplicaCounts)nodeReplicaCounts.get(replica);
                    if (replicaCounts == null) {
                        throw new IllegalStateException("Inconsistent cluster metadata, broker not found");
                    }
                    if ((i != 0 || !leader.booleanValue()) && (i == 0 || leader.booleanValue())) continue;
                    ++replicaCounts.topic;
                }
            }
        }
        return new NodeReplicaCounter(leaderCount, followerCount);
    }

    void updateNodeMetadata(List<List<Integer>> assignment) {
        for (List<Integer> replicas : assignment) {
            for (int i = 0; i < replicas.size(); ++i) {
                NodeMetadata nodeMetadata = this.nodeMetadatas.get(replicas.get(i));
                if (nodeMetadata == null) {
                    throw new IllegalStateException("Inconsistent cluster metadata: replica node " + replicas.get(i) + " not found");
                }
                nodeMetadata.incrementReplicas(i == 0, true);
            }
        }
    }

    private Map<Integer, NodeMetadata> nodeMetadata() {
        HashMap<Integer, NodeMetadata> nodeMetadatas = new HashMap<Integer, NodeMetadata>();
        Iterator iterator = this.cluster.usableBrokers();
        while (iterator.hasNext()) {
            UsableBroker broker = (UsableBroker)iterator.next();
            nodeMetadatas.put(broker.id(), new NodeMetadata());
        }
        String tenantPrefix = this.tenant + "_";
        Iterator iterator2 = this.cluster.topicNames();
        while (iterator2.hasNext()) {
            String topic = (String)iterator2.next();
            boolean isTenantTopic = topic.startsWith(tenantPrefix);
            for (List replicas : this.cluster.replicasForTopicName(topic)) {
                for (int i = 0; i < replicas.size(); ++i) {
                    Integer replica = (Integer)replicas.get(i);
                    NodeMetadata nodeMetadata = nodeMetadatas.computeIfAbsent(replica, node -> new NodeMetadata());
                    nodeMetadata.incrementReplicas(i == 0, isTenantTopic);
                }
            }
        }
        return nodeMetadatas;
    }

    private static List<UsableBroker> usableBrokers(Iterator<UsableBroker> usableBrokers) {
        ArrayList<UsableBroker> result = new ArrayList<UsableBroker>();
        usableBrokers.forEachRemaining(result::add);
        return result;
    }

    private static Set<Integer> calculateEligibleBrokers(List<UsableBroker> nodes, Set<Integer> excludedBrokerIds, PartitionPlacementStrategy placement, int targetCellId) {
        return nodes.stream().filter(node -> !excludedBrokerIds.contains(node.id()) && !node.fenced()).filter(node -> placement != PartitionPlacementStrategy.TENANT_IN_CELL || targetCellId != -1 && targetCellId == node.cell()).map(UsableBroker::id).collect(Collectors.toSet());
    }

    class NodeReplicaCounter {
        private final Map<Integer, ReplicaCounts> leaderReplicaCounts;
        private final Map<Integer, ReplicaCounts> followerReplicaCounts;

        public NodeReplicaCounter(Map<Integer, ReplicaCounts> leaderReplicaCounts, Map<Integer, ReplicaCounts> followerReplicaCounts) {
            this.leaderReplicaCounts = new HashMap<Integer, ReplicaCounts>(leaderReplicaCounts);
            this.followerReplicaCounts = new HashMap<Integer, ReplicaCounts>(followerReplicaCounts);
        }

        public void incrementLeader(int brokerId) {
            this.leaderReplicaCounts.get(brokerId).incrementCounts();
        }

        public void incrementFollower(int brokerId) {
            this.followerReplicaCounts.get(brokerId).incrementCounts();
        }

        public List<Integer> orderLeaderNodes() {
            return this.orderLeaderNodes(this.leaderReplicaCounts.keySet());
        }

        public List<Integer> orderLeaderNodes(Set<Integer> eligibleNodes) {
            return this.orderNodes(eligibleNodes, this.leaderReplicaCounts);
        }

        public List<Integer> orderFollowerNodes() {
            return this.orderFollowerNodes(this.followerReplicaCounts.keySet());
        }

        public List<Integer> orderFollowerNodes(Set<Integer> eligibleNodes) {
            return this.orderNodes(eligibleNodes, this.followerReplicaCounts);
        }

        private List<Integer> orderNodes(Set<Integer> eligibleNodes, Map<Integer, ReplicaCounts> nodeReplicaCounts) {
            ArrayList<Integer> orderedNodes = new ArrayList<Integer>(eligibleNodes);
            orderedNodes.sort(Comparator.comparing(nodeReplicaCounts::get));
            return orderedNodes;
        }

        ReplicaCounts leaderCount(int brokerId) {
            return this.leaderReplicaCounts.get(brokerId);
        }

        ReplicaCounts followerCount(int brokerId) {
            return this.followerReplicaCounts.get(brokerId);
        }
    }

    static class ReplicaCounts
    implements Comparable<ReplicaCounts> {
        int topic;
        int tenant;
        int total;

        ReplicaCounts(int tenant, int total) {
            this(tenant, total, 0);
        }

        ReplicaCounts(int tenant, int total, int topic) {
            this.tenant = tenant;
            this.total = total;
            this.topic = topic;
        }

        void incrementCounts() {
            ++this.topic;
            ++this.tenant;
            ++this.total;
        }

        @Override
        public int compareTo(ReplicaCounts o) {
            int result = Integer.compare(this.topic, o.topic);
            if (result == 0) {
                result = Integer.compare(this.tenant, o.tenant);
            }
            if (result == 0) {
                result = Integer.compare(this.total, o.total);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaCounts that = (ReplicaCounts)o;
            return Objects.equals(this.topic, that.topic) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.total, that.total);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.tenant, this.total);
        }

        public String toString() {
            return "ReplicaCounts(topic=" + this.topic + ", tenant=" + this.tenant + ", total=" + this.total + ')';
        }
    }

    private static class NodeMetadata {
        int tenantLeaders;
        int tenantFollowers;
        int totalLeaders;
        int totalFollowers;

        private NodeMetadata() {
        }

        void incrementReplicas(boolean isLeaderReplica, boolean isTenantTopic) {
            if (isLeaderReplica) {
                this.incrementLeaders(isTenantTopic);
            } else {
                this.incrementFollowers(isTenantTopic);
            }
        }

        void incrementLeaders(boolean isTenantTopic) {
            ++this.totalLeaders;
            if (isTenantTopic) {
                ++this.tenantLeaders;
            }
        }

        void incrementFollowers(boolean isTenantTopic) {
            ++this.totalFollowers;
            if (isTenantTopic) {
                ++this.tenantFollowers;
            }
        }
    }
}

