/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.metrics.AbstractConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.server.metrics.AbstractSensorCreator;

public class ConnectionInformationSensorBuilder
extends AbstractConnectionSensorBuilder {
    private static final String CONNECTION_INFO = "connection-info";
    private static final Map<String, AbstractSensorCreator> CONNECTION_INFO_SENSOR_CREATORS = new HashMap<String, AbstractSensorCreator>();

    public ConnectionInformationSensorBuilder(Metrics metrics, MultiTenantPrincipal principal, ClientInformation clientInformation, String clientId) {
        super(metrics, new TenantMetrics.TenantConnectionInformationMetricsContext(principal, clientInformation, clientId));
    }

    public ConnectionSensors build() {
        Map sensors = this.getOrCreateSuffixedSensors();
        return new ConnectionSensors((Sensor)sensors.get(CONNECTION_INFO), (Sensor)sensors.get(CONNECTION_INFO));
    }

    protected Map<String, ? extends AbstractSensorCreator> sensorCreators() {
        return CONNECTION_INFO_SENSOR_CREATORS;
    }

    static {
        CONNECTION_INFO_SENSOR_CREATORS.put(CONNECTION_INFO, new AbstractConnectionSensorBuilder.ConnectionMeterSensorCreator(CONNECTION_INFO, CONNECTION_INFO));
    }
}

