/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.requests.ApiError;

public class BrokerReplicaExclusionResult {
    private final int brokerId;
    private final Optional<ApiError> apiErrorOpt;
    private final ExclusionOp.OpType opType;
    private final String reason;

    public BrokerReplicaExclusionResult(int brokerId, Optional<ApiError> apiErrorOpt, ExclusionOp.OpType opType, String reason) {
        this.brokerId = brokerId;
        this.apiErrorOpt = apiErrorOpt;
        this.opType = opType;
        this.reason = reason;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Optional<ApiError> apiErrorOptional() {
        return this.apiErrorOpt;
    }

    public ExclusionOp.OpType opType() {
        return this.opType;
    }

    public String reason() {
        return this.reason;
    }

    public String toString() {
        return "BrokerReplicaExclusionResult{brokerId=" + this.brokerId + ", apiErrorOpt=" + this.apiErrorOpt + ", opType=" + this.opType + ", reason='" + this.reason + '\'' + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerReplicaExclusionResult that = (BrokerReplicaExclusionResult)o;
        return this.brokerId == that.brokerId && Objects.equals(this.apiErrorOpt, that.apiErrorOpt) && this.opType == that.opType && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.brokerId, this.apiErrorOpt, this.opType, this.reason);
    }
}

